/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;
import org.betterx.betterend.integration.jei.JEIAlloyingCategory;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.ui.layout.values.Rectangle;
import org.jetbrains.annotations.Unmodifiable;

public class JEIAlloyingFuelCategory
implements IRecipeCategory<IJeiFuelingRecipe> {
    public static final RecipeType FUEL_TYPE = RecipeType.create((String)"betterend", (String)"alloying_fuel", IJeiFuelingRecipe.class);
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final class_2561 localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFlames;
    private final Rectangle textArea;

    public static List<IJeiFuelingRecipe> getFuelRecipes(IIngredientManager ingredientManager) {
        return ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK).stream().mapMulti((stack, consumer) -> {
            int time;
            if (EndStoneSmelterBlockEntity.canUseAsFuel(stack) && (time = EndStoneSmelterBlockEntity.getFuelTime(stack)) > 0) {
                final List<class_1799> inputs = List.of(stack);
                consumer.accept(new IJeiFuelingRecipe(){

                    public @Unmodifiable List<class_1799> getInputs() {
                        return inputs;
                    }

                    public int getBurnTime() {
                        return time;
                    }
                });
            }
        }).sorted(Comparator.comparingInt(IJeiFuelingRecipe::getBurnTime)).toList();
    }

    public JEIAlloyingFuelCategory(final IGuiHelper guiHelper) {
        class_310 minecraft = class_310.method_1551();
        class_327 fontRenderer = minecraft.field_1772;
        class_2561 maxSmeltCountText = JEIAlloyingFuelCategory.createSmeltCountText(2000000000);
        int maxStringWidth = fontRenderer.method_1727(maxSmeltCountText.getString());
        int backgroundHeight = 34;
        int textPadding = 20;
        this.background = guiHelper.drawableBuilder(JEIAlloyingCategory.RECIPE_GUI_VANILLA, 0, 134, 18, backgroundHeight).addPadding(0, 0, 0, textPadding + maxStringWidth).build();
        this.textArea = new Rectangle(20, 0, textPadding + maxStringWidth, backgroundHeight);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EndBlocks.END_STONE_SMELTER));
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.fuel");
        this.cachedFlames = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer burnTime) {
                return guiHelper.drawableBuilder(JEIAlloyingCategory.RECIPE_GUI_VANILLA, 82, 114, 14, 14).buildAnimated(burnTime.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public RecipeType<IJeiFuelingRecipe> getRecipeType() {
        return FUEL_TYPE;
    }

    public class_2561 getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks(recipe.getInputs());
    }

    public void draw(IJeiFuelingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        int burnTime = recipe.getBurnTime();
        IDrawableAnimated flame = (IDrawableAnimated)this.cachedFlames.getUnchecked((Object)burnTime);
        flame.draw(poseStack, 1, 0);
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        class_2561 smeltCountText = JEIAlloyingFuelCategory.createSmeltCountText(burnTime);
        int width = font.method_27525((class_5348)smeltCountText);
        Objects.requireNonNull(font);
        int height = 9;
        font.method_30883(poseStack, smeltCountText, (float)(this.textArea.left + (this.textArea.width - width) / 2), (float)(this.textArea.top + (this.textArea.height - height) / 2 + 1), -8355712);
    }

    private static class_2561 createSmeltCountText(int burnTime) {
        if (burnTime == 200) {
            return class_2561.method_43471((String)"gui.jei.category.fuel.smeltCount.single");
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String smeltCount = numberInstance.format((float)burnTime / 200.0f);
        return class_2561.method_43469((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
    }
}

