/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.betterend.registry.EndBlocks;

public class JEIAlloyingCategory
implements IRecipeCategory<AlloyingRecipe> {
    public static final RecipeType TYPE = RecipeType.create((String)"betterend", (String)"alloying", AlloyingRecipe.class);
    public static final String TEXTURE_GUI_PATH = "textures/gui/";
    public static final String TEXTURE_GUI_VANILLA = "textures/gui/gui_vanilla.png";
    public static final class_2960 RECIPE_GUI_VANILLA = new class_2960("jei", "textures/gui/gui_vanilla.png");
    public static final int width = 116;
    public static final int height = 54;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableStatic addonSlot;
    protected final IDrawableAnimated animatedFlame;
    private final IDrawable background;
    private final IDrawable icon;
    private final class_2561 title;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public JEIAlloyingCategory(final IGuiHelper guiHelper) {
        this.staticFlame = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.background = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.title = class_2561.method_43471((String)EndBlocks.END_STONE_SMELTER.method_9539());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EndBlocks.END_STONE_SMELTER));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
        this.addonSlot = guiHelper.getSlotDrawable();
    }

    protected IDrawableAnimated getArrow(AlloyingRecipe recipe) {
        int cookTime = recipe.getSmeltTime();
        if (cookTime <= 0) {
            cookTime = 0;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public RecipeType<AlloyingRecipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((class_1856)recipe.method_8117().get(0));
        if (recipe.method_8117().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 1).addIngredients((class_1856)recipe.method_8117().get(1));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(recipe.method_8110());
    }

    public boolean isHandled(AlloyingRecipe recipe) {
        return !recipe.method_8118();
    }

    public void draw(AlloyingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(poseStack, 1, 20);
        if (recipe.method_8117().size() > 1) {
            this.addonSlot.draw(poseStack, 20, 0);
        }
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 24, 18);
        this.drawExperience(recipe, poseStack, 0);
        this.drawCookTime(recipe, poseStack, 45);
    }

    protected void drawExperience(AlloyingRecipe recipe, class_4587 poseStack, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            fontRenderer.method_30883(poseStack, (class_2561)experienceString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawCookTime(AlloyingRecipe recipe, class_4587 poseStack, int y) {
        int cookTime = recipe.getSmeltTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)timeString);
            fontRenderer.method_30883(poseStack, (class_2561)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }
}

