/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.minecraft;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.minecraft.fabric.BlockRegistryImpl;

public class BlockRegistry {
    public static void init() {
        ChestTypeRegistry.INSTANCE.getChests().forEach(BlockRegistry::registerBoth);
    }

    private static void registerBoth(String id, ChestType type) {
        BlockRegistry.registerChest(id, type);
        BlockRegistry.registerChestEntity(id, type);
    }

    private static void registerChest(String id, ChestType type) {
        Supplier<GenericChestBlock> register = BlockRegistry.registerBlock(id, () -> new GenericChestBlock(type, type.properties().getProperties()));
        type.registries().setBlockSupplier(register);
    }

    private static void registerChestEntity(String id, ChestType type) {
        Supplier<class_2591<GenericChestBlockEntity>> entityType = BlockRegistry.registerBlockEntity(id, () -> BlockRegistry.createBlockEntityType((pos, state) -> new GenericChestBlockEntity(pos, state, type), (class_2248)type.registries().getBlock().get()));
        type.registries().setBlockEntityType(entityType);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends class_2248> Supplier<T> registerBlock(String id, Supplier<T> item) {
        void var1_1;
        return BlockRegistryImpl.registerBlock(id, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends class_2586, T extends class_2591<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> item) {
        void var1_1;
        return BlockRegistryImpl.registerBlockEntity(id, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends class_2586> class_2591<E> createBlockEntityType(BlockEntityFactory<E> factory, class_2248 ... blocks) {
        void var1_1;
        return BlockRegistryImpl.createBlockEntityType(factory, (class_2248[])var1_1);
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends class_2586> {
        @NotNull
        public T create(class_2338 var1, class_2680 var2);
    }
}

