/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.chesttypes;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_3518;
import org.apache.commons.io.FileUtils;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestUpgradeTypeRegistry;
import tech.thatgravyboat.ironchests.common.utils.ModPaths;
import tech.thatgravyboat.ironchests.common.utils.ModUtils;

public class ChestTypeLoader {
    private static final Gson GSON = new Gson();

    public static void setupChest() {
        File file = new File(ModPaths.LOCK_FILE.toString(), "defaults.lock");
        if (!file.exists()) {
            ChestTypeLoader.writeEmptyFile(file);
            ChestTypeLoader.setupDefaultFiles("/data/ironchests/chests", ModPaths.CHESTS);
            ChestTypeLoader.setupDefaultFiles("/data/ironchests/upgrade_types", ModPaths.UPGRADE_TYPES);
        }
        com.teamresourceful.resourcefullib.common.utils.FileUtils.streamFilesAndParse((Path)ModPaths.CHESTS, ChestTypeLoader::parseChest);
        com.teamresourceful.resourcefullib.common.utils.FileUtils.streamFilesAndParse((Path)ModPaths.UPGRADE_TYPES, ChestTypeLoader::parseChestUpgrade);
    }

    private static void parseChest(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
        ChestType.codec(name).parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().ifPresent(ChestTypeRegistry.INSTANCE::register);
    }

    private static void parseChestUpgrade(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
        ChestUpgradeType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().ifPresent(ChestUpgradeTypeRegistry.INSTANCE::register);
    }

    private static void setupDefaultFiles(String dataPath, Path targetPath) {
        List<Path> roots = ModUtils.getModFilePath("ironchests");
        if (roots.isEmpty()) {
            throw new RuntimeException("Failed to load defaults.");
        }
        for (Path modRoot : ModUtils.getModFilePath("ironchests")) {
            com.teamresourceful.resourcefullib.common.utils.FileUtils.copyDefaultFiles((String)dataPath, (Path)targetPath, (Path)modRoot);
        }
    }

    private static void writeEmptyFile(File file) {
        try {
            FileUtils.write((File)file, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

