/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.blocks;

import java.util.Locale;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestMenu;
import tech.thatgravyboat.ironchests.common.blocks.ISyncableData;
import tech.thatgravyboat.ironchests.common.blocks.LockState;

public class GenericChestBlockEntity
extends class_2624
implements ISyncableData,
class_1278 {
    private final int[] slots;
    private class_2371<class_1799> items;
    private final ChestType type;
    private final class_3917<GenericChestMenu> menuType;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
            GenericChestBlockEntity.this.sync(level, blockPos);
            level.method_43128(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, class_3417.field_14982, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
        }

        protected void method_31683(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
            level.method_43128(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, class_3417.field_14823, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
        }

        protected void method_31682(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState, int i, int j) {
            level.method_8427(blockPos, blockState.method_26204(), 1, j);
        }

        protected boolean method_31679(@NotNull class_1657 player) {
            class_1707 menu;
            class_1703 class_17032 = player.field_7512;
            return class_17032 instanceof class_1707 && (menu = (class_1707)class_17032).method_7629() == GenericChestBlockEntity.this;
        }
    };
    private UUID keyId;
    private boolean isOpened;
    private float openness;
    private float lastOpenness;
    private boolean dropLock;

    public GenericChestBlockEntity(class_2338 blockPos, class_2680 blockState, ChestType type) {
        this(type.registries().getMenu().get(), type.registries().getBlockEntity().get(), blockPos, blockState, type);
    }

    public GenericChestBlockEntity(class_3917<GenericChestMenu> menuType, class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, ChestType type) {
        super(blockEntityType, blockPos, blockState);
        this.items = class_2371.method_10213((int)type.size(), (Object)class_1799.field_8037);
        this.type = type;
        this.menuType = menuType;
        this.slots = IntStream.range(0, type.size()).toArray();
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)("container.chest." + this.type.name().toLowerCase(Locale.ENGLISH)));
    }

    @NotNull
    protected class_1703 method_5465(int i, @NotNull class_1661 inventory) {
        return new GenericChestMenu(this.menuType, i, inventory, (class_1263)this, this.type);
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public int method_5439() {
        return this.type.size();
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    @NotNull
    public class_1799 method_5438(int i) {
        return (class_1799)this.items.get(i);
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @NotNull
    public class_1799 method_5434(int i, int j) {
        class_1799 itemStack = class_1262.method_5430(this.items, (int)i, (int)j);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    @NotNull
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, (int)i);
    }

    public void method_5447(int i, @NotNull class_1799 itemStack) {
        this.items.set(i, (Object)itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public void setItems(class_2371<class_1799> items) {
        if (items.size() == this.method_5439()) {
            this.items = items;
        } else {
            this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
            for (int i = 0; i < items.size(); ++i) {
                this.items.set(i, (Object)((class_1799)items.get(i)));
            }
        }
        this.method_5431();
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean method_5437(int i, @NotNull class_1799 itemStack) {
        return this.type.predicate().method_8970(itemStack);
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (compoundTag.method_10545("key")) {
            this.keyId = compoundTag.method_25926("key");
        }
        class_1262.method_5429((class_2487)compoundTag, this.items);
    }

    public void method_11007(@NotNull class_2487 compoundTag) {
        super.method_11007(compoundTag);
        class_1262.method_5426((class_2487)compoundTag, this.items);
        if (this.keyId != null) {
            compoundTag.method_25927("key", this.keyId);
        }
    }

    public int viewers() {
        return this.openersCounter.method_31678();
    }

    public void method_5435(@NotNull class_1657 player) {
        if (this.field_11863 != null) {
            this.openersCounter.method_31684(player, this.field_11863, this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(@NotNull class_1657 player) {
        if (this.field_11863 != null) {
            this.openersCounter.method_31685(player, this.field_11863, this.method_11016(), this.method_11010());
        }
    }

    public boolean method_11004(int id, int amount) {
        if (id == 1) {
            this.isOpened = amount > 0;
            return true;
        }
        return super.method_11004(id, amount);
    }

    public float getOpenness(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.lastOpenness, (float)this.openness);
    }

    public static void lidAnimateTick(class_1937 level, class_2338 blockPos, class_2680 blockState, GenericChestBlockEntity chestBlockEntity) {
        chestBlockEntity.lastOpenness = chestBlockEntity.openness;
        if (chestBlockEntity.isOpened && chestBlockEntity.openness < 90.0f) {
            chestBlockEntity.openness = Math.min(chestBlockEntity.openness + 12.0f, 90.0f);
        } else if (!chestBlockEntity.isOpened && chestBlockEntity.openness > 0.0f) {
            chestBlockEntity.openness = Math.max(chestBlockEntity.openness - 12.0f, 0.0f);
        }
    }

    public void method_5431() {
        if (this.type.renderItems() && this.field_11863 != null) {
            this.sync(this.field_11863, this.field_11867);
        }
        super.method_5431();
    }

    @Override
    public void loadSyncTag(class_2487 tag) {
        this.method_11014(tag);
    }

    @Override
    public class_2487 getSyncTag() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public void setLockId(UUID uuid) {
        this.keyId = uuid;
    }

    public boolean isRightKey(UUID key) {
        return key.equals(this.keyId);
    }

    public UUID getKeyId() {
        return this.keyId;
    }

    public boolean canDropLock() {
        return this.dropLock;
    }

    public void setCanDropLock(boolean dropLock) {
        this.dropLock = dropLock;
    }

    public ChestType getChestType() {
        return this.type;
    }

    public int @NotNull [] method_5494(@NotNull class_2350 direction) {
        return this.slots;
    }

    public boolean method_5492(int i, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return this.keyId == null || ((LockState)((Object)this.method_11010().method_11654(GenericChestBlock.LOCK))).canOpen();
    }

    public boolean method_5493(int i, @NotNull class_1799 itemStack, @NotNull class_2350 direction) {
        return this.keyId == null || ((LockState)((Object)this.method_11010().method_11654(GenericChestBlock.LOCK))).canOpen();
    }
}

