/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.chesttype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;

public record ChestUpgradeType(ChestType from, ChestType to) {
    public static Codec<ChestUpgradeType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("from").forGetter(upgrade -> Optional.of(upgrade.from.getId())), (App)Codec.STRING.fieldOf("to").forGetter(upgrade -> upgrade.to.getId())).apply((Applicative)instance, ChestUpgradeType::new));

    public ChestUpgradeType(Optional<String> from, String to) {
        this(from.map(ChestUpgradeType::get).orElse(null), ChestUpgradeType.get(to));
    }

    public ChestUpgradeType {
        if (from != null && to != null && from.name().equals(to.name())) {
            throw new IllegalArgumentException("You can not have a chest upgrade with the same chest type for both to and from.");
        }
    }

    private static ChestType get(String id) {
        if (!ChestTypeRegistry.INSTANCE.getChests().containsKey(id)) {
            throw new RuntimeException("Chest type of '" + id + "' was not found.");
        }
        return ChestTypeRegistry.INSTANCE.getChests().get(id);
    }
}

