/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.chesttype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.Locale;
import net.minecraft.class_2073;
import tech.thatgravyboat.ironchests.api.chesttype.ChestRegistries;
import tech.thatgravyboat.ironchests.api.property.Properties;
import tech.thatgravyboat.ironchests.api.property.base.IBlockProperty;

public record ChestType(String name, int length, int rows, int size, int inventoryOffset, int menuOffset, int width, int height, IBlockProperty properties, ChestRegistries registries, boolean transparent, String texture, class_2073 predicate, boolean renderItems, boolean fireResistant) {
    public ChestType(String name, int length, int rows, int inventoryOffset, int menuOffset, int width, int height, IBlockProperty properties, boolean transparent, String texture, class_2073 slotPredicate, boolean renderItems, boolean fireResistant) {
        this(name, length, rows, length * rows, inventoryOffset, menuOffset, width, height, properties, new ChestRegistries(), transparent, texture, slotPredicate, renderItems, fireResistant);
    }

    public ChestType {
        if (size < 18 && renderItems) {
            throw new IllegalArgumentException("Chest Type requires the chest size to be at least 18 total for render items be shown as it looks the best with 18 items.");
        }
    }

    public static Codec<ChestType> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(() -> name)).forGetter(ChestType::name), (App)Codec.INT.fieldOf("length").forGetter(ChestType::length), (App)Codec.INT.fieldOf("rows").forGetter(ChestType::rows), (App)Codec.INT.fieldOf("inventoryOffset").forGetter(ChestType::inventoryOffset), (App)Codec.INT.fieldOf("menuOffset").forGetter(ChestType::menuOffset), (App)Codec.INT.fieldOf("width").forGetter(ChestType::width), (App)Codec.INT.fieldOf("height").forGetter(ChestType::height), (App)Properties.CODEC.fieldOf("properties").forGetter(ChestType::properties), (App)Codec.BOOL.fieldOf("transparent").orElse((Object)false).forGetter(ChestType::transparent), (App)Codec.STRING.fieldOf("texture").orElse((Object)name).forGetter(ChestType::texture), (App)CodecExtras.passthrough(class_2073::method_8971, class_2073::method_8969).fieldOf("predicate").orElse((Object)class_2073.field_9640).forGetter(ChestType::predicate), (App)Codec.BOOL.fieldOf("renderItems").orElse((Object)false).forGetter(ChestType::renderItems), (App)Codec.BOOL.fieldOf("fireResistant").orElse((Object)false).forGetter(ChestType::fireResistant)).apply((Applicative)instance, ChestType::new));
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT) + "_chest";
    }
}

