/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.net.SyncStructuresRequestMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class StructureTask
extends BooleanTask {
    private static final class_2960 DEFAULT_STRUCTURE = new class_2960("minecraft:mineshaft");
    private static final List<String> KNOWN_STRUCTURES = new ArrayList<String>();
    private Either<class_5321<class_3195>, class_6862<class_3195>> structure = Either.left((Object)class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)DEFAULT_STRUCTURE));

    public StructureTask(Quest quest) {
        super(quest);
    }

    public static void syncKnownStructureList(List<String> data) {
        KNOWN_STRUCTURES.clear();
        KNOWN_STRUCTURES.addAll(data);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STRUCTURE;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("structure", this.getStructure());
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.setStructure(nbt.method_10558("structure"));
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10814(this.getStructure());
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.setStructure(buffer.method_10800(1024));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        if (KNOWN_STRUCTURES.isEmpty()) {
            config.addString("structure", this.getStructure(), this::setStructure, "minecraft:mineshaft");
        } else {
            config.addEnum("structure", (Object)this.getStructure(), this::setStructure, NameMap.of((Object)DEFAULT_STRUCTURE.toString(), KNOWN_STRUCTURES).create());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return class_2561.method_43471((String)"ftbquests.task.ftbquests.structure").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.getStructure()).method_27692(class_124.field_1077));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        if (player.method_7325()) {
            return false;
        }
        class_3218 level = (class_3218)player.field_6002;
        return (Boolean)this.structure.map(key -> level.method_27056().method_41034(player.method_24515(), key).method_16657(), tag -> level.method_27056().method_41413(player.method_24515(), tag).method_16657());
    }

    private void setStructure(String resLoc) {
        this.structure = resLoc.startsWith("#") ? Either.right((Object)class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)this.safeResourceLocation(resLoc.substring(1), DEFAULT_STRUCTURE))) : Either.left((Object)class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)this.safeResourceLocation(resLoc, DEFAULT_STRUCTURE)));
    }

    private String getStructure() {
        return (String)this.structure.map(key -> key.method_29177().toString(), tag -> "#" + tag.comp_327());
    }

    public static void maybeRequestStructureSync() {
        if (KNOWN_STRUCTURES.isEmpty()) {
            new SyncStructuresRequestMessage().sendToServer();
        }
    }
}

