/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.SelectImagePreScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.gui.quests.AddTaskButton;
import dev.ftb.mods.ftbquests.gui.quests.ChapterImageButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestLinkButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CopyChapterImageMessage;
import dev.ftb.mods.ftbquests.net.CopyQuestMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.CreateTaskAtMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class QuestPanel
extends Panel {
    private static final ImageIcon DEFAULT_DEPENDENCY_LINE_TEXTURE = (ImageIcon)Icon.getIcon((String)"ftbquests:textures/gui/dependency.png");
    public final QuestScreen questScreen;
    public double questX = 0.0;
    public double questY = 0.0;
    public double centerQuestX = 0.0;
    public double centerQuestY = 0.0;
    public QuestButton mouseOverQuest = null;
    public double questMinX;
    public double questMinY;
    public double questMaxX;
    public double questMaxY;

    public QuestPanel(Panel panel) {
        super(panel);
        this.questScreen = (QuestScreen)panel.getGui();
    }

    public void updateMinMax() {
        this.questMinX = Double.POSITIVE_INFINITY;
        this.questMinY = Double.POSITIVE_INFINITY;
        this.questMaxX = Double.NEGATIVE_INFINITY;
        this.questMaxY = Double.NEGATIVE_INFINITY;
        for (Widget w : this.widgets) {
            if (!(w instanceof QuestPositionableButton)) continue;
            QuestPositionableButton qb = (QuestPositionableButton)w;
            double qx = qb.getPosition().x();
            double qy = qb.getPosition().y();
            double qw = qb.getPosition().w();
            double qh = qb.getPosition().h();
            this.questMinX = Math.min(this.questMinX, qx - qw / 2.0);
            this.questMinY = Math.min(this.questMinY, qy - qh / 2.0);
            this.questMaxX = Math.max(this.questMaxX, qx + qw / 2.0);
            this.questMaxY = Math.max(this.questMaxY, qy + qh / 2.0);
        }
        if (this.questMinX == Double.POSITIVE_INFINITY) {
            this.questMaxY = 0.0;
            this.questMaxX = 0.0;
            this.questMinY = 0.0;
            this.questMinX = 0.0;
        }
        this.questMinX -= 40.0;
        this.questMinY -= 30.0;
        this.questMaxX += 40.0;
        this.questMaxY += 30.0;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.questMaxX - this.questMinX;
        double dy = this.questMaxY - this.questMinY;
        this.setScrollX((x - this.questMinX) / dx * this.questScreen.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - this.questMinY) / dy * this.questScreen.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((this.questScreen.scrollWidth - (double)this.width) / 2.0);
        this.setScrollY((this.questScreen.scrollHeight - (double)this.height) / 2.0);
    }

    public void addWidgets() {
        if (this.questScreen.selectedChapter == null) {
            return;
        }
        this.questScreen.selectedChapter.images.stream().filter(image -> this.questScreen.file.canEdit() || !image.dev && (image.dependency == null || this.questScreen.file.self.isCompleted(image.dependency))).sorted(Comparator.comparingInt(ChapterImage::getOrder)).forEach(image -> this.add((Widget)new ChapterImageButton(this, (ChapterImage)image)));
        this.questScreen.selectedChapter.quests.forEach(quest -> this.add((Widget)new QuestButton(this, (Quest)quest)));
        this.questScreen.selectedChapter.questLinks.forEach(link -> link.getQuest().ifPresent(quest -> this.add((Widget)new QuestLinkButton(this, (QuestLink)link, (Quest)quest))));
        this.alignWidgets();
    }

    public void alignWidgets() {
        if (this.questScreen.selectedChapter == null) {
            return;
        }
        this.questScreen.scrollWidth = 0.0;
        this.questScreen.scrollHeight = 0.0;
        this.updateMinMax();
        double bs = this.questScreen.getQuestButtonSize();
        double bp = this.questScreen.getQuestButtonSpacing();
        this.questScreen.scrollWidth = (this.questMaxX - this.questMinX) * (bs + bp);
        this.questScreen.scrollHeight = (this.questMaxY - this.questMinY) * (bs + bp);
        for (Widget w : this.widgets) {
            if (!(w instanceof QuestPositionableButton)) continue;
            QuestPositionableButton pos = (QuestPositionableButton)w;
            double qx = pos.getPosition().x();
            double qy = pos.getPosition().y();
            double qw = pos.getPosition().w();
            double qh = pos.getPosition().h();
            double x = (qx - this.questMinX - qw / 2.0) * (bs + bp) + bp / 2.0 + bp * (qw - 1.0) / 2.0;
            double y = (qy - this.questMinY - qh / 2.0) * (bs + bp) + bp / 2.0 + bp * (qh - 1.0) / 2.0;
            w.setPosAndSize((int)x, (int)y, (int)(bs * qw), (int)(bs * qh));
        }
        this.setPosAndSize(20, 1, this.questScreen.width - 40, this.questScreen.height - 2);
    }

    public void drawOffsetBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        int a;
        int b;
        int g;
        int r;
        Collection<Quest> sel;
        if (this.questScreen.selectedChapter == null || this.questScreen.file.self == null) {
            return;
        }
        GuiHelper.setupDrawing();
        this.widgets.stream().filter(o -> o instanceof ChapterImageButton).sorted(Comparator.comparingInt(o -> ((ChapterImageButton)o).chapterImage.getOrder())).forEach(o -> o.draw(matrixStack, theme, o.getX(), o.getY(), o.width, o.height));
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        Icon icon = (Icon)ThemeProperties.DEPENDENCY_LINE_TEXTURE.get(this.questScreen.selectedChapter);
        if (icon instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)icon;
            img.bindTexture();
        } else {
            DEFAULT_DEPENDENCY_LINE_TEXTURE.bindTexture();
        }
        Quest selectedQuest = this.questScreen.getViewedQuest();
        if (selectedQuest == null && (sel = this.questScreen.getSelectedQuests()).size() == 1) {
            selectedQuest = this.questScreen.getSelectedQuests().stream().findFirst().orElse(null);
        }
        double mt = -((double)System.currentTimeMillis() * 0.001);
        float lineWidth = (float)((double)this.questScreen.getZoom() * (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(this.questScreen.selectedChapter) / 4.0 * 3.0);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float mu = (float)(mt * (Double)ThemeProperties.DEPENDENCY_LINE_UNSELECTED_SPEED.get(this.questScreen.selectedChapter) % 1.0);
        for (Widget widget : this.widgets) {
            if (!widget.shouldDraw() || !(widget instanceof QuestButton)) continue;
            QuestButton qb2 = (QuestButton)widget;
            if (qb2.quest.getHideDependencyLines()) continue;
            boolean unavailable = !this.questScreen.file.self.canStartTasks(qb2.quest);
            boolean complete = !unavailable && this.questScreen.file.self.isCompleted(qb2.quest);
            for (QuestButton button : qb2.getDependencies()) {
                if (!button.shouldDraw() || button.quest == selectedQuest || qb2.quest == selectedQuest || button.quest.hideDependentLines) continue;
                if (complete) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                } else {
                    c = Color4I.hsb((float)((float)button.quest.id / 1000.0f), (float)0.2f, (float)(unavailable ? 0.3f : 0.8f));
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = 180;
                }
                this.renderConnection(widget, button, matrixStack, buffer, lineWidth, r, g, b, a, a, mu, tesselator);
            }
        }
        float ms = (float)(mt * (Double)ThemeProperties.DEPENDENCY_LINE_SELECTED_SPEED.get(this.questScreen.selectedChapter) % 1.0);
        ArrayList<QuestButton> toOutline = new ArrayList<QuestButton>();
        for (Widget widget : this.widgets) {
            if (!widget.shouldDraw() || !(widget instanceof QuestButton)) continue;
            QuestButton qb3 = (QuestButton)widget;
            if (qb3.quest.getHideDependencyLines()) continue;
            for (QuestButton button : qb3.getDependencies()) {
                int a2;
                if (button.quest == selectedQuest || button.isMouseOver()) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRED_FOR_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    if (qb3.shouldDraw()) {
                        a = a2 = c.alphai();
                    } else {
                        a = c.alphai() / 4 * 3;
                        a2 = 30;
                        toOutline.add(qb3);
                    }
                } else {
                    if (qb3.quest != selectedQuest && !qb3.isMouseOver()) continue;
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRES_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a2 = a = c.alphai();
                }
                this.renderConnection(widget, button, matrixStack, buffer, lineWidth, r, g, b, a2, a, ms, tesselator);
            }
        }
        toOutline.forEach(qb -> {
            QuestShape.get((String)qb.quest.getShape()).shape.withColor(Color4I.BLACK.withAlpha(30)).draw(matrixStack, qb.getX(), qb.getY(), qb.width, qb.height);
            QuestShape.get((String)qb.quest.getShape()).outline.withColor(Color4I.BLACK.withAlpha(90)).draw(matrixStack, qb.getX(), qb.getY(), qb.width, qb.height);
        });
    }

    private void renderConnection(Widget widget, QuestButton button, class_4587 matrixStack, class_287 buffer, float s, int r, int g, int b, int a, int a1, float mu, class_289 tesselator) {
        int sx = widget.getX() + widget.width / 2;
        int sy = widget.getY() + widget.height / 2;
        int ex = button.getX() + button.width / 2;
        int ey = button.getY() + button.height / 2;
        float len = (float)MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
        matrixStack.method_22903();
        matrixStack.method_22904((double)sx, (double)sy, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23626((float)Math.atan2(ey - sy, ex - sx)));
        class_1159 m = matrixStack.method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(m, 0.0f, -s, 0.0f).method_1336(r, g, b, a).method_22913(len / s / 2.0f + mu, 0.0f).method_1344();
        buffer.method_22918(m, 0.0f, s, 0.0f).method_1336(r, g, b, a).method_22913(len / s / 2.0f + mu, 1.0f).method_1344();
        buffer.method_22918(m, len, s, 0.0f).method_1336(r * 3 / 4, g * 3 / 4, b * 3 / 4, a1).method_22913(mu, 1.0f).method_1344();
        buffer.method_22918(m, len, -s, 0.0f).method_1336(r * 3 / 4, g * 3 / 4, b * 3 / 4, a1).method_22913(mu, 0.0f).method_1344();
        tesselator.method_1350();
        matrixStack.method_22909();
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        super.draw(matrixStack, theme, x, y, w, h);
        if (this.questScreen.selectedChapter != null && this.isMouseOver()) {
            Movable movable;
            double dx = this.questMaxX - this.questMinX;
            double dy = this.questMaxY - this.questMinY;
            double px = (double)this.getX() - this.getScrollX();
            double py = (double)this.getY() - this.getScrollY();
            double qx = ((double)this.questScreen.getMouseX() - px) / this.questScreen.scrollWidth * dx + this.questMinX;
            double qy = ((double)this.questScreen.getMouseY() - py) / this.questScreen.scrollHeight * dy + this.questMinY;
            this.centerQuestX = ((double)this.questScreen.width / 2.0 - px) / this.questScreen.scrollWidth * dx + this.questMinX;
            this.centerQuestY = ((double)this.questScreen.height / 2.0 - py) / this.questScreen.scrollHeight * dy + this.questMinY;
            if (QuestPanel.isShiftKeyDown()) {
                this.questX = qx;
                this.questY = qy;
            } else if (this.questScreen.selectedObjects.size() == 1 && (movable = this.questScreen.selectedObjects.get(0)) instanceof Quest) {
                Quest q = (Quest)movable;
                s = 1.0 / this.questScreen.file.gridScale / q.size;
                this.questX = (double)class_3532.method_15357((double)(qx * s + 0.5)) / s;
                this.questY = (double)class_3532.method_15357((double)(qy * s + 0.5)) / s;
            } else {
                s = 1.0 / this.questScreen.file.gridScale;
                this.questX = (double)class_3532.method_15357((double)(qx * s + 0.5)) / s;
                this.questY = (double)class_3532.method_15357((double)(qy * s + 0.5)) / s;
            }
            if (this.questScreen.file.canEdit()) {
                matrixStack.method_22903();
                matrixStack.method_22904(0.0, 0.0, 600.0);
                theme.drawString(matrixStack, (Object)("X:" + (this.questX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questX)), x + 3, y + h - 18, 2);
                theme.drawString(matrixStack, (Object)("Y:" + (this.questY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questY)), x + 3, y + h - 10, 2);
                if (this.questScreen.movingObjects) {
                    theme.drawString(matrixStack, (Object)"Moving", x + 3, y + h - 34, 2);
                }
                if (!this.questScreen.selectedObjects.isEmpty()) {
                    theme.drawString(matrixStack, (Object)("Selected: " + this.questScreen.selectedObjects.size()), x + 3, y + h - 26, 2);
                }
                theme.drawString(matrixStack, (Object)("CX:" + (this.centerQuestX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestX)), x + w - 42, y + h - 18, 2);
                theme.drawString(matrixStack, (Object)("CY:" + (this.centerQuestY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestY)), x + w - 42, y + h - 10, 2);
                matrixStack.method_22909();
                double bs = this.questScreen.getQuestButtonSize();
                if (this.questScreen.movingObjects && !this.questScreen.selectedObjects.isEmpty()) {
                    double ominX = Double.POSITIVE_INFINITY;
                    double ominY = Double.POSITIVE_INFINITY;
                    double omaxX = Double.NEGATIVE_INFINITY;
                    double omaxY = Double.NEGATIVE_INFINITY;
                    for (Movable q : this.questScreen.selectedObjects) {
                        ominX = Math.min(ominX, q.getX());
                        ominY = Math.min(ominY, q.getY());
                        omaxX = Math.max(omaxX, q.getX());
                        omaxY = Math.max(omaxY, q.getY());
                    }
                    for (Movable m : this.questScreen.selectedObjects) {
                        double ox = m.getX() - ominX;
                        double oy = m.getY() - ominY;
                        double sx = (this.questX + ox - this.questMinX) / dx * this.questScreen.scrollWidth + px;
                        double sy = (this.questY + oy - this.questMinY) / dy * this.questScreen.scrollHeight + py;
                        matrixStack.method_22903();
                        matrixStack.method_22904(sx - bs * m.getWidth() / 2.0, sy - bs * m.getHeight() / 2.0, 0.0);
                        matrixStack.method_22905((float)(bs * m.getWidth()), (float)(bs * m.getHeight()), 1.0f);
                        GuiHelper.setupDrawing();
                        RenderSystem.enableDepthTest();
                        m.drawMoved(matrixStack);
                        matrixStack.method_22909();
                    }
                    if (QuestScreen.grid && !this.questScreen.viewQuestPanel.viewingQuest()) {
                        double boxX = ominX / dx * this.questScreen.scrollWidth + px;
                        double boxY = ominY / dy * this.questScreen.scrollHeight + py;
                        double boxW = omaxX / dx * this.questScreen.scrollWidth + px - boxX;
                        double boxH = omaxY / dy * this.questScreen.scrollHeight + py - boxY;
                        matrixStack.method_22903();
                        matrixStack.method_22904(0.0, 0.0, 1000.0);
                        GuiHelper.drawHollowRect((class_4587)matrixStack, (int)((int)boxX), (int)((int)boxY), (int)((int)boxW), (int)((int)boxH), (Color4I)Color4I.WHITE.withAlpha(30), (boolean)false);
                        matrixStack.method_22909();
                    }
                } else if (!this.questScreen.viewQuestPanel.viewingQuest() || !this.questScreen.viewQuestPanel.isMouseOver()) {
                    double sx = (this.questX - this.questMinX) / dx * this.questScreen.scrollWidth + px;
                    double sy = (this.questY - this.questMinY) / dy * this.questScreen.scrollHeight + py;
                    matrixStack.method_22903();
                    matrixStack.method_22904(sx - bs / 2.0, sy - bs / 2.0, 0.0);
                    matrixStack.method_22905((float)bs, (float)bs, 1.0f);
                    GuiHelper.setupDrawing();
                    RenderSystem.enableDepthTest();
                    QuestShape.get((String)this.questScreen.selectedChapter.getDefaultQuestShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(matrixStack, 0, 0, 1, 1);
                    matrixStack.method_22909();
                    if (QuestScreen.grid && !this.questScreen.viewQuestPanel.viewingQuest()) {
                        matrixStack.method_22903();
                        matrixStack.method_22904(0.0, 0.0, 1000.0);
                        Color4I.WHITE.draw(matrixStack, (int)sx, (int)sy, 1, 1);
                        Color4I.WHITE.withAlpha(30).draw(matrixStack, this.getX(), (int)sy, this.width, 1);
                        Color4I.WHITE.withAlpha(30).draw(matrixStack, (int)sx, this.getY(), 1, this.height);
                        matrixStack.method_22909();
                    }
                }
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.questScreen.selectedChapter == null || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        if (this.questScreen.movingObjects && this.questScreen.file.canEdit()) {
            if (this.questScreen.selectedChapter != null && !button.isRight() && !this.questScreen.selectedObjects.isEmpty()) {
                this.playClickSound();
                double minX = Double.POSITIVE_INFINITY;
                double minY = Double.POSITIVE_INFINITY;
                for (Movable q : this.questScreen.selectedObjects) {
                    minX = Math.min(minX, q.getX());
                    minY = Math.min(minY, q.getY());
                }
                for (Movable q : this.questScreen.selectedObjects) {
                    q.move(this.questScreen.selectedChapter, this.questX + (q.getX() - minX), this.questY + (q.getY() - minY));
                }
            }
            this.questScreen.movingObjects = false;
            this.questScreen.selectedObjects.clear();
            return true;
        }
        if (super.mousePressed(button)) {
            return true;
        }
        if (!this.questScreen.viewQuestPanel.hidePanel && this.questScreen.isViewingQuest()) {
            this.questScreen.closeQuest();
            return true;
        }
        if ((button.isLeft() || button.isMiddle() && this.questScreen.file.canEdit()) && this.isMouseOver() && (this.questScreen.viewQuestPanel.hidePanel || !this.questScreen.isViewingQuest())) {
            this.questScreen.prevMouseX = this.getMouseX();
            this.questScreen.prevMouseY = this.getMouseY();
            this.questScreen.grabbed = button;
            return true;
        }
        if (button.isRight() && this.questScreen.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            double qx = this.questX;
            double qy = this.questY;
            for (TaskType type : TaskTypes.TYPES.values()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), new Quest(this.questScreen.selectedChapter), task -> new CreateTaskAtMessage(this.questScreen.selectedChapter, qx, qy, (Task)task).sendToServer());
                }));
            }
            contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.chapter.image"), Icons.ART, () -> this.showImageCreationScreen(qx, qy)));
            String clip = QuestPanel.getClipboardString();
            MutableBoolean addedSeparator = new MutableBoolean(false);
            if (!clip.isEmpty()) {
                try {
                    long questId = Long.valueOf(clip, 16);
                    QuestObject qo = FTBQuests.PROXY.getQuestFile(true).get(questId);
                    if (qo instanceof Quest) {
                        Quest quest = (Quest)qo;
                        contextMenu.add(ContextMenuItem.SEPARATOR);
                        addedSeparator.setTrue();
                        contextMenu.add(new PasteQuestMenuItem(quest, (class_2561)class_2561.method_43471((String)"ftbquests.gui.paste"), Icons.ADD, () -> new CopyQuestMessage(quest, this.questScreen.selectedChapter, qx, qy, true).sendToServer()));
                        if (quest.hasDependencies()) {
                            contextMenu.add(new PasteQuestMenuItem(quest, (class_2561)class_2561.method_43471((String)"ftbquests.gui.paste_no_deps"), Icons.ADD_GRAY.withTint(Color4I.rgb((int)32768)), () -> new CopyQuestMessage(quest, this.questScreen.selectedChapter, qx, qy, false).sendToServer()));
                        }
                        contextMenu.add(new PasteQuestMenuItem(quest, (class_2561)class_2561.method_43471((String)"ftbquests.gui.paste_link"), Icons.ADD_GRAY.withTint(Color4I.rgb((int)0x8080C0)), () -> {
                            QuestLink link = new QuestLink(this.questScreen.selectedChapter, quest.id);
                            link.setPosition(qx, qy);
                            new CreateObjectMessage(link, new class_2487()).sendToServer();
                        }));
                    } else if (qo instanceof Task) {
                        Task task = (Task)qo;
                        contextMenu.add(ContextMenuItem.SEPARATOR);
                        addedSeparator.setTrue();
                        contextMenu.add(new AddTaskButton.PasteTaskMenuItem(task, () -> this.copyAndCreateTask(task, qx, qy)));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ChapterImageButton.getClipboard().ifPresent(clipImg -> {
                if (!addedSeparator.getValue().booleanValue()) {
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                }
                contextMenu.add(new TooltipContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.paste_image"), Icons.ADD, () -> new CopyChapterImageMessage((ChapterImage)clipImg, this.questScreen.selectedChapter, qx, qy).sendToServer(), new class_2561[]{class_2561.method_43470((String)clipImg.getImage().toString()).method_27692(class_124.field_1080)}));
            });
            this.questScreen.openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    private void showImageCreationScreen(double qx, double qy) {
        ImageConfig imageConfig = new ImageConfig();
        new SelectImagePreScreen(imageConfig, accepted -> {
            if (accepted) {
                this.playClickSound();
                ChapterImage image = new ChapterImage(this.questScreen.selectedChapter).setImage(Icon.getIcon((String)((String)imageConfig.value)));
                image.x = qx;
                image.y = qy;
                image.fixupAspectRatio(true);
                this.questScreen.selectedChapter.images.add(image);
                new EditObjectMessage(this.questScreen.selectedChapter).sendToServer();
            }
            this.questScreen.openGui();
        }).openGui();
    }

    private void copyAndCreateTask(Task task, double qx, double qy) {
        Task task2 = TaskType.createTask(new Quest(this.questScreen.selectedChapter), task.getType().id.toString());
        if (task2 != null) {
            class_2487 tag = new class_2487();
            task.writeData(tag);
            task2.readData(tag);
            new CreateTaskAtMessage(this.questScreen.selectedChapter, qx, qy, task).sendToServer();
        }
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (this.questScreen.grabbed != null && this.questScreen.grabbed.isMiddle() && this.questScreen.file.canEdit()) {
            this.questScreen.selectAllQuestsInBox(this.getMouseX(), this.getMouseY(), this.getScrollX(), this.getScrollY());
        }
        this.questScreen.grabbed = null;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.mouseOverQuest = null;
        super.updateMouseOver(mouseX, mouseY);
        for (Widget widget : this.widgets) {
            if (!widget.isMouseOver() || !(widget instanceof QuestButton)) continue;
            this.mouseOverQuest = (QuestButton)widget;
            break;
        }
    }

    public boolean keyPressed(Key key) {
        if (this.questScreen.selectedChapter != null && !this.questScreen.isViewingQuest() && (key.is(45) || key.is(61))) {
            this.questScreen.addZoom(key.is(45) ? -1.0 : 1.0);
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean scrollPanel(double scroll) {
        if (this.questScreen.selectedChapter != null && !this.questScreen.isViewingQuest() && this.isMouseOver()) {
            this.questScreen.addZoom(scroll);
            return true;
        }
        return false;
    }

    private static class PasteQuestMenuItem
    extends TooltipContextMenuItem {
        public PasteQuestMenuItem(Quest quest, class_2561 title, Icon icon, @Nullable Runnable callback) {
            super(title, icon, callback, new class_2561[]{class_2561.method_43470((String)"\"").method_10852(quest.getTitle()).method_27693("\""), class_2561.method_43470((String)QuestObjectBase.getCodeString(quest.id)).method_27692(class_124.field_1063)});
        }
    }
}

