/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.ChangeChapterGroupScreen;
import dev.ftb.mods.ftbquests.gui.quests.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterGroupMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterMessage;
import dev.ftb.mods.ftbquests.net.ToggleChapterPinnedMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class ChapterPanel
extends Panel {
    public static final Icon ARROW_COLLAPSED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_collapsed.png");
    public static final Icon ARROW_EXPANDED = Icon.getIcon((String)"ftbquests:textures/gui/arrow_expanded.png");
    public final QuestScreen questScreen;
    public boolean expanded = this.isPinned();

    public ChapterPanel(Panel panel) {
        super(panel);
        this.questScreen = (QuestScreen)panel.getGui();
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.viewQuestPanel.viewingQuest()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void addWidgets() {
        this.add((Widget)new ModpackButton(this, this.questScreen.file));
        boolean canEdit = this.questScreen.file.canEdit();
        for (Chapter chapter : this.questScreen.file.defaultChapterGroup.getVisibleChapters(this.questScreen.file.self)) {
            this.add((Widget)new ChapterButton(this, chapter));
        }
        if (canEdit) {
            // empty if block
        }
        for (ChapterGroup group : this.questScreen.file.chapterGroups) {
            if (group.isDefaultGroup()) continue;
            ChapterGroupButton b = new ChapterGroupButton(this, group);
            if (canEdit || !b.visibleChapters.isEmpty()) {
                this.add((Widget)b);
                if (!group.guiCollapsed) {
                    for (Chapter chapter : b.visibleChapters) {
                        this.add((Widget)new ChapterButton(this, chapter));
                    }
                }
            }
            if (!canEdit) continue;
        }
    }

    public void alignWidgets() {
        int wd = 100;
        for (Widget w : this.widgets) {
            wd = Math.min(Math.max(wd, ((ListButton)w).getActualWidth(this.questScreen)), 800);
        }
        this.setPosAndSize((this.expanded || this.isPinned()) && !this.questScreen.isViewingQuest() ? 0 : -wd, 0, wd, this.questScreen.height);
        for (Widget w : this.widgets) {
            w.setWidth(wd);
        }
        this.align(WidgetLayout.VERTICAL);
        if (this.getContentHeight() <= this.height) {
            this.setScrollY(0.0);
        }
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.expanded && !this.isPinned() && !this.isMouseOver()) {
            this.setExpanded(false);
        }
    }

    public int getX() {
        return (this.expanded || this.isPinned()) && !this.questScreen.isViewingQuest() ? 0 : -this.width;
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(matrixStack, x, y, w, h);
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 600.0);
        RenderSystem.enableDepthTest();
        super.draw(matrixStack, theme, x, y, w, h);
        matrixStack.method_22909();
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
    }

    boolean isPinned() {
        return ClientQuestFile.INSTANCE.self.isChapterPinned();
    }

    public static class ModpackButton
    extends ListButton {
        public ModpackButton(ChapterPanel panel, ClientQuestFile f) {
            super(panel, f.getTitle(), f.getIcon());
            this.setSize(100, 18);
        }

        public void onClicked(MouseButton button) {
            if (this.getMouseX() > this.getX() + this.width - 18) {
                this.playClickSound();
                new ToggleChapterPinnedMessage().sendToServer();
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                this.playClickSound();
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.chapter"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted && !((String)c.value).isEmpty()) {
                            Chapter chapter = new Chapter(this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.defaultChapterGroup);
                            chapter.title = (String)c.value;
                            class_2487 extra = new class_2487();
                            extra.method_10544("group", 0L);
                            new CreateObjectMessage(chapter, extra).sendToServer();
                        }
                        this.run();
                    });
                }));
                contextMenu.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.chapter_group"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                    this.playClickSound();
                    StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                        this.chapterPanel.questScreen.openGui();
                        if (accepted) {
                            ChapterGroup group = new ChapterGroup(ClientQuestFile.INSTANCE);
                            group.title = (String)c.value;
                            new CreateObjectMessage(group, null).sendToServer();
                        }
                    });
                }));
                this.chapterPanel.questScreen.openContextMenu(contextMenu);
            }
        }

        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
            }
            class_124 f = this.isMouseOver() ? class_124.field_1068 : class_124.field_1080;
            this.icon.draw(matrixStack, x + 2, y + 3, 12, 12);
            theme.drawString(matrixStack, (Object)class_2561.method_43470((String)"").method_10852(this.title).method_27692(f), x + 16, y + 5);
            ((Color4I)ThemeProperties.WIDGET_BORDER.get(ClientQuestFile.INSTANCE)).draw(matrixStack, x, y + h - 1, w, 1);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            ((Icon)(this.chapterPanel.isPinned() ? ThemeProperties.PIN_ICON_ON : ThemeProperties.PIN_ICON_OFF).get()).draw(matrixStack, x + w - 16, y + 3, 12, 12);
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(matrixStack, x + w - 31, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((class_5348)this.title) + 36 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapterPanel.questScreen.file);
            if (this.getMouseX() > this.getX() + this.width - 18) {
                list.string(this.chapterPanel.isPinned() ? "Stays open" : "Doesn't stay open");
            } else if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 34) {
                list.translate("gui.add", new Object[0]);
            }
        }
    }

    public static class ChapterButton
    extends ListButton {
        public final Chapter chapter;
        public List<class_2561> description;

        public ChapterButton(ChapterPanel panel, Chapter c) {
            super(panel, c.getTitle(), c.getIcon());
            this.chapter = c;
            this.description = new ArrayList<class_2561>();
            for (String v : this.chapter.subtitle) {
                this.description.add((class_2561)class_2561.method_43473().method_10852(TextUtils.parseRawText(v)).method_27692(class_124.field_1080));
            }
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() || !this.chapter.quests.isEmpty()) {
                this.playClickSound();
                if (this.chapterPanel.questScreen.selectedChapter != this.chapter) {
                    this.chapterPanel.questScreen.open(this.chapter, false);
                }
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight()) {
                ContextMenuBuilder.create(this.chapter, this.chapterPanel.questScreen).insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, true).sendToServer()).setEnabled(() -> this.chapter.getIndex() > 0).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterMessage(this.chapter.id, false).sendToServer()).setEnabled(() -> this.chapter.getIndex() < this.chapter.group.chapters.size() - 1).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbquests.gui.change_group"), Icons.COLOR_RGB, () -> new ChangeChapterGroupScreen(this.chapter).openGui()))).openContextMenu(this.chapterPanel.questScreen);
            }
        }

        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y, w - 2, h);
            }
            Color4I c = this.chapter.getProgressColor(this.chapterPanel.questScreen.file.self, !this.isMouseOver());
            int o = this.chapter.group.isDefaultGroup() ? 0 : 7;
            this.icon.draw(matrixStack, x + 2 + o, y + 1, 12, 12);
            class_5250 text = class_2561.method_43470((String)"").method_10852(this.title).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)c.rgb())));
            if (this.chapterPanel.questScreen.selectedChapter != null && this.chapter.id == this.chapterPanel.questScreen.selectedChapter.id) {
                text.method_10852((class_2561)class_2561.method_43470((String)" \u25c0").method_27692(class_124.field_1080));
            }
            theme.drawString(matrixStack, (Object)text, x + 16 + o, y + 3);
            GuiHelper.setupDrawing();
            if (this.chapter.quests.isEmpty()) {
                ((Icon)ThemeProperties.CLOSE_ICON.get()).draw(matrixStack, x + w - 12, y + 3, 8, 8);
            } else if (this.chapterPanel.questScreen.file.self.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), this.chapter)) {
                ((Icon)ThemeProperties.ALERT_ICON.get()).draw(matrixStack, x + w - 12, y + 3, 8, 8);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.chapter);
            for (class_2561 s : this.description) {
                list.add(s);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            int o;
            int n = o = this.chapter.group.isDefaultGroup() ? 0 : 7;
            if (this.chapter.quests.isEmpty() || this.chapterPanel.questScreen.file.self.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), this.chapter)) {
                o += 16;
            }
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20 + o;
        }
    }

    public static class ChapterGroupButton
    extends ListButton {
        public final ChapterGroup group;
        public final List<Chapter> visibleChapters;

        public ChapterGroupButton(ChapterPanel panel, ChapterGroup g) {
            super(panel, g.getTitle(), g.getIcon());
            this.setSize(100, 18);
            this.group = g;
            this.visibleChapters = g.getVisibleChapters(panel.questScreen.file.self);
        }

        public void onClicked(MouseButton button) {
            if (this.chapterPanel.questScreen.file.canEdit() && this.getMouseX() > this.getX() + this.width - 15) {
                this.playClickSound();
                StringConfig c = new StringConfig(Pattern.compile("^.+$"));
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)"", (Object)"", accepted -> {
                    this.chapterPanel.questScreen.openGui();
                    if (accepted && !((String)c.value).isEmpty()) {
                        Chapter chapter = new Chapter(this.chapterPanel.questScreen.file, this.chapterPanel.questScreen.file.defaultChapterGroup);
                        chapter.title = (String)c.value;
                        class_2487 extra = new class_2487();
                        extra.method_10544("group", this.group.id);
                        new CreateObjectMessage(chapter, extra).sendToServer();
                    }
                    this.run();
                });
                return;
            }
            if (this.chapterPanel.questScreen.file.canEdit() && button.isRight() && !this.group.isDefaultGroup()) {
                ContextMenuBuilder.create(this.group, this.chapterPanel.questScreen).insertAtTop(List.of(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, true).sendToServer()).setEnabled(() -> this.group.getIndex() > 1).setCloseMenu(false), new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.move"), (Icon)ThemeProperties.MOVE_DOWN_ICON.get(), () -> new MoveChapterGroupMessage(this.group.id, false).sendToServer()).setEnabled(() -> this.group.getIndex() < this.group.file.chapterGroups.size() - 1).setCloseMenu(false))).openContextMenu(this.chapterPanel.questScreen);
                return;
            }
            this.group.guiCollapsed = !this.group.guiCollapsed;
            this.parent.refreshWidgets();
        }

        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(40).draw(matrixStack, x + 1, y, w - 2, h);
            }
            class_124 f = this.isMouseOver() ? class_124.field_1068 : class_124.field_1080;
            (this.group.guiCollapsed ? ARROW_COLLAPSED : ARROW_EXPANDED).withColor(Color4I.getChatFormattingColor((class_124)f)).draw(matrixStack, x + 3, y + 5, 8, 8);
            theme.drawString(matrixStack, (Object)class_2561.method_43470((String)"").method_10852(this.title).method_27692(f), x + 15, y + 5);
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            if (canEdit) {
                ((Icon)ThemeProperties.ADD_ICON.get()).draw(matrixStack, x + w - 14, y + 3, 12, 12);
            }
        }

        @Override
        public int getActualWidth(QuestScreen screen) {
            boolean canEdit = this.chapterPanel.questScreen.file.canEdit();
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20 + (canEdit ? 16 : 0);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.chapterPanel.questScreen.addInfoTooltip(list, this.group);
        }
    }

    public static abstract class ListButton
    extends Button {
        public final ChapterPanel chapterPanel;

        public ListButton(ChapterPanel panel, class_2561 t, Icon i) {
            super((Panel)panel, t, i);
            this.setSize(100, 14);
            this.chapterPanel = panel;
        }

        public int getActualWidth(QuestScreen screen) {
            return screen.getTheme().getStringWidth((class_5348)this.title) + 20;
        }

        public void addMouseOverText(TooltipList list) {
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.icon.getIngredient();
        }
    }
}

