/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.FTBQuestsNetCommon;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.IRewardListenerScreen;
import dev.ftb.mods.ftbquests.gui.QuestObjectUpdateListener;
import dev.ftb.mods.ftbquests.gui.RewardKey;
import dev.ftb.mods.ftbquests.gui.RewardToast;
import dev.ftb.mods.ftbquests.gui.ToastQuestObject;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.TeamDataUpdate;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsNetClient
extends FTBQuestsNetCommon {
    @Override
    public void syncTeamData(boolean self, TeamData data) {
        data.file = ClientQuestFile.INSTANCE;
        data.file.addData(data, true);
        if (self) {
            ClientQuestFile.INSTANCE.self = data;
        }
    }

    @Override
    public void claimReward(UUID teamId, UUID player, long rewardId) {
        QuestScreen treeGui;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward == null) {
            return;
        }
        TeamData data = ClientQuestFile.INSTANCE.getData(teamId);
        data.claimReward(player, reward, System.currentTimeMillis());
        if (data == ClientQuestFile.INSTANCE.self && (treeGui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            treeGui.viewQuestPanel.refreshWidgets();
            treeGui.otherButtonsTopPanel.refreshWidgets();
        }
    }

    @Override
    public void createObject(long id, long parent, QuestObjectType type, class_2487 nbt, @Nullable class_2487 extra) {
        QuestObjectUpdateListener listener;
        QuestObjectBase object = ClientQuestFile.INSTANCE.create(type, parent, extra == null ? new class_2487() : extra);
        object.readData(nbt);
        object.id = id;
        object.onCreated();
        ClientQuestFile.INSTANCE.refreshIDMap();
        object.editedFromGUI();
        FTBQuestsJEIHelper.refresh(object);
        if (object instanceof Chapter) {
            ClientQuestFile.INSTANCE.questScreen.selectChapter((Chapter)object);
        }
        if ((listener = (QuestObjectUpdateListener)ClientUtils.getCurrentGuiAs(QuestObjectUpdateListener.class)) != null) {
            listener.onQuestObjectUpdate(object);
        }
    }

    @Override
    public void createOtherTeamData(TeamDataUpdate dataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            TeamData data = new TeamData(dataUpdate.uuid);
            data.file = ClientQuestFile.INSTANCE;
            data.name = dataUpdate.name;
            data.file.addData(data, true);
        }
    }

    @Override
    public void teamDataChanged(TeamDataUpdate oldDataUpdate, TeamDataUpdate newDataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            TeamData data = new TeamData(newDataUpdate.uuid);
            data.file = ClientQuestFile.INSTANCE;
            data.name = newDataUpdate.name;
            data.file.addData(data, false);
        }
    }

    @Override
    public void deleteObject(long id) {
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            ClientQuestFile.INSTANCE.refreshIDMap();
            object.editedFromGUI();
            FTBQuestsJEIHelper.refresh(object);
        }
    }

    @Override
    public void displayCompletionToast(long id) {
        QuestObject object = ClientQuestFile.INSTANCE.get(id);
        if (object != null) {
            class_310.method_1551().method_1566().method_1999((class_368)new ToastQuestObject(object));
        }
        ClientQuestFile.INSTANCE.questScreen.questPanel.refreshWidgets();
        ClientQuestFile.INSTANCE.questScreen.chapterPanel.refreshWidgets();
        ClientQuestFile.INSTANCE.questScreen.viewQuestPanel.refreshWidgets();
    }

    @Override
    public void displayItemRewardToast(class_1799 stack, int count) {
        class_1799 stack1 = stack.method_7972();
        stack1.method_7939(1);
        Icon icon = ItemIcon.getItemIcon((class_1799)stack1);
        if (!IRewardListenerScreen.add(new RewardKey(stack.method_7964().getString(), icon).setStack(stack1), count)) {
            class_5250 s = stack.method_7964().method_27661();
            if (count > 1) {
                s = class_2561.method_43470((String)(count + "x ")).method_10852((class_2561)s);
            }
            s.method_27692(stack.method_7932().field_8908);
            class_310.method_1551().method_1566().method_1999((class_368)new RewardToast((class_2561)s, icon));
        }
    }

    @Override
    public void displayRewardToast(long id, class_2561 text, Icon icon) {
        Icon i;
        Icon icon2 = i = icon.isEmpty() ? ClientQuestFile.INSTANCE.getBase(id).getIcon() : icon;
        if (!IRewardListenerScreen.add(new RewardKey(text.getString(), i), 1)) {
            class_310.method_1551().method_1566().method_1999((class_368)new RewardToast(text, i));
        }
    }

    @Override
    public void editObject(long id, class_2487 nbt) {
        ClientQuestFile.INSTANCE.clearCachedData();
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.readData(nbt);
            object.editedFromGUI();
            FTBQuestsJEIHelper.refresh(object);
        }
    }

    @Override
    public void moveChapter(long id, boolean up) {
        int index;
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null && ((index = chapter.group.chapters.indexOf(chapter)) != -1 && up ? index > 0 : index < chapter.group.chapters.size() - 1)) {
            chapter.group.chapters.remove(index);
            chapter.group.chapters.add(up ? index - 1 : index + 1, chapter);
            ClientQuestFile.INSTANCE.clearCachedData();
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.chapterPanel.refreshWidgets();
            }
        }
    }

    @Override
    public void moveQuest(long id, long chapter, double x, double y) {
        QuestObject questObject = ClientQuestFile.INSTANCE.get(id);
        if (questObject instanceof Movable) {
            Movable movable = (Movable)((Object)questObject);
            movable.onMoved(x, y, chapter);
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                double sx = gui.questPanel.centerQuestX;
                double sy = gui.questPanel.centerQuestY;
                gui.questPanel.refreshWidgets();
                gui.questPanel.scrollTo(sx, sy);
            }
        }
    }

    @Override
    public void syncEditingMode(UUID teamId, boolean editingMode) {
        if (ClientQuestFile.INSTANCE.getData(teamId).setCanEdit(editingMode)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    @Override
    public void togglePinned(long id, boolean pinned) {
        TeamData data = FTBQuests.PROXY.getClientPlayerData();
        data.setQuestPinned(id, pinned);
        ClientQuestFile.INSTANCE.questScreen.otherButtonsBottomPanel.refreshWidgets();
        if (ClientQuestFile.INSTANCE.questScreen.viewQuestPanel != null) {
            ClientQuestFile.INSTANCE.questScreen.viewQuestPanel.refreshWidgets();
        }
    }

    @Override
    public void updateTeamData(UUID teamId, String name) {
        TeamData data = ClientQuestFile.INSTANCE.getData(teamId);
        data.name = name;
    }

    @Override
    public void updateTaskProgress(UUID teamId, long task, long progress) {
        Task t = ClientQuestFile.INSTANCE.getTask(task);
        if (t != null) {
            TeamData data = ClientQuestFile.INSTANCE.getData(teamId);
            ClientQuestFile.INSTANCE.clearCachedProgress();
            data.setProgress(t, progress);
        }
    }

    @Override
    public void changeChapterGroup(long id, long group) {
        ChapterGroup g;
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null && chapter.group != (g = ClientQuestFile.INSTANCE.getChapterGroup(group))) {
            chapter.group.chapters.remove(chapter);
            chapter.group = g;
            g.chapters.add(chapter);
            chapter.file.clearCachedData();
            chapter.editedFromGUI();
        }
    }

    @Override
    public void moveChapterGroup(long id, boolean up) {
        int index;
        ChapterGroup group = ClientQuestFile.INSTANCE.getChapterGroup(id);
        if (!group.isDefaultGroup() && ((index = group.file.chapterGroups.indexOf(group)) != -1 && up ? index > 1 : index < group.file.chapterGroups.size() - 1)) {
            group.file.chapterGroups.remove(index);
            group.file.chapterGroups.add(up ? index - 1 : index + 1, group);
            ClientQuestFile.INSTANCE.clearCachedData();
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.chapterPanel.refreshWidgets();
            }
        }
    }

    @Override
    public void objectStarted(UUID teamId, long id, @Nullable Date time) {
        TeamData teamData = ClientQuestFile.INSTANCE.getData(teamId);
        teamData.setStarted(id, time);
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.chapterPanel.refreshWidgets();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
    }

    @Override
    public void objectCompleted(UUID teamId, long id, @Nullable Date time) {
        TeamData teamData = ClientQuestFile.INSTANCE.getData(teamId);
        teamData.setCompleted(id, time);
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.chapterPanel.refreshWidgets();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
        FTBQuestsJEIHelper.refresh(ClientQuestFile.INSTANCE.get(id));
    }

    @Override
    public void syncLock(UUID id, boolean lock) {
        if (ClientQuestFile.INSTANCE.getData(id).setLocked(lock)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    @Override
    public void resetReward(UUID teamId, UUID player, long rewardId) {
        QuestScreen gui;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward == null) {
            return;
        }
        TeamData teamData = ClientQuestFile.INSTANCE.getData(teamId);
        if (teamData.resetReward(player, reward) && (gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            gui.chapterPanel.refreshWidgets();
            if (gui.viewQuestPanel != null) {
                gui.viewQuestPanel.refreshWidgets();
            }
        }
    }

    @Override
    public void toggleChapterPinned(boolean pinned) {
        ClientQuestFile.INSTANCE.self.setChapterPinned(pinned);
        ClientQuestFile.INSTANCE.questScreen.chapterPanel.refreshWidgets();
    }

    @Override
    public void syncRewardBlocking(UUID uuid, boolean rewardsBlocked) {
        if (ClientQuestFile.INSTANCE.getData(uuid).setRewardsBlocked(rewardsBlocked)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }
}

