/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.util.TextUtils;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_746;

public class ClientQuestFile
extends QuestFile {
    private static final List<String> MISSING_DATA_ERR = List.of("Unable to open Quest GUI: no quest book data received from server!", "- Check that FTB Quests and FTB Teams are installed on the server", "  and that no server-side errors were logged when you connected.");
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    private QuestScreen.PersistedData persistedData;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(class_156.field_25140);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        boolean guiOpen = false;
        if (this.questScreen != null) {
            this.persistedData = this.questScreen.getPersistedScreenData();
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                guiOpen = true;
            }
        }
        if (guiOpen) {
            class_310.method_1551().method_1507(null);
        }
        this.questScreen = new QuestScreen(this, this.persistedData);
        if (guiOpen) {
            this.questScreen.openGui();
        }
    }

    public static void openGui() {
        if (INSTANCE != null) {
            INSTANCE.openQuestGui();
        } else {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                MISSING_DATA_ERR.forEach(s -> player.method_7353((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1061), false));
            }
        }
    }

    private void openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)class_2561.method_43471((String)"item.ftbquests.book.disabled"), Icons.BARRIER, (class_2561)class_2561.method_43473()));
            } else if (this.self.isLocked()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)(this.lockMessage.isEmpty() ? class_2561.method_43470((String)"Quests locked!") : TextUtils.parseRawText(this.lockMessage)), Icons.BARRIER, (class_2561)class_2561.method_43473()));
            } else {
                if (this.self.getCanEdit()) {
                    StructureTask.maybeRequestStructureSync();
                }
                this.questScreen = new QuestScreen(this, this.persistedData);
                this.questScreen.openGui();
                this.questScreen.refreshWidgets();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(class_1297 player) {
        return player == class_310.method_1551().field_1724 ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.method_5667()), (String)"Non-null team required!").teamId);
    }

    public void setPersistedScreenInfo(QuestScreen.PersistedData persistedData) {
        this.persistedData = persistedData;
    }
}

