/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<class_3965>
implements BlockAccessor {
    private final class_2680 blockState;
    private final class_2586 blockEntity;
    private class_1799 fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    @Override
    public class_2248 getBlock() {
        return this.getBlockState().method_26204();
    }

    @Override
    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Override
    public class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public class_2338 getPosition() {
        return ((class_3965)this.getHitResult()).method_17777();
    }

    @Override
    public class_2350 getSide() {
        return ((class_3965)this.getHitResult()).method_17780();
    }

    @Override
    public class_1799 getPickedResult() {
        return ClientPlatformProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (class_3965)this.getHitResult());
    }

    @Override
    public IElement _getIcon() {
        if (this.blockState.method_26215()) {
            return null;
        }
        IElement icon = null;
        if (this.isFakeBlock()) {
            icon = ItemStackElement.of(this.getFakeBlock());
        } else {
            class_1799 pick = this.getPickedResult();
            if (!pick.method_7960()) {
                icon = ItemStackElement.of(pick);
            }
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock().method_8389() != class_1802.field_8162) {
            icon = ItemStackElement.of(new class_1799((class_1935)this.getBlock()));
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock() instanceof class_2404) {
            icon = ClientPlatformProxy.elementFromLiquid((class_2404)this.getBlock());
        }
        for (IBlockComponentProvider provider : WailaClientRegistration.INSTANCE.getBlockIconProviders(this.getBlock(), PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(this, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _gatherComponents(Function<IJadeProvider, ITooltip> tooltipProvider) {
        List<IBlockComponentProvider> providers = WailaClientRegistration.INSTANCE.getBlockProviders(this.getBlock(), PluginConfig.INSTANCE::get);
        for (IBlockComponentProvider provider : providers) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, this, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }

    @Override
    public boolean shouldDisplay() {
        return Jade.CONFIG.get().getGeneral().getDisplayBlocks();
    }

    @Override
    public void _requestData() {
        ClientPlatformProxy.requestBlockData(this.blockEntity, this.showDetails());
    }

    @Override
    public boolean shouldRequestData() {
        if (this.blockEntity == null) {
            return false;
        }
        return !WailaCommonRegistration.INSTANCE.getBlockNBTProviders(this.blockEntity).isEmpty();
    }

    @Override
    public boolean _verifyData(class_2487 serverData) {
        int x = serverData.method_10550("x");
        int y = serverData.method_10550("y");
        int z = serverData.method_10550("z");
        class_2338 hitPos = this.getPosition();
        return x == hitPos.method_10263() && y == hitPos.method_10264() && z == hitPos.method_10260();
    }

    @Override
    public Object _getTrackObject() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.method_7960();
    }

    @Override
    public class_1799 getFakeBlock() {
        return this.fakeBlock;
    }

    public void setFakeBlock(class_1799 fakeBlock) {
        this.fakeBlock = fakeBlock;
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private class_1937 level;
        private class_1657 player;
        private class_2487 serverData;
        private boolean connected;
        private boolean showDetails = ClientPlatformProxy.isShowDetailsPressed();
        private class_3965 hit;
        private class_2680 blockState = class_2246.field_10124.method_9564();
        private class_2586 blockEntity;
        private class_1799 fakeBlock = class_1799.field_8037;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(class_3965 hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(class_2680 blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(class_2586 blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(class_1799 stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (class_3965)accessor.getHitResult();
            this.blockEntity = accessor.getBlockEntity();
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor build() {
            return new BlockAccessorImpl(this);
        }
    }
}

