/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.FluidTextHelper;

@ApiStatus.Experimental
public class FluidView {
    public static final class_2561 EMPTY_FLUID = class_2561.method_43471((String)"jade.fluid.empty");
    public IElement overlay;
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public class_2561 fluidName;
    @Nullable
    public class_2561 overrideText;

    public FluidView(IElement overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView read(class_2487 tag) {
        long capacity = tag.method_10537("Capacity");
        if (capacity <= 0L) {
            return null;
        }
        FluidVariant fluid = FluidVariant.fromNbt((class_2487)tag);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluid.getFluid().method_15785()));
        fluidView.fluidName = FluidVariantAttributes.getName((FluidVariant)fluid);
        long amount = tag.method_10537("Amount");
        if (amount <= 0L) {
            fluidView.overrideText = EMPTY_FLUID;
        }
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets(amount, true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets(capacity, true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        return fluidView;
    }

    public static class_2487 fromFluidVariant(FluidVariant fluidVariant, long amount, long capacity) {
        class_2487 tag = fluidVariant.toNbt();
        tag.method_10544("Amount", amount);
        tag.method_10544("Capacity", capacity);
        return tag;
    }

    public static List<ViewGroup<class_2487>> fromStorage(Storage<FluidVariant> storage) {
        ArrayList list = Lists.newArrayList();
        long emptyCapacity = 0L;
        for (StorageView view : storage) {
            long capacity = view.getCapacity();
            if (capacity <= 0L) continue;
            if (view.isResourceBlank() || view.getAmount() <= 0L) {
                emptyCapacity = LongMath.saturatedAdd((long)emptyCapacity, (long)capacity);
                continue;
            }
            list.add(FluidView.fromFluidVariant((FluidVariant)view.getResource(), view.getAmount(), capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0L) {
            list.add(FluidView.fromFluidVariant(FluidVariant.blank(), 0L, emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }
}

