/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.jmoverlay.ftbchunks;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.XZ;
import frankv.jmi.JMI;
import frankv.jmi.jmoverlay.JMOverlayManager;
import frankv.jmi.jmoverlay.ToggleableOverlay;
import frankv.jmi.jmoverlay.ftbchunks.ClaimedChunkPolygon;
import frankv.jmi.jmoverlay.ftbchunks.ClaimingModeHandler;
import frankv.jmi.util.OverlayHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.FullscreenMapEvent;
import journeymap.client.api.model.IFullscreen;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.MapPolygonWithHoles;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public enum ClaimingMode implements ToggleableOverlay
{
    INSTANCE;

    private IClientAPI jmAPI;
    private class_310 mc = class_310.method_1551();
    private final ClaimingModeHandler handler = new ClaimingModeHandler();
    private boolean activated = false;
    private PolygonOverlay claimAreaPolygon = null;
    private Set<class_1923> area = new HashSet<class_1923>();
    private String buttonLabel = "FTBChunks Claiming Mode";
    private final int order = 0;

    private ClaimingMode() {
        JMOverlayManager.INSTANCE.registerOverlay(this);
    }

    @Override
    public void init(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
    }

    private void removeOverlays() {
        if (this.claimAreaPolygon == null) {
            return;
        }
        this.jmAPI.remove((Displayable)this.claimAreaPolygon);
        ClaimedChunkPolygon.INSTANCE.showForceLoadedByArea(false);
        this.claimAreaPolygon = null;
        this.area.clear();
    }

    PolygonOverlay dragPolygon(XZ xz) {
        class_746 player = class_310.method_1551().field_1724;
        String displayId = "drag_polygon_" + xz.x + "_" + xz.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setFillColor(0xFFFFFF).setFillOpacity(0.3f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)xz.x, (int)10, (int)xz.z);
        return new PolygonOverlay("jmi", displayId, player.field_17892.method_27983(), shapeProps, polygon);
    }

    PolygonOverlay forceLoadedPolygon(ChunkDimPos pos) {
        class_746 player = class_310.method_1551().field_1724;
        String displayId = "ftb_force_loaded_" + pos.x + "_" + pos.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFF0000).setFillOpacity(0.0f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.x, (int)10, (int)pos.z);
        return new PolygonOverlay("jmi", displayId, player.field_17892.method_27983(), shapeProps, polygon);
    }

    private void createClaimingAreaOverlays() {
        class_746 player = class_310.method_1551().field_1724;
        class_1923 startPoint = new class_1923(player.method_31476().field_9181 - 7, player.method_31476().field_9180 - 7);
        String displayId = "claim_mode";
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(3.0f).setStrokeColor(0xFFFFFF).setStrokeOpacity(1.0f).setFillOpacity(0.0f);
        for (int x = 0; x < 15; ++x) {
            for (int z = 0; z < 15; ++z) {
                this.area.add(new class_1923(startPoint.field_9181 + x, startPoint.field_9180 + z));
            }
        }
        ClaimedChunkPolygon.INSTANCE.showForceLoadedByArea(true);
        List polygons = PolygonHelper.createChunksPolygon(this.area, (int)100);
        PolygonOverlay overlay = new PolygonOverlay("jmi", "claim_mode", player.field_6002.method_27983(), shapeProps, (MapPolygonWithHoles)polygons.get(0));
        OverlayHelper.showOverlay((Displayable)overlay);
        this.claimAreaPolygon = overlay;
    }

    public void onGuiScreen(class_437 screen) {
        if (!this.isEnabled() || !this.activated) {
            return;
        }
        if (!(screen instanceof IFullscreen)) {
            return;
        }
        this.activated = false;
        this.removeOverlays();
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!this.activated) {
            this.createClaimingAreaOverlays();
        } else {
            this.removeOverlays();
        }
        ClaimedChunkPolygon.INSTANCE.onClaiming(this.activated);
        this.activated = !this.activated;
        button.setToggled(Boolean.valueOf(this.activated));
    }

    @Override
    public void onJMEvent(ClientEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        switch (event.type) {
            case MAP_CLICKED: {
                if (!(event instanceof FullscreenMapEvent.ClickEvent.Pre)) break;
                this.getHandler().onPreClick((FullscreenMapEvent.ClickEvent)event);
                break;
            }
            case MAP_DRAGGED: {
                if (!(event instanceof FullscreenMapEvent.MouseDraggedEvent.Pre)) break;
                this.getHandler().onPreDrag((FullscreenMapEvent.MouseDraggedEvent)event);
                break;
            }
            case MAP_MOUSE_MOVED: {
                this.getHandler().onMouseMove((FullscreenMapEvent.MouseMoveEvent)event);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return JMI.ftbchunks;
    }

    @Override
    public String getButtonIconName() {
        return "grid";
    }

    public ClaimingModeHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    public PolygonOverlay getClaimAreaPolygon() {
        return this.claimAreaPolygon;
    }

    public Set<class_1923> getArea() {
        return this.area;
    }

    @Override
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

