/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.components;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4587;
import org.betterx.ui.layout.components.LayoutComponent;
import org.betterx.ui.layout.components.render.NullRenderer;
import org.betterx.ui.layout.components.render.ScrollerRenderer;
import org.betterx.ui.layout.values.Alignment;
import org.betterx.ui.layout.values.Rectangle;
import org.betterx.ui.layout.values.Value;
import org.betterx.ui.vanilla.VanillaScrollerRenderer;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class VerticalScroll<RS extends ScrollerRenderer>
extends LayoutComponent<NullRenderer, VerticalScroll<RS>>
implements class_4069 {
    protected LayoutComponent<?, ?> child;
    protected final RS scrollerRenderer;
    protected int dist;
    protected double scrollerY;
    protected int scrollerHeight;
    protected int travel;
    protected int topOffset;
    protected int scrollerPadding;
    protected boolean keepSpaceForScrollbar = true;
    List<LayoutComponent<?, ?>> children = List.of();
    private boolean mouseDown = false;
    private int mouseDownY = 0;
    private int scrollerDownY = 0;
    class_364 focused;
    boolean dragging;

    public VerticalScroll(Value width, Value height, RS scrollerRenderer) {
        super(width, height, new NullRenderer());
        this.scrollerRenderer = scrollerRenderer;
        this.scrollerPadding = scrollerRenderer.scrollerPadding();
    }

    public static VerticalScroll<VanillaScrollerRenderer> create(LayoutComponent<?, ?> c) {
        return VerticalScroll.create(Value.relative(1.0), Value.relative(1.0), c);
    }

    public static VerticalScroll<VanillaScrollerRenderer> create(Value width, Value height, LayoutComponent<?, ?> c) {
        VerticalScroll<VanillaScrollerRenderer> res = new VerticalScroll<VanillaScrollerRenderer>(width, height, VanillaScrollerRenderer.DEFAULT);
        res.setChild(c);
        return res;
    }

    public VerticalScroll<RS> setChild(LayoutComponent<?, ?> c) {
        this.child = c;
        this.children = List.of(this.child);
        return this;
    }

    public VerticalScroll<RS> setScrollerPadding(int pad) {
        this.scrollerPadding = pad;
        return this;
    }

    public VerticalScroll<RS> setKeepSpaceForScrollbar(boolean value) {
        this.keepSpaceForScrollbar = value;
        return this;
    }

    @Override
    protected int updateContainerWidth(int containerWidth) {
        int myWidth = this.width.calculateOrFill(containerWidth);
        if (this.child != null) {
            this.child.width.calculateOrFill(myWidth - this.scrollerWidth());
            this.child.updateContainerWidth(this.child.width.calculatedSize());
        }
        return myWidth;
    }

    @Override
    protected int updateContainerHeight(int containerHeight) {
        int myHeight = this.height.calculateOrFill(containerHeight);
        if (this.child != null) {
            this.child.height.calculateOrFill(myHeight);
            this.child.updateContainerHeight(this.child.height.calculatedSize());
        }
        return myHeight;
    }

    protected int scrollerWidth() {
        return this.scrollerRenderer.scrollerWidth() + this.scrollerPadding;
    }

    @Override
    public int getContentWidth() {
        return this.scrollerWidth() + (this.child != null ? this.child.getContentWidth() : 0);
    }

    @Override
    public int getContentHeight() {
        return this.child != null ? this.child.getContentHeight() : 0;
    }

    @Override
    void setRelativeBounds(int left, int top) {
        super.setRelativeBounds(left, top);
        if (this.child != null) {
            boolean willNeedScrollBar;
            int width = this.relativeBounds.width;
            boolean bl = willNeedScrollBar = this.keepSpaceForScrollbar || this.child.height.calculatedSize() > this.relativeBounds.height;
            if (willNeedScrollBar) {
                width -= this.scrollerWidth();
            }
            int childLeft = width - this.child.width.calculatedSize();
            if (this.child.hAlign == Alignment.MIN) {
                childLeft = 0;
            } else if (this.child.hAlign == Alignment.CENTER) {
                childLeft /= 2;
            }
            int childTop = this.relativeBounds.height - this.child.height.calculatedSize();
            if (this.child.vAlign == Alignment.MIN) {
                childTop = 0;
            } else if (this.child.vAlign == Alignment.CENTER) {
                childTop /= 2;
            }
            this.child.setRelativeBounds(childLeft, childTop);
        }
        this.updateScrollViewMetrics();
    }

    @Override
    public void updateScreenBounds(int worldX, int worldY) {
        super.updateScreenBounds(worldX, worldY);
        this.child.updateScreenBounds(this.screenBounds.left, this.screenBounds.top);
    }

    @Override
    protected void renderInBounds(class_4587 poseStack, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        super.renderInBounds(poseStack, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        if (this.showScrollBar()) {
            if (this.child != null) {
                poseStack.method_22903();
                poseStack.method_22904(0.0, (double)this.scrollerOffset(), 0.0);
                this.setClippingRect(clipRect);
                this.child.render(poseStack, mouseX, mouseY - this.scrollerOffset(), deltaTicks, renderBounds.movedBy(0, this.scrollerOffset(), this.scrollerWidth(), 0), clipRect);
                this.setClippingRect(null);
                poseStack.method_22909();
            }
            this.scrollerRenderer.renderScrollBar(renderBounds, this.saveScrollerY(), this.scrollerHeight);
        } else if (this.child != null) {
            this.child.render(poseStack, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        }
    }

    protected void updateScrollViewMetrics() {
        int view = this.relativeBounds.height;
        int content = this.child.relativeBounds.height;
        this.dist = content - view;
        this.scrollerHeight = Math.max(this.scrollerRenderer.scrollerHeight(), view * view / content);
        this.travel = view - this.scrollerHeight;
        this.topOffset = 0;
        this.scrollerY = 0.0;
    }

    protected int saveScrollerY() {
        return (int)Math.max(0.0, Math.min((double)this.travel, this.scrollerY));
    }

    protected int scrollerOffset() {
        return -((int)((float)this.saveScrollerY() / (float)this.travel * (float)this.dist));
    }

    public boolean showScrollBar() {
        return this.child.relativeBounds.height > this.relativeBounds.height;
    }

    public void method_16014(double x, double y) {
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            super.method_16014(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset());
        }
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25402(double x, double y, int button) {
        Rectangle scroller = this.scrollerRenderer.getScrollerBounds(this.relativeBounds);
        Rectangle picker = this.scrollerRenderer.getPickerBounds(scroller, this.saveScrollerY(), this.scrollerHeight);
        if (picker.contains((int)x, (int)y)) {
            this.mouseDown = true;
            this.mouseDownY = (int)y;
            this.scrollerDownY = this.saveScrollerY();
            return true;
        }
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.method_25402(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button);
        }
        return false;
    }

    public boolean method_25406(double x, double y, int button) {
        this.mouseDown = false;
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.method_25406(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button);
        }
        return false;
    }

    public boolean method_25403(double x, double y, int button, double x2, double y2) {
        if (this.mouseDown) {
            int delta = (int)y - this.mouseDownY;
            this.scrollerY = this.scrollerDownY + delta;
            return true;
        }
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.method_25403(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button, x2, y2);
        }
        return false;
    }

    public boolean method_25401(double x, double y, double delta) {
        boolean didCapture = false;
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            didCapture = super.method_25401(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), delta);
        }
        if (!didCapture) {
            this.scrollerY = Math.max(0.0, Math.min((double)this.travel, this.scrollerY)) + delta;
            return true;
        }
        System.out.println("Child did capture scroll");
        return false;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 guiEventListener) {
        this.focused = guiEventListener;
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean bl) {
        this.dragging = bl;
    }

    @Override
    public boolean method_25405(double x, double y) {
        if (this.child != null && this.child.method_25405(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset())) {
            return true;
        }
        return this.relativeBounds.contains(x, y);
    }
}

