/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.components;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.betterx.ui.ColorUtil;
import org.betterx.ui.layout.components.AbstractHorizontalStack;
import org.betterx.ui.layout.components.ColorSwatch;
import org.betterx.ui.layout.components.Input;
import org.betterx.ui.layout.values.Value;

@Environment(value=EnvType.CLIENT)
public class ColorPicker
extends AbstractHorizontalStack<ColorPicker> {
    ColorSwatch swatch;
    Input input;

    public ColorPicker(Value width, Value height, class_2561 title, int color) {
        super(width, height);
        this.swatch = this.addColorSwatch(Value.fixed(20), Value.fixed(20), color);
        this.input = this.addInput(Value.fill(), Value.fit(), title, ColorUtil.toRGBHex(color));
        this.input.setResponder(this::inputResponder);
    }

    private void inputResponder(String value) {
        if (ColorUtil.validHexColor(value)) {
            int color = ColorUtil.parseHex(value);
            this.swatch.setColor(color);
            this.swatch.setOffsetInner(false);
            this.swatch.setBorderColor(ColorUtil.BLACK);
        } else {
            this.swatch.setOffsetInner(true);
            this.swatch.setBorderColor(ColorUtil.RED);
        }
    }
}

