/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.components;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.betterx.ui.layout.components.AbstractStack;
import org.betterx.ui.layout.components.Empty;
import org.betterx.ui.layout.components.HorizontalStack;
import org.betterx.ui.layout.components.LayoutComponent;
import org.betterx.ui.layout.components.input.RelativeContainerEventHandler;
import org.betterx.ui.layout.components.render.NullRenderer;
import org.betterx.ui.layout.values.Alignment;
import org.betterx.ui.layout.values.Value;

@Environment(value=EnvType.CLIENT)
public class AbstractVerticalStack<S extends AbstractVerticalStack<S>>
extends AbstractStack<NullRenderer, S>
implements RelativeContainerEventHandler {
    public AbstractVerticalStack(Value width, Value height) {
        super(width, height);
    }

    @Override
    protected int updateContainerWidth(int containerWidth) {
        int myWidth = this.width.calculateOrFill(containerWidth);
        this.components.stream().forEach(c -> c.width.calculateOrFill(myWidth));
        for (LayoutComponent c2 : this.components) {
            c2.updateContainerWidth(c2.width.calculatedSize());
        }
        return myWidth;
    }

    @Override
    public int updateContainerHeight(int containerHeight) {
        int myHeight = this.height.calculateOrFill(containerHeight);
        int fixedHeight = this.components.stream().map(c -> c.height.calculate(myHeight)).reduce(0, Integer::sum);
        int freeHeight = Math.max(0, myHeight - fixedHeight);
        this.fillHeight(myHeight, freeHeight);
        for (LayoutComponent c2 : this.components) {
            c2.updateContainerHeight(c2.height.calculatedSize());
        }
        return myHeight;
    }

    @Override
    void setRelativeBounds(int left, int top) {
        super.setRelativeBounds(left, top);
        int offset = 0;
        for (LayoutComponent c : this.components) {
            int delta = this.relativeBounds.width - c.width.calculatedSize();
            if (c.hAlign == Alignment.MIN) {
                delta = 0;
            } else if (c.hAlign == Alignment.CENTER) {
                delta /= 2;
            }
            c.setRelativeBounds(delta, offset);
            offset += c.relativeBounds.height;
        }
    }

    @Override
    public int getContentWidth() {
        return this.components.stream().map(c -> c.width.calculateFixed()).reduce(0, Integer::max);
    }

    @Override
    public int getContentHeight() {
        int fixedHeight = this.components.stream().map(c -> c.height.calculateFixed()).reduce(0, Integer::sum);
        double percentage = this.components.stream().map(c -> c.height.calculateRelative()).reduce(0.0, Double::sum);
        return (int)((double)fixedHeight / (1.0 - percentage));
    }

    @Override
    protected S addEmpty(Value size) {
        this.components.add(new Empty(Value.fixed(0), size));
        return (S)this;
    }

    protected HorizontalStack addRow(Value width, Value height) {
        HorizontalStack stack = new HorizontalStack(width, height);
        this.add(stack);
        return stack;
    }

    protected HorizontalStack addRow() {
        return this.addRow(Value.fit(), Value.fit());
    }
}

