/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.recipes.AbstractAdvancementRecipe;
import org.betterx.bclib.recipes.BCLRecipeManager;

public class GridRecipe
extends AbstractAdvancementRecipe {
    private static final GridRecipe INSTANCE = new GridRecipe();
    private class_2960 id;
    private class_1935 output;
    private String group;
    private class_3956<class_3955> type;
    private boolean shaped;
    private String[] shape;
    private final Map<Character, class_1856> materialKeys = Maps.newHashMap();
    private int count;
    private boolean exist;

    private GridRecipe() {
    }

    static GridRecipe make(class_2960 id, class_1935 output) {
        GridRecipe.INSTANCE.id = id;
        GridRecipe.INSTANCE.output = output;
        GridRecipe.INSTANCE.group = "";
        GridRecipe.INSTANCE.type = class_3956.field_17545;
        GridRecipe.INSTANCE.shaped = true;
        GridRecipe.INSTANCE.shape = new String[]{"#"};
        GridRecipe.INSTANCE.materialKeys.clear();
        GridRecipe.INSTANCE.count = 1;
        GridRecipe.INSTANCE.exist = output != null && BCLRecipeManager.exists(output);
        INSTANCE.createAdvancement(id, output);
        return INSTANCE;
    }

    public GridRecipe checkConfig(PathConfig config) {
        this.exist &= config.getBoolean("grid", this.id.method_12832(), true);
        return this;
    }

    public GridRecipe setGroup(String group) {
        this.group = group;
        return this;
    }

    public GridRecipe setShape(String ... shape) {
        this.shape = shape;
        return this;
    }

    public GridRecipe setList(String shape) {
        this.shape = new String[]{shape};
        this.shaped = false;
        return this;
    }

    public GridRecipe addMaterial(char key, class_6862<class_1792> value) {
        this.unlockedBy(value);
        return this.addMaterial(key, class_1856.method_8106(value));
    }

    public GridRecipe addMaterial(char key, class_1799 ... values) {
        this.unlockedBy(values);
        return this.addMaterial(key, class_1856.method_26964(Arrays.stream(values)));
    }

    public GridRecipe addMaterial(char key, class_1935 ... values) {
        for (class_1935 item : values) {
            this.exist &= BCLRecipeManager.exists(item);
        }
        this.unlockedBy(values);
        return this.addMaterial(key, class_1856.method_8091((class_1935[])values));
    }

    private GridRecipe addMaterial(char key, class_1856 value) {
        this.materialKeys.put(Character.valueOf(key), value);
        return this;
    }

    public GridRecipe setOutputCount(int count) {
        this.count = count;
        return this;
    }

    private class_2371<class_1856> getMaterials(int width, int height) {
        class_2371 materials = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        int pos = 0;
        boolean hasNonEmpty = false;
        for (String line : this.shape) {
            for (int i = 0; i < width; ++i) {
                char c = line.charAt(i);
                class_1856 material = this.materialKeys.get(Character.valueOf(c));
                if (material != null && !material.method_8103()) {
                    hasNonEmpty = true;
                }
                materials.set(pos++, (Object)(material == null ? class_1856.field_9017 : material));
            }
        }
        if (!hasNonEmpty) {
            return null;
        }
        return materials;
    }

    public void build() {
        if (!this.exist) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id, new Object[0]);
            return;
        }
        int height = this.shape.length;
        int width = this.shape[0].length();
        class_1799 result = new class_1799(this.output, this.count);
        if (result.method_31574(class_1802.field_8162)) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id + ": Result is AIR", new Object[0]);
            return;
        }
        class_2371<class_1856> materials = this.getMaterials(width, height);
        if (materials == null || materials.isEmpty()) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id + ": Empty Material List", new Object[0]);
            return;
        }
        class_1869 recipe = this.shaped ? new class_1869(this.id, this.group, width, height, materials, result) : new class_1867(this.id, this.group, result, materials);
        BCLRecipeManager.addRecipe(this.type, recipe);
        this.registerAdvancement((class_1860<?>)recipe);
    }
}

