/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.recipes.AbstractAdvancementRecipe;
import org.betterx.bclib.recipes.BCLRecipeManager;

public abstract class AbstractSimpleRecipe<T extends AbstractSimpleRecipe, C extends class_1263, R extends class_1860<C>>
extends AbstractAdvancementRecipe {
    public final class_2960 id;
    protected String group;
    protected class_1856 input;
    protected class_1935 output;
    protected final String category;
    protected final class_3956<R> type;
    protected int count;
    protected boolean exist;

    protected AbstractSimpleRecipe(class_2960 id, class_3956<R> type, class_1935 output) {
        this(id, type, type.toString(), output);
    }

    protected AbstractSimpleRecipe(class_2960 id, class_3956<R> type, String category, class_1935 output) {
        this.id = id;
        this.group = "";
        this.exist = true;
        this.count = 1;
        this.output = output;
        this.category = category;
        this.type = type;
    }

    protected T setInput(class_1935 in) {
        this.exist &= BCLRecipeManager.exists(in);
        this.input = class_1856.method_8091((class_1935[])new class_1935[]{in});
        this.unlockedBy(in);
        return (T)this;
    }

    protected T setInput(class_6862<class_1792> in) {
        this.input = class_1856.method_8106(in);
        this.unlockedBy(in);
        return (T)this;
    }

    public T setGroup(String group) {
        this.group = group;
        return (T)this;
    }

    public T setOutputCount(int count) {
        this.count = count;
        return (T)this;
    }

    public T checkConfig(PathConfig config) {
        this.exist &= config.getBoolean(this.category, this.id.method_12832(), true);
        return (T)this;
    }

    protected abstract R buildRecipe();

    protected boolean hasErrors() {
        return false;
    }

    public final void build() {
        if (!this.exist) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id, new Object[0]);
            return;
        }
        if (this.input == null || this.input.method_8103()) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id + ": No Input Material", new Object[0]);
            return;
        }
        if (this.output == null) {
            BCLib.LOGGER.warning("Result recipe can't be 'null', recipe {} will be ignored!", this.id);
            return;
        }
        if (BCLRecipeManager.getRecipe(this.type, this.id) != null) {
            BCLib.LOGGER.warning("Can't add Smithing recipe! Id {} already exists!", this.id);
            return;
        }
        if (this.hasErrors()) {
            return;
        }
        R recipe = this.buildRecipe();
        BCLRecipeManager.addRecipe(this.type, recipe);
        this.registerAdvancement((class_1860<?>)recipe);
    }
}

