/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1752;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.BonemealAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1752.class})
public class BoneMealItemMixin {
    @Unique
    private static final class_2338.class_2339 BCLIB_BLOCK_POS = new class_2338.class_2339();

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void bclib_onUse(class_1838 context, CallbackInfoReturnable<class_1269> info) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        if (!world.method_8608() && BonemealAPI.isTerrain(world.method_8320(blockPos).method_26204())) {
            boolean consume = false;
            if (BonemealAPI.isSpreadableTerrain(world.method_8320(blockPos).method_26204())) {
                class_2680 terrain = this.bclib_getSpreadable(world, blockPos);
                if (terrain != null) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, blockPos, terrain);
                    consume = true;
                }
            } else {
                class_2680 stateAbove = world.method_8320(blockPos.method_10084());
                if (!stateAbove.method_26227().method_15769()) {
                    if (stateAbove.method_27852(class_2246.field_10382)) {
                        consume = this.bclib_growWaterGrass(world, blockPos);
                    }
                } else if (stateAbove.method_26215()) {
                    consume = this.bclib_growLandGrass(world, blockPos);
                }
            }
            if (consume) {
                if (!context.method_8036().method_7337()) {
                    context.method_8041().method_7934(1);
                }
                world.method_20290(2005, blockPos, 0);
                info.setReturnValue((Object)class_1269.field_5812);
                info.cancel();
            }
        }
    }

    @Inject(method={"growCrop"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bcl_growCrop(class_1799 itemStack, class_1937 level, class_2338 blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (org.betterx.bclib.api.v3.bonemeal.BonemealAPI.INSTANCE.runSpreaders(itemStack, level, blockPos)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean bclib_growLandGrass(class_1937 level, class_2338 pos) {
        int y1 = pos.method_10264() + 3;
        int y2 = pos.method_10264() - 3;
        boolean result = false;
        block0: for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            int x = (int)((double)pos.method_10263() + level.field_9229.method_43059() * 2.0);
            int z = (int)((double)pos.method_10260() + level.field_9229.method_43059() * 2.0);
            BCLIB_BLOCK_POS.method_33097(x);
            BCLIB_BLOCK_POS.method_33099(z);
            for (int y = y1; y >= y2; --y) {
                BCLIB_BLOCK_POS.method_33098(y);
                class_2338 down = BCLIB_BLOCK_POS.method_10074();
                if (!level.method_22347((class_2338)BCLIB_BLOCK_POS) || level.method_22347(down)) continue;
                BiConsumer<class_1937, class_2338> grass = this.bclib_getLandGrassState(level, down);
                if (grass == null) continue block0;
                grass.accept(level, (class_2338)BCLIB_BLOCK_POS);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    @Unique
    private boolean bclib_growWaterGrass(class_1937 level, class_2338 pos) {
        int y1 = pos.method_10264() + 3;
        int y2 = pos.method_10264() - 3;
        boolean result = false;
        block0: for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            int x = (int)((double)pos.method_10263() + level.field_9229.method_43059() * 2.0);
            int z = (int)((double)pos.method_10260() + level.field_9229.method_43059() * 2.0);
            BCLIB_BLOCK_POS.method_33097(x);
            BCLIB_BLOCK_POS.method_33099(z);
            for (int y = y1; y >= y2; --y) {
                BCLIB_BLOCK_POS.method_33098(y);
                class_2338 down = BCLIB_BLOCK_POS.method_10074();
                if (!BlocksHelper.isFluid(level.method_8320((class_2338)BCLIB_BLOCK_POS)) || BlocksHelper.isFluid(level.method_8320(down))) continue;
                BiConsumer<class_1937, class_2338> grass = this.bclib_getWaterGrassState(level, down);
                if (grass == null) continue block0;
                grass.accept(level, (class_2338)BCLIB_BLOCK_POS);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    @Unique
    private BiConsumer<class_1937, class_2338> bclib_getLandGrassState(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return BonemealAPI.getLandGrass(BiomeAPI.getBiomeID((class_6880<class_1959>)level.method_23753(pos)), state.method_26204(), level.method_8409());
    }

    @Unique
    private BiConsumer<class_1937, class_2338> bclib_getWaterGrassState(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return BonemealAPI.getWaterGrass(BiomeAPI.getBiomeID((class_6880<class_1959>)level.method_23753(pos)), state.method_26204(), level.method_8409());
    }

    @Unique
    private class_2680 bclib_getSpreadable(class_1937 level, class_2338 pos) {
        class_2382[] offsets = MHelper.getOffsets(level.method_8409());
        class_2680 center = level.method_8320(pos);
        for (class_2382 dir : offsets) {
            class_2338 p = pos.method_10081(dir);
            class_2680 state = level.method_8320(p);
            class_2248 terrain = BonemealAPI.getSpreadable(state.method_26204());
            if (!center.method_27852(terrain)) continue;
            if (this.bclib_haveSameProperties(state, center)) {
                for (class_2769 property : center.method_28501()) {
                    state = (class_2680)state.method_11657(property, center.method_11654(property));
                }
            }
            return state;
        }
        return null;
    }

    @Unique
    private boolean bclib_haveSameProperties(class_2680 state1, class_2680 state2) {
        class_2769[] properties2;
        class_2769[] properties1 = state1.method_28501().toArray(new class_2769[0]);
        if (properties1.length != (properties2 = state2.method_28501().toArray(new class_2769[0])).length) {
            return false;
        }
        for (int i = 0; i < properties1.length; ++i) {
            String name2;
            String name1 = properties1[i].method_11899();
            if (name1.equals(name2 = properties2[i].method_11899())) continue;
            return false;
        }
        return true;
    }
}

