/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.fabricmc.fabric.impl.client.texture.FabricSprite;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.client.render.EmissiveTextureInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1059.class})
public class TextureAtlasMixin {
    private static final int EMISSIVE_ALPHA = -33554432;
    private boolean bclib_modifyAtlas;

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void bclib_onAtlasInit(class_2960 resourceLocation, CallbackInfo info) {
        boolean hasOptifine = FabricLoader.getInstance().isModLoaded("optifabric");
        boolean bl = this.bclib_modifyAtlas = !hasOptifine && resourceLocation.toString().equals("minecraft:textures/atlas/blocks.png");
        if (this.bclib_modifyAtlas) {
            EmissiveTextureInfo.clear();
        }
    }

    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"}, at={@At(value="HEAD")}, cancellable=true)
    private void bclib_loadSprite(class_3300 resourceManager, class_1058.class_4727 spriteInfo, int atlasWidth, int atlasHeight, int maxLevel, int posX, int posY, CallbackInfoReturnable<class_1058> info) {
        if (!this.bclib_modifyAtlas) {
            return;
        }
        class_2960 location = spriteInfo.method_24121();
        if (!location.method_12832().startsWith("block")) {
            return;
        }
        class_2960 emissiveLocation = new class_2960(location.method_12836(), "textures/" + location.method_12832() + "_e.png");
        Optional emissiveRes = resourceManager.method_14486(emissiveLocation);
        if (emissiveRes.isPresent()) {
            class_1011 sprite = null;
            class_1011 emission = null;
            try {
                class_2960 spriteLocation = new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png");
                class_3298 resource = resourceManager.method_14486(spriteLocation).orElse(null);
                sprite = class_1011.method_4309((InputStream)resource.method_14482());
                resource = (class_3298)emissiveRes.get();
                emission = class_1011.method_4309((InputStream)resource.method_14482());
            }
            catch (IOException e) {
                BCLib.LOGGER.warning(e.getMessage(), new Object[0]);
            }
            if (sprite != null && emission != null) {
                int width = Math.min(sprite.method_4307(), emission.method_4307());
                int height = Math.min(sprite.method_4323(), emission.method_4323());
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int argb = emission.method_4315(x, y);
                        int alpha = argb >> 24 & 0xFF;
                        if (alpha <= 127) continue;
                        int r = argb >> 16 & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb & 0xFF;
                        if (r <= 0 && g <= 0 && b <= 0) continue;
                        argb = argb & 0xFFFFFF | 0xFE000000;
                        sprite.method_4305(x, y, argb);
                    }
                }
                class_1059 self = (class_1059)this;
                FabricSprite result = new FabricSprite(self, spriteInfo, maxLevel, atlasWidth, atlasHeight, posX, posY, sprite);
                EmissiveTextureInfo.addTexture(location);
                info.setReturnValue((Object)result);
            }
        }
    }
}

