/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.complex;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.betterx.bclib.items.complex.EquipmentDescription;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class EquipmentSet {
    public final class_1832 material;
    public final String baseName;
    public final String modID;
    public final class_1935 stick;
    public static final String PICKAXE_SLOT = "pickaxe";
    public static final String AXE_SLOT = "axe";
    public static final String SHOVEL_SLOT = "shovel";
    public static final String SWORD_SLOT = "sword";
    public static final String HOE_SLOT = "hoe";
    public static final String SHEARS_SLOT = "shears";
    public static final String HELMET_SLOT = "helmet";
    public static final String CHESTPLATE_SLOT = "chestplate";
    public static final String LEGGINGS_SLOT = "leggings";
    public static final String BOOTS_SLOT = "boots";
    public final SetValues attackDamage;
    public final SetValues attackSpeed;
    private final Map<String, EquipmentDescription<?>> descriptions = new HashMap();

    @Deprecated(forRemoval=true)
    public EquipmentSet(class_1832 material, String modID, String baseName, class_1935 stick) {
        this(material, modID, baseName, stick, AttackDamage.IRON_LEVEL, AttackSpeed.IRON_LEVEL);
    }

    public EquipmentSet(class_1832 material, String modID, String baseName, class_1935 stick, SetValues attackDamage, SetValues attackSpeed) {
        this.material = material;
        this.baseName = baseName;
        this.modID = modID;
        this.stick = stick;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
    }

    protected <I extends class_1792> void add(String slot, EquipmentDescription<I> desc) {
        this.descriptions.put(slot, desc);
    }

    protected <I extends class_1792> void add(String slot, EquipmentSet baseSet, ItemDescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<class_1792> desc = descriptor.build((class_1792)baseSet.getSlot(slot), tier -> item.build((class_1832)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    protected <I extends class_1792> void add(String slot, DescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<class_1792> desc = descriptor.build(tier -> item.build((class_1832)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    public EquipmentSet init(ItemRegistry itemsRegistry) {
        for (Map.Entry<String, EquipmentDescription<?>> desc : this.descriptions.entrySet()) {
            desc.getValue().init(this.buildID(desc), itemsRegistry, this.material, this.stick);
        }
        return this;
    }

    @NotNull
    protected class_2960 buildID(Map.Entry<String, EquipmentDescription<?>> desc) {
        return new class_2960(this.modID, this.baseName + "_" + desc.getKey());
    }

    public <I extends class_1792> I getSlot(String slot) {
        return (I)this.descriptions.get(slot).getItem();
    }

    public static class AttackDamage {
        public static SetValues WOOD_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 6.0f).add("hoe", 0.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 7.0f).add("hoe", -1.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 6.0f).add("hoe", 0.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 6.0f).add("hoe", -2.0f);
        public static SetValues DIAMOND_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 5.0f).add("hoe", -3.0f);
        public static SetValues NETHERITE_LEVEL = SetValues.create().add("sword", 3.0f).add("shovel", 1.5f).add("pickaxe", 1.0f).add("axe", 5.0f).add("hoe", -4.0f);
    }

    public static class SetValues {
        private final Map<String, Float> values = new HashMap<String, Float>();

        private SetValues() {
        }

        public static SetValues create() {
            return new SetValues();
        }

        public static SetValues copy(SetValues source, float offset) {
            SetValues v = SetValues.create();
            for (Map.Entry<String, Float> e : source.values.entrySet()) {
                v.add(e.getKey(), e.getValue().floatValue() + offset);
            }
            return v;
        }

        public SetValues add(String slot, float value) {
            this.values.put(slot, Float.valueOf(value));
            return this;
        }

        public SetValues offset(String slot, float offset) {
            this.values.put(slot, Float.valueOf(this.get(slot) + offset));
            return this;
        }

        public float get(String slot) {
            return this.values.getOrDefault(slot, Float.valueOf(0.0f)).floatValue();
        }
    }

    public static class AttackSpeed {
        public static SetValues WOOD_LEVEL = SetValues.create().add("sword", -2.4f).add("shovel", -3.0f).add("pickaxe", -2.8f).add("axe", -3.2f).add("hoe", -3.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add("sword", -2.4f).add("shovel", -3.0f).add("pickaxe", -2.8f).add("axe", -3.2f).add("hoe", -2.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add("sword", -2.4f).add("shovel", -3.0f).add("pickaxe", -2.8f).add("axe", -3.0f).add("hoe", -3.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add("sword", -2.4f).add("shovel", -3.0f).add("pickaxe", -2.8f).add("axe", -3.1f).add("hoe", -1.0f);
        public static SetValues DIAMOND_LEVEL;
        public static SetValues NETHERITE_LEVEL;

        static {
            NETHERITE_LEVEL = DIAMOND_LEVEL = SetValues.create().add(EquipmentSet.SWORD_SLOT, -2.4f).add(EquipmentSet.SHOVEL_SLOT, -3.0f).add(EquipmentSet.PICKAXE_SLOT, -2.8f).add(EquipmentSet.AXE_SLOT, -3.0f).add(EquipmentSet.HOE_SLOT, 0.0f);
        }
    }

    public static interface ItemCreator<I extends class_1792> {
        public I build(class_1832 var1, float var2, float var3);
    }

    public static interface ItemDescriptorCreator<I extends class_1792> {
        public EquipmentDescription<I> build(class_1792 var1, Function<class_1832, I> var2);
    }

    public static interface DescriptorCreator<I extends class_1792> {
        public EquipmentDescription<I> build(Function<class_1832, I> var1);
    }
}

