/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.boat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1749;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.boat.BaseBoatItem;

public final class BoatTypeOverride {
    private static final String DEFAULT_LAYER = "main";
    private static final List<BoatTypeOverride> values = new ArrayList<BoatTypeOverride>(8);
    private final String name;
    private final class_2248 planks;
    private final int ordinal;
    public final class_2960 id;
    public final class_2960 boatTexture;
    public final class_2960 chestBoatTexture;
    public final class_5601 boatModelName;
    public final class_5601 chestBoatModelName;
    private class_554 boatModel;
    private class_554 chestBoatModel;
    private class_1749 boat;
    private class_1749 chestBoat;

    BoatTypeOverride(String modID, String name, class_2248 planks) {
        this.id = new class_2960(modID, name);
        this.name = name;
        this.planks = planks;
        int nr = Objects.hash(name);
        if (nr >= 0 && nr <= 1000) {
            nr += 1000;
        }
        while (BoatTypeOverride.byId(nr) != null) {
            BCLib.LOGGER.warning("Boat Type Ordinal " + nr + " is already used, searching for another one", new Object[0]);
            if (++nr < 0 || nr > 1000) continue;
            nr += 1000;
        }
        this.ordinal = nr;
        if (BCLib.isClient()) {
            this.boatModelName = BoatTypeOverride.createBoatModelName(this.id.method_12836(), this.id.method_12832());
            this.chestBoatModelName = BoatTypeOverride.createChestBoatModelName(this.id.method_12836(), this.id.method_12832());
            this.boatTexture = BoatTypeOverride.getTextureLocation(modID, name, false);
            this.chestBoatTexture = BoatTypeOverride.getTextureLocation(modID, name, true);
        } else {
            this.boatModelName = null;
            this.chestBoatModelName = null;
            this.boatTexture = null;
            this.chestBoatTexture = null;
        }
        values.add(this);
    }

    public class_554 getBoatModel(boolean chest) {
        return chest ? this.chestBoatModel : this.boatModel;
    }

    public void createBoatModels(class_5617.class_5618 context) {
        if (this.boatModel == null) {
            this.boatModel = new class_554(context.method_32167(this.boatModelName), false);
            this.chestBoatModel = new class_554(context.method_32167(this.chestBoatModelName), true);
        }
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public void setBoatItem(class_1749 item) {
        this.boat = item;
    }

    public class_1749 getBoatItem() {
        return this.boat;
    }

    public void setChestBoatItem(class_1749 item) {
        this.chestBoat = item;
    }

    public class_1749 getChestBoatItem() {
        return this.chestBoat;
    }

    public static Stream<BoatTypeOverride> values() {
        return values.stream();
    }

    private static class_5601 createBoatModelName(String modID, String name) {
        return new class_5601(new class_2960(modID, "boat/" + name), DEFAULT_LAYER);
    }

    private static class_5601 createChestBoatModelName(String modID, String name) {
        return new class_5601(new class_2960(modID, "chest_boat/" + name), DEFAULT_LAYER);
    }

    private static class_2960 getTextureLocation(String modID, String name, boolean chest) {
        if (chest) {
            return new class_2960(modID, "textures/entity/chest_boat/" + name + ".png");
        }
        return new class_2960(modID, "textures/entity/boat/" + name + ".png");
    }

    public static BoatTypeOverride create(String modID, String name, class_2248 planks) {
        BoatTypeOverride t = new BoatTypeOverride(modID, name, planks);
        return t;
    }

    public class_1749 createItem(boolean hasChest) {
        return this.createItem(hasChest, new class_1792.class_1793().method_7889(1).method_7892(class_1761.field_7923));
    }

    public class_1749 createItem(boolean hasChest, class_1792.class_1793 itemSettings) {
        BaseBoatItem item = new BaseBoatItem(hasChest, this, itemSettings);
        if (hasChest) {
            this.setChestBoatItem(item);
        } else {
            this.setBoatItem(item);
        }
        return item;
    }

    public static BoatTypeOverride byId(int i) {
        for (BoatTypeOverride t : values) {
            if (t.ordinal != i) continue;
            return t;
        }
        return null;
    }

    public static BoatTypeOverride byName(String string) {
        for (BoatTypeOverride t : values) {
            if (!t.name().equals(string)) continue;
            return t;
        }
        return null;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoatTypeOverride that = (BoatTypeOverride)obj;
        return Objects.equals(this.name, that.name) && this.ordinal == that.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal);
    }

    public String toString() {
        return "BoatTypeOverride[name=" + this.name + ", ordinal=" + this.ordinal + "]";
    }
}

