/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.client.gui.screens.BCLibLayoutScreen;
import org.betterx.bclib.client.gui.screens.WelcomeScreen;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.ui.layout.components.Button;
import org.betterx.ui.layout.components.Checkbox;
import org.betterx.ui.layout.components.HorizontalStack;
import org.betterx.ui.layout.components.LayoutComponent;
import org.betterx.ui.layout.components.Range;
import org.betterx.ui.layout.components.Tabs;
import org.betterx.ui.layout.components.VerticalScroll;
import org.betterx.ui.layout.components.VerticalStack;
import org.betterx.ui.layout.components.render.RenderHelper;
import org.betterx.ui.layout.values.Rectangle;
import org.betterx.ui.layout.values.Size;
import org.betterx.ui.vanilla.LayoutScreen;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.betterx.worlds.together.worldPreset.WorldGenSettingsComponentAccessor;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WorldSetupScreen
extends LayoutScreen {
    private final class_7193 context;
    private final class_525 createWorldScreen;
    private Range<Integer> netherBiomeSize;
    private Range<Integer> netherVerticalBiomeSize;
    private Range<Integer> landBiomeSize;
    private Range<Integer> voidBiomeSize;
    private Range<Integer> centerBiomeSize;
    private Range<Integer> barrensBiomeSize;
    private Range<Integer> innerRadius;
    private Checkbox bclibEnd;
    private Checkbox bclibNether;
    Checkbox endLegacy;
    Checkbox endCustomTerrain;
    Checkbox generateEndVoid;
    Checkbox netherLegacy;
    Checkbox netherVertical;
    Checkbox netherAmplified;
    Button netherButton;
    Button endButton;
    VerticalScroll<?> scroller;
    HorizontalStack title;
    IconState netherOff;
    IconState netherOn;
    IconState endOff;
    IconState endOn;
    double iconT = 0.5;
    double targetT = 1.0;

    public WorldSetupScreen(@Nullable class_525 parent, class_7193 context) {
        super((class_437)parent, (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.main"), 10, 10, 10);
        this.context = context;
        this.createWorldScreen = parent;
    }

    public LayoutComponent<?, ?> netherPage(BCLNetherBiomeSourceConfig netherConfig) {
        VerticalStack content = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fit()).centerHorizontal();
        content.addSpacer(8);
        this.bclibNether = content.addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.custom_biome_source"), netherConfig.mapVersion != BCLNetherBiomeSourceConfig.NetherBiomeMapType.VANILLA);
        this.netherLegacy = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.legacy_square"), netherConfig.mapVersion == BCLNetherBiomeSourceConfig.NetherBiomeMapType.SQUARE);
        this.netherAmplified = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.nether_amplified"), netherConfig.amplified);
        this.netherVertical = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.nether_vertical"), netherConfig.useVerticalBiomes);
        content.addSpacer(12);
        content.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.avg_biome_size")).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        this.netherBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.nether_biome_size"), 1, 512, netherConfig.biomeSize / 16);
        this.netherVerticalBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.nether_vertical_biome_size"), 1, 32, netherConfig.biomeSizeVertical / 16);
        this.bclibNether.onChange((cb, state) -> {
            this.netherLegacy.setEnabled(state);
            this.netherAmplified.setEnabled(state);
            this.netherVertical.setEnabled(state);
            this.netherBiomeSize.setEnabled(state);
            this.netherVerticalBiomeSize.setEnabled(state && this.netherVertical.isChecked());
        });
        this.netherVertical.onChange((cb, state) -> this.netherVerticalBiomeSize.setEnabled(state && this.bclibNether.isChecked()));
        content.addSpacer(8);
        return content.setDebugName("Nether page");
    }

    public LayoutComponent<?, ?> endPage(BCLEndBiomeSourceConfig endConfig) {
        VerticalStack content = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fit()).centerHorizontal();
        content.addSpacer(8);
        this.bclibEnd = content.addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.custom_biome_source"), endConfig.mapVersion != BCLEndBiomeSourceConfig.EndBiomeMapType.VANILLA);
        this.endLegacy = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.legacy_square"), endConfig.mapVersion == BCLEndBiomeSourceConfig.EndBiomeMapType.SQUARE);
        this.endCustomTerrain = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.custom_end_terrain"), endConfig.generatorVersion != BCLEndBiomeSourceConfig.EndBiomeGeneratorType.VANILLA);
        this.generateEndVoid = content.indent(20).addCheckbox(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.end_void"), endConfig.withVoidBiomes);
        content.addSpacer(12);
        content.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.avg_biome_size")).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        this.landBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.land_biome_size"), 1, 512, endConfig.landBiomesSize / 16);
        this.voidBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.void_biome_size"), 1, 512, endConfig.voidBiomesSize / 16);
        this.centerBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.center_biome_size"), 1, 512, endConfig.centerBiomesSize / 16);
        this.barrensBiomeSize = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.barrens_biome_size"), 1, 512, endConfig.barrensBiomesSize / 16);
        content.addSpacer(12);
        content.addText(WorldSetupScreen.fit(), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.other")).centerHorizontal();
        content.addHorizontalSeparator(8).alignTop();
        this.innerRadius = content.addRange(WorldSetupScreen.fixed(200), WorldSetupScreen.fit(), (class_2561)class_2561.method_43471((String)"title.screen.bclib.worldgen.central_radius"), 1, 512, (int)Math.sqrt(endConfig.innerVoidRadiusSquared) / 16);
        this.bclibEnd.onChange((cb, state) -> {
            this.endLegacy.setEnabled(state);
            this.endCustomTerrain.setEnabled(state);
            this.generateEndVoid.setEnabled(state);
            this.landBiomeSize.setEnabled(state && this.endCustomTerrain.isChecked());
            this.voidBiomeSize.setEnabled(state && this.endCustomTerrain.isChecked() && this.generateEndVoid.isChecked());
            this.centerBiomeSize.setEnabled(state && this.endCustomTerrain.isChecked());
            this.barrensBiomeSize.setEnabled(state && this.endCustomTerrain.isChecked());
        });
        this.endCustomTerrain.onChange((cb, state) -> {
            this.landBiomeSize.setEnabled(state);
            this.voidBiomeSize.setEnabled(state && this.generateEndVoid.isChecked());
            this.centerBiomeSize.setEnabled(state);
            this.barrensBiomeSize.setEnabled(state);
        });
        this.generateEndVoid.onChange((cb, state) -> this.voidBiomeSize.setEnabled(state && this.endCustomTerrain.isChecked()));
        content.addSpacer(8);
        return content.setDebugName("End Page");
    }

    private void updateSettings() {
        WorldGenSettingsComponentAccessor acc;
        class_2794 endGenerator;
        Map<class_5321<class_5363>, class_2794> betterxDimensions = TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD);
        Map<class_5321<class_5363>, class_2794> betterxAmplifiedDimensions = TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD_AMPLIFIED);
        Map<class_5321<class_5363>, class_2794> vanillaDimensions = TogetherWorldPreset.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050);
        BCLEndBiomeSourceConfig.EndBiomeMapType endVersion = BCLEndBiomeSourceConfig.DEFAULT.mapVersion;
        if (this.bclibEnd.isChecked()) {
            BCLEndBiomeSourceConfig endConfig = new BCLEndBiomeSourceConfig(this.endLegacy.isChecked() ? BCLEndBiomeSourceConfig.EndBiomeMapType.SQUARE : BCLEndBiomeSourceConfig.EndBiomeMapType.HEX, this.endCustomTerrain.isChecked() ? BCLEndBiomeSourceConfig.EndBiomeGeneratorType.PAULEVS : BCLEndBiomeSourceConfig.EndBiomeGeneratorType.VANILLA, this.generateEndVoid.isChecked(), (int)Math.pow(this.innerRadius.getValue() * 16, 2.0), this.centerBiomeSize.getValue() * 16, this.voidBiomeSize.getValue() * 16, this.landBiomeSize.getValue() * 16, this.barrensBiomeSize.getValue() * 16);
            class_2794 endGenerator2 = betterxDimensions.get(class_5363.field_25414);
            ((BCLibEndBiomeSource)endGenerator2.method_12098()).setTogetherConfig(endConfig);
            this.updateConfiguration((class_5321<class_5363>)class_5363.field_25414, (class_5321<class_2874>)class_7134.field_37668, endGenerator2);
        } else {
            endGenerator = vanillaDimensions.get(class_5363.field_25414);
            this.updateConfiguration((class_5321<class_5363>)class_5363.field_25414, (class_5321<class_2874>)class_7134.field_37668, endGenerator);
        }
        if (this.bclibNether.isChecked()) {
            BCLNetherBiomeSourceConfig netherConfig = new BCLNetherBiomeSourceConfig(this.netherLegacy.isChecked() ? BCLNetherBiomeSourceConfig.NetherBiomeMapType.SQUARE : BCLNetherBiomeSourceConfig.NetherBiomeMapType.HEX, this.netherBiomeSize.getValue() * 16, this.netherVerticalBiomeSize.getValue() * 16, this.netherVertical.isChecked(), this.netherAmplified.isChecked());
            class_2794 netherGenerator = (this.netherAmplified.isChecked() ? betterxAmplifiedDimensions : betterxDimensions).get(class_5363.field_25413);
            ((BCLibNetherBiomeSource)netherGenerator.method_12098()).setTogetherConfig(netherConfig);
            this.updateConfiguration((class_5321<class_5363>)class_5363.field_25413, (class_5321<class_2874>)class_7134.field_37667, netherGenerator);
        } else {
            endGenerator = vanillaDimensions.get(class_5363.field_25413);
            this.updateConfiguration((class_5321<class_5363>)class_5363.field_25413, (class_5321<class_2874>)class_7134.field_37667, endGenerator);
        }
        Object object = this.createWorldScreen.field_24588;
        if (object instanceof WorldGenSettingsComponentAccessor && (acc = (WorldGenSettingsComponentAccessor)object).bcl_getPreset().isPresent() && (object = acc.bcl_getPreset().get().comp_349()) instanceof TogetherWorldPreset) {
            TogetherWorldPreset worldPreset = (TogetherWorldPreset)((Object)object);
            acc.bcl_setPreset(Optional.of(class_6880.method_40223((Object)((Object)worldPreset.withDimensions((class_2378<class_5363>)this.createWorldScreen.field_24588.method_41884().comp_616().method_28609())))));
        }
    }

    private void updateConfiguration(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2794 chunkGenerator) {
        this.createWorldScreen.field_24588.method_41869((registryAccess, worldGenSettings) -> LevelGenUtil.replaceGenerator(dimensionKey, dimensionTypeKey, (class_5455)registryAccess, worldGenSettings, chunkGenerator));
    }

    @Override
    protected LayoutComponent<?, ?> addTitle(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add((LayoutComponent)content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    @Override
    protected LayoutComponent<?, ?> initContent() {
        WorldGenSettingsComponentAccessor acc;
        BCLEndBiomeSourceConfig endConfig = BCLEndBiomeSourceConfig.VANILLA;
        BCLNetherBiomeSourceConfig netherConfig = BCLNetherBiomeSourceConfig.VANILLA;
        Object object = this.createWorldScreen.field_24588;
        if (object instanceof WorldGenSettingsComponentAccessor && (acc = (WorldGenSettingsComponentAccessor)object).bcl_getPreset().isPresent() && (object = acc.bcl_getPreset().get().comp_349()) instanceof TogetherWorldPreset) {
            class_1966 class_19662;
            class_5363 netherStem;
            class_1966 class_19663;
            TogetherWorldPreset wp = (TogetherWorldPreset)((Object)object);
            class_5363 endStem = wp.getDimension((class_5321<class_5363>)class_5363.field_25414);
            if (endStem != null && (class_19663 = endStem.method_29571().method_12098()) instanceof BCLibEndBiomeSource) {
                BCLibEndBiomeSource bs = (BCLibEndBiomeSource)class_19663;
                endConfig = bs.getTogetherConfig();
            }
            if ((netherStem = wp.getDimension((class_5321<class_5363>)class_5363.field_25413)) != null && (class_19662 = netherStem.method_29571().method_12098()) instanceof BCLibNetherBiomeSource) {
                BCLibNetherBiomeSource bs = (BCLibNetherBiomeSource)class_19662;
                netherConfig = bs.getTogetherConfig();
            }
        }
        LayoutComponent<?, ?> netherPage = this.netherPage(netherConfig);
        LayoutComponent<?, ?> endPage = this.endPage(endConfig);
        Tabs main = new Tabs(WorldSetupScreen.fill(), WorldSetupScreen.fill()).setPadding(8, 0, 0, 0);
        main.addPage((class_2561)class_2561.method_43471((String)"title.bclib.the_nether"), VerticalScroll.create(netherPage));
        main.addSpacer(8);
        this.scroller = VerticalScroll.create(endPage);
        main.addPage((class_2561)class_2561.method_43471((String)"title.bclib.the_end"), this.scroller);
        this.netherButton = main.getButton(0);
        this.endButton = main.getButton(1);
        this.title = (HorizontalStack)((HorizontalStack)new HorizontalStack(WorldSetupScreen.fit(), WorldSetupScreen.fit()).setDebugName("title bar")).alignBottom();
        this.title.addImage(WorldSetupScreen.fixed(22), WorldSetupScreen.fixed(22), BCLibLayoutScreen.BCLIB_LOGO_WHITE_LOCATION, Size.of(256)).setDebugName("icon");
        this.title.addSpacer(4);
        VerticalStack logos = this.title.addColumn(WorldSetupScreen.fit(), WorldSetupScreen.fit());
        logos.addImage(WorldSetupScreen.fixed(59), WorldSetupScreen.fixed(13), WelcomeScreen.BETTERX_LOCATION, Size.of(178, 40));
        logos.add((LayoutComponent)super.buildTitle());
        logos.addSpacer(2);
        main.addFiller();
        main.addComponent(this.title);
        VerticalStack rows = new VerticalStack(WorldSetupScreen.fill(), WorldSetupScreen.fill());
        rows.add((LayoutComponent)main);
        rows.addSpacer(4);
        rows.addButton(WorldSetupScreen.fit(), WorldSetupScreen.fit(), class_5244.field_24334).onPress(bt -> {
            this.updateSettings();
            this.method_25419();
        }).alignRight();
        main.onPageChange((tabs, idx) -> {
            this.targetT = 1 - idx;
        });
        return rows;
    }

    @Override
    protected void renderBackground(class_4587 poseStack, int i, int j, float f) {
        class_332.method_25294((class_4587)poseStack, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-1120652220);
    }

    @Override
    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        int size;
        super.method_25394(poseStack, i, j, f);
        double SPEED = 0.05;
        if (this.targetT < this.iconT && this.iconT > 0.0) {
            this.iconT = Math.max(0.0, this.iconT - (double)f * 0.05);
        } else if (this.targetT > this.iconT && this.iconT < 1.0) {
            this.iconT = Math.min(1.0, this.iconT + (double)f * 0.05);
        }
        double t = this.iconT > 0.0 && this.iconT < 1.0 ? (this.targetT > this.iconT ? IconState.easeOutBounce(this.iconT) : 1.0 - IconState.easeOutBounce(1.0 - this.iconT)) : this.iconT;
        if (this.endButton != null) {
            if (this.endOff == null) {
                this.endOff = new IconState(this.endButton.getScreenBounds().right() - 12, this.endButton.getScreenBounds().top - 7, 16);
                this.endOn = new IconState((this.title.getScreenBounds().left - this.endButton.getScreenBounds().right()) / 2 + this.endButton.getScreenBounds().right() - 14, this.scroller.getScreenBounds().top - 16, 32);
            }
            poseStack.method_22903();
            poseStack.method_22904((double)IconState.lerp(t, this.endOn.left, this.endOff.left), (double)IconState.lerp(t, this.endOn.top, this.endOff.top), 0.0);
            size = IconState.lerp(t, this.endOn.size, this.endOff.size);
            RenderHelper.renderImage(poseStack, 0, 0, size, size, WelcomeScreen.ICON_BETTEREND, Size.of(32), new Rectangle(0, 0, 32, 32), 1.0f);
            poseStack.method_22909();
        }
        if (this.netherButton != null) {
            if (this.netherOff == null) {
                this.netherOff = new IconState(this.netherButton.getScreenBounds().right() - 12, this.netherButton.getScreenBounds().top - 7, 16);
                this.netherOn = this.endOn;
            }
            poseStack.method_22903();
            poseStack.method_22904((double)IconState.lerp(t, this.netherOff.left, this.netherOn.left), (double)IconState.lerp(t, this.netherOff.top, this.netherOn.top), 0.0);
            size = IconState.lerp(t, this.netherOff.size, this.netherOn.size);
            RenderHelper.renderImage(poseStack, 0, 0, size, size, WelcomeScreen.ICON_BETTERNETHER, Size.of(32), new Rectangle(0, 0, 32, 32), 1.0f);
            poseStack.method_22909();
        }
    }

    record IconState(int left, int top, int size) {
        static double easeInOutQuint(double t) {
            return t < 0.5 ? 16.0 * t * t * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 5.0) / 2.0;
        }

        static double easeOutBounce(double x) {
            double n1 = 7.5625;
            double d1 = 2.75;
            if (x < 0.36363636363636365) {
                return 7.5625 * x * x;
            }
            if (x < 0.7272727272727273) {
                return 7.5625 * (x -= 0.5454545454545454) * x + 0.75;
            }
            if (x < 0.9090909090909091) {
                return 7.5625 * (x -= 0.8181818181818182) * x + 0.9375;
            }
            return 7.5625 * (x -= 0.9545454545454546) * x + 0.984375;
        }

        static int lerp(double t, int x0, int x1) {
            return (int)((1.0 - t) * (double)x0 + t * (double)x1);
        }
    }
}

