/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5699;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;

public abstract class TemplateStructure
extends class_3195 {
    protected final List<Config> configs;

    public static <T extends TemplateStructure> Codec<T> simpleTemplateCodec(BiFunction<class_3195.class_7302, List<Config>, T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_3195.method_42697((RecordCodecBuilder.Instance)instance), (App)class_5699.method_36973((Codec)Config.CODEC.listOf()).fieldOf("configs").forGetter(ruinedPortalStructure -> ruinedPortalStructure.configs)).apply((Applicative)instance, instancer));
    }

    protected TemplateStructure(class_3195.class_7302 structureSettings, class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        this(structureSettings, List.of(new Config(location, offsetY, type, chance)));
    }

    protected TemplateStructure(class_3195.class_7302 structureSettings, List<Config> configs) {
        super(structureSettings);
        this.configs = configs;
    }

    protected Config randomConfig(class_5819 random) {
        if (this.configs.size() > 1) {
            float chanceSum = this.configs.parallelStream().map(c -> Float.valueOf(c.chance())).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue();
            float rnd = random.method_43057() * chanceSum;
            for (Config c2 : this.configs) {
                if (!((rnd -= c2.chance()) <= 0.0f)) continue;
                return c2;
            }
        } else {
            return this.configs.get(0);
        }
        return null;
    }

    protected boolean isLavaPlaceable(class_2680 state, class_2680 before) {
        return (state == null || state.method_27852(class_2246.field_10124)) && before.method_27852(class_2246.field_10164);
    }

    protected boolean isFloorPlaceable(class_2680 state, class_2680 before) {
        return (state == null || state.method_27852(class_2246.field_10124)) && before.method_26207().method_15799();
    }

    protected int erosion(class_5819 rnd) {
        return 0;
    }

    protected boolean cover(class_5819 rnd) {
        return false;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 ctx) {
        int searchStep;
        int minBaseCount;
        BiPredicate<class_2680, class_2680> isCorrectBase;
        int z;
        Config config = this.randomConfig((class_5819)ctx.comp_566());
        if (config == null) {
            return Optional.empty();
        }
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_8326();
        if (!this.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.method_8328())) {
            return Optional.empty();
        }
        class_5868 worldGenerationContext = new class_5868(ctx.comp_562(), ctx.comp_569());
        class_3499 structureTemplate = ctx.comp_565().method_15091(config.location);
        float minAirRatio = 0.6f;
        if (config.type == StructurePlacementType.LAVA) {
            isCorrectBase = this::isLavaPlaceable;
            minBaseCount = 5;
            searchStep = 1;
        } else if (config.type == StructurePlacementType.CEIL) {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = -1;
        } else {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = 1;
        }
        int seaLevel = ctx.comp_562().method_16398() + (searchStep > 0 ? 0 : structureTemplate.method_15166(class_2470.field_11467).method_10264() + config.offsetY);
        int maxHeight = worldGenerationContext.method_30458() - 4 - (searchStep > 0 ? structureTemplate.method_15166(class_2470.field_11467).method_10264() + config.offsetY : 0);
        class_2338 halfSize = new class_2338(structureTemplate.method_15160().method_10263() / 2, 0, structureTemplate.method_15160().method_10260() / 2);
        class_2470 rotation = StructureNBT.getRandomRotation((class_5819)ctx.comp_566());
        class_2415 mirror = StructureNBT.getRandomMirror((class_5819)ctx.comp_566());
        class_2338.class_2339 centerPos = new class_2338.class_2339(x, 0, z);
        class_3341 boundingBox = structureTemplate.method_27267((class_2338)centerPos, rotation, halfSize, mirror);
        List<class_4966> noiseColumns = ImmutableList.of((Object)new class_2338(boundingBox.method_22874().method_10263(), 0, boundingBox.method_22874().method_10260()), (Object)new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35417()), (Object)new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35417()), (Object)new class_2338(boundingBox.method_35415(), 0, boundingBox.method_35420()), (Object)new class_2338(boundingBox.method_35418(), 0, boundingBox.method_35420())).stream().map(blockPos -> ctx.comp_562().method_26261(blockPos.method_10263(), blockPos.method_10260(), ctx.comp_569(), ctx.comp_564())).toList();
        int y = noiseColumns.stream().map(column -> this.findY((class_4966)column, isCorrectBase, searchStep, seaLevel, maxHeight)).reduce(searchStep > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE, (p, c) -> searchStep > 0 ? Math.min(p, c) : Math.max(p, c));
        if (y >= maxHeight || y < seaLevel) {
            return Optional.empty();
        }
        if (!BCLStructure.isValidBiome(ctx, y)) {
            return Optional.empty();
        }
        int baseCount = noiseColumns.stream().map(column -> isCorrectBase.test(null, column.method_32892(y - searchStep))).filter(b -> b).map(b -> 1).reduce(0, (p, c) -> p + c);
        if (baseCount < minBaseCount) {
            return Optional.empty();
        }
        float airRatio = noiseColumns.stream().map(column -> Float.valueOf(this.airRatio((class_4966)column, y, boundingBox.method_14660(), searchStep))).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue() / (float)noiseColumns.size();
        if (airRatio < 0.6f) {
            return Optional.empty();
        }
        centerPos.method_33098(y - (searchStep == 1 ? 0 : structureTemplate.method_15166(class_2470.field_11467).method_10264()));
        int erosion = this.erosion((class_5819)ctx.comp_566());
        boolean cover = this.cover((class_5819)ctx.comp_566());
        return Optional.of(new class_3195.class_7150((class_2338)centerPos, structurePiecesBuilder -> structurePiecesBuilder.method_35462((class_3443)new TemplatePiece(ctx.comp_565(), config.location, centerPos.method_10069(0, config.offsetY, 0), rotation, mirror, halfSize, erosion, cover))));
    }

    private boolean hasValidBiomeAtRandomHeight(class_3195.class_7149 ctx, int x, int z) {
        int randomY = ctx.comp_566().method_39332(ctx.comp_569().method_31607(), ctx.comp_569().method_31600());
        class_6880 holder = ctx.comp_562().method_12098().method_38109(class_5742.method_33100((int)x), class_5742.method_33100((int)randomY), class_5742.method_33100((int)z), ctx.comp_564().method_42371());
        return ctx.comp_570().test(holder);
    }

    private float airRatio(class_4966 column, int y, int height, int searchStep) {
        int airCount = 0;
        for (int i = y; i < y + height && i > y - height; i += searchStep) {
            class_2680 state = column.method_32892(i);
            if (!state.method_26215() && !state.method_26207().method_15800()) continue;
            ++airCount;
        }
        return (float)airCount / (float)height;
    }

    private int findY(class_4966 column, BiPredicate<class_2680, class_2680> isCorrectBase, int searchStep, int seaLevel, int maxHeight) {
        int y;
        class_2680 state = column.method_32892(y - searchStep);
        for (y = searchStep > 0 ? seaLevel : maxHeight - 1; y < maxHeight && y >= seaLevel; y += searchStep) {
            class_2680 before = state;
            state = column.method_32892(y);
            if (isCorrectBase.test(state, before)) break;
        }
        return y;
    }

    public record Config(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, Config::new));
    }
}

