/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3341;
import net.minecraft.class_5281;

public class StructureWorld {
    private final Map<class_1923, Part> parts = Maps.newHashMap();
    private class_1923 lastPos;
    private Part lastPart;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public StructureWorld() {
    }

    public StructureWorld(class_2487 tag) {
        this.minX = tag.method_10550("minX");
        this.maxX = tag.method_10550("maxX");
        this.minY = tag.method_10550("minY");
        this.maxY = tag.method_10550("maxY");
        this.minZ = tag.method_10550("minZ");
        this.maxZ = tag.method_10550("maxZ");
        class_2499 map = tag.method_10554("parts", 10);
        map.forEach(element -> {
            class_2487 compound = (class_2487)element;
            Part part = new Part(compound);
            int x = compound.method_10550("x");
            int z = compound.method_10550("z");
            this.parts.put(new class_1923(x, z), part);
        });
    }

    public void setBlock(class_2338 pos, class_2680 state) {
        class_1923 cPos = new class_1923(pos);
        if (cPos.equals((Object)this.lastPos)) {
            this.lastPart.addBlock(pos, state);
            return;
        }
        Part part = this.parts.get(cPos);
        if (part == null) {
            part = new Part();
            this.parts.put(cPos, part);
            if (cPos.field_9181 < this.minX) {
                this.minX = cPos.field_9181;
            }
            if (cPos.field_9181 > this.maxX) {
                this.maxX = cPos.field_9181;
            }
            if (cPos.field_9180 < this.minZ) {
                this.minZ = cPos.field_9180;
            }
            if (cPos.field_9180 > this.maxZ) {
                this.maxZ = cPos.field_9180;
            }
        }
        if (pos.method_10264() < this.minY) {
            this.minY = pos.method_10264();
        }
        if (pos.method_10264() > this.maxY) {
            this.maxY = pos.method_10264();
        }
        part.addBlock(pos, state);
        this.lastPos = cPos;
        this.lastPart = part;
    }

    public boolean placeChunk(class_5281 world, class_1923 chunkPos) {
        Part part = this.parts.get(chunkPos);
        if (part != null) {
            class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
            part.placeChunk(chunk);
            return true;
        }
        return false;
    }

    public class_2487 toBNT() {
        class_2487 tag = new class_2487();
        tag.method_10569("minX", this.minX);
        tag.method_10569("maxX", this.maxX);
        tag.method_10569("minY", this.minY);
        tag.method_10569("maxY", this.maxY);
        tag.method_10569("minZ", this.minZ);
        tag.method_10569("maxZ", this.maxZ);
        class_2499 map = new class_2499();
        tag.method_10566("parts", (class_2520)map);
        this.parts.forEach((pos, part) -> map.add((Object)part.toNBT(pos.field_9181, pos.field_9180)));
        return tag;
    }

    public class_3341 getBounds() {
        if (this.minX == Integer.MAX_VALUE || this.maxX == Integer.MIN_VALUE || this.minZ == Integer.MAX_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return class_3341.method_14665();
        }
        return new class_3341(this.minX << 4, this.minY, this.minZ << 4, this.maxX << 4 | 0xF, this.maxY, this.maxZ << 4 | 0xF);
    }

    private static final class Part {
        Map<class_2338, class_2680> blocks = Maps.newHashMap();

        public Part() {
        }

        public Part(class_2487 tag) {
            class_2499 map = tag.method_10554("blocks", 10);
            class_2499 map2 = tag.method_10554("states", 10);
            class_2680[] states = new class_2680[map2.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = class_2512.method_10681((class_2487)((class_2487)map2.method_10534(i)));
            }
            map.forEach(element -> {
                class_2487 block = (class_2487)element;
                class_2338 pos = class_2512.method_10691((class_2487)block.method_10562("pos"));
                int stateID = block.method_10550("state");
                class_2680 state = stateID < states.length ? states[stateID] : class_2248.method_9531((int)stateID);
                this.blocks.put(pos, state);
            });
        }

        void addBlock(class_2338 pos, class_2680 state) {
            class_2338 inner = new class_2338(pos.method_10263() & 0xF, pos.method_10264(), pos.method_10260() & 0xF);
            this.blocks.put(inner, state);
        }

        void placeChunk(class_2791 chunk) {
            this.blocks.forEach((pos, state) -> chunk.method_12010(pos, state, false));
        }

        class_2487 toNBT(int x, int z) {
            class_2487 tag = new class_2487();
            tag.method_10569("x", x);
            tag.method_10569("z", z);
            class_2499 map = new class_2499();
            tag.method_10566("blocks", (class_2520)map);
            class_2499 stateMap = new class_2499();
            tag.method_10566("states", (class_2520)stateMap);
            int[] id = new int[1];
            HashMap states = Maps.newHashMap();
            this.blocks.forEach((pos, state) -> {
                int stateID = states.getOrDefault(states, -1);
                if (stateID < 0) {
                    int n = id[0];
                    id[0] = n + 1;
                    stateID = n;
                    states.put(state, stateID);
                    stateMap.add((Object)class_2512.method_10686((class_2680)state));
                }
                class_2487 block = new class_2487();
                block.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                block.method_10569("state", stateID);
                map.add((Object)block);
            });
            return tag;
        }
    }
}

