/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5847;
import net.minecraft.class_6862;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.worlds.together.tag.v3.TagManager;

public class BCLStructureBuilder<S extends class_3195> {
    private static final BCLStructureBuilder INSTANCE = new BCLStructureBuilder();
    private class_2960 structureID;
    private Function<class_3195.class_7302, S> structureBuilder;
    private class_2893.class_2895 step;
    private Codec<S> codec;
    private class_6874 placement;
    private class_6862<class_1959> biomeTag;
    private class_5847 terrainAdjustment;

    private BCLStructureBuilder() {
    }

    public static <S extends class_3195> BCLStructureBuilder<S> start(class_2960 structureID, Function<class_3195.class_7302, S> structureBuilder) {
        BCLStructureBuilder.INSTANCE.structureID = structureID;
        BCLStructureBuilder.INSTANCE.structureBuilder = structureBuilder;
        BCLStructureBuilder.INSTANCE.step = class_2893.class_2895.field_13173;
        BCLStructureBuilder.INSTANCE.terrainAdjustment = class_5847.field_28922;
        BCLStructureBuilder.INSTANCE.codec = null;
        BCLStructureBuilder.INSTANCE.placement = null;
        BCLStructureBuilder.INSTANCE.biomeTag = null;
        return INSTANCE;
    }

    public BCLStructureBuilder<S> adjustment(class_5847 value) {
        this.terrainAdjustment = value;
        return this;
    }

    public BCLStructureBuilder<S> step(class_2893.class_2895 value) {
        this.step = value;
        return this;
    }

    public BCLStructureBuilder<S> codec(Codec<S> value) {
        this.codec = value;
        return this;
    }

    public BCLStructureBuilder<S> placement(class_6874 value) {
        this.placement = value;
        return this;
    }

    public BCLStructureBuilder<S> randomPlacement(int spacing, int separation) {
        this.placement = new class_6872(spacing, separation, class_6873.field_36421, 13323129 + spacing + separation + this.structureID.toString().hashCode() % 10000);
        return this;
    }

    public BCLStructureBuilder<S> biomeTag(String modID, String path) {
        this.biomeTag = TagManager.BIOMES.makeStructureTag(modID, path);
        return this;
    }

    public BCLStructureBuilder<S> biomeTag(class_6862<class_1959> tag) {
        this.biomeTag = tag;
        return this;
    }

    public BCLStructure<S> build() {
        if (this.placement == null) {
            throw new IllegalStateException("Placement needs to be defined for " + this.structureID);
        }
        if (this.codec == null) {
            this.codec(class_3195.method_42699(this.structureBuilder));
        }
        if (this.biomeTag == null) {
            this.biomeTag(this.structureID.method_12836(), this.structureID.method_12832());
        }
        return new BCLStructure<S>(this.structureID, this.structureBuilder, this.step, this.placement, this.codec, this.biomeTag, this.terrainAdjustment);
    }
}

