/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn.base;

import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnType;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NullContents;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public record YabnArray(List<YabnElement> elements) implements YabnElement
{
    public YabnArray() {
        this(new ArrayList<YabnElement>());
    }

    public YabnArray add(YabnElement element) {
        this.elements.add(element == null ? NullContents.NULL : element);
        return this;
    }

    @Override
    public byte[] toData(@Nullable String key) {
        if (key == null) {
            return this.toData();
        }
        if (this.elements.isEmpty()) {
            return YabnElement.key(YabnType.EMPTY_ARRAY.id, key);
        }
        return ArrayUtils.addAll((byte[])YabnElement.key(YabnType.ARRAY.id, key), (byte[])this.internalData());
    }

    @Override
    public byte[] toData() {
        if (this.elements.isEmpty()) {
            return new byte[]{YabnType.EMPTY_ARRAY.id};
        }
        return ArrayUtils.addAll((byte[])new byte[]{YabnType.ARRAY.id}, (byte[])this.internalData());
    }

    private byte[] internalData() {
        byte[] data = new byte[]{};
        for (YabnElement element : this.elements) {
            data = ArrayUtils.addAll((byte[])data, (byte[])element.toData());
        }
        return ArrayUtils.addAll((byte[])data, (byte[])new byte[]{0});
    }
}

