/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.config.ConfigLoader;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.fabric.FabricConfigParser;
import com.teamresourceful.resourcefulconfig.common.config.fabric.FabricResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.fabric.JsoncObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class FabricConfigLoader
implements ConfigLoader {
    @Override
    public ResourcefulConfig registerConfig(Class<?> configClass) {
        try {
            FabricResourcefulConfig config = FabricConfigParser.parseConfig(configClass);
            config.load();
            config.save();
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to create config for " + configClass.getName());
            return null;
        }
    }

    public static JsoncObject saveConfig(ResourcefulConfig config, JsoncObject object) {
        for (Map.Entry<String, ? extends ResourcefulConfigEntry> entry : config.getEntries().entrySet()) {
            String id = entry.getKey();
            ResourcefulConfigEntry entry2 = entry.getValue();
            JsonElement element = FabricConfigLoader.getElement(ParsingUtils.getField(entry2.field()));
            if (element == null) continue;
            Comment comment = entry2.field().getAnnotation(Comment.class);
            object.add(id, comment != null ? comment.value() : null, (Int2ObjectFunction<String>)((Int2ObjectFunction)indent -> element.toString()));
        }
        for (Map.Entry<String, Object> entry : config.getSubConfigs().entrySet()) {
            object.add(entry.getKey(), null, FabricConfigLoader.saveConfig((ResourcefulConfig)entry.getValue(), new JsoncObject()));
        }
        return object;
    }

    private static JsonElement getElement(Object value) {
        if (value == null) {
            throw new NullPointerException("Config value cannot be null!");
        }
        if (value instanceof String) {
            String string = (String)value;
            return new JsonPrimitive(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new JsonPrimitive(number);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new JsonPrimitive(bool);
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return new JsonPrimitive(enumValue.name());
        }
        if (value.getClass().isArray()) {
            JsonArray array = new JsonArray();
            for (Object o : (Object[])value) {
                array.add(FabricConfigLoader.getElement(o));
            }
            return array;
        }
        return null;
    }

    public static void loadConfig(ResourcefulConfig config, JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).startsWith("#")) continue;
            Object v = entry.getValue();
            if (v instanceof JsonObject) {
                JsonObject subConfig = (JsonObject)v;
                config.getSubConfig((String)entry.getKey()).ifPresent(cat -> FabricConfigLoader.loadConfig(cat, subConfig));
                continue;
            }
            config.getEntry((String)entry.getKey()).ifPresent(data -> {
                if (!FabricConfigLoader.setValue((JsonElement)entry.getValue(), data)) {
                    System.out.println("Failed to set value for " + (String)entry.getKey());
                }
            });
        }
    }

    private static Object convert(JsonElement element, ResourcefulConfigEntry entry) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            ArrayList list = new ArrayList();
            array.forEach(e -> list.add(FabricConfigLoader.convert(e, entry)));
            return list;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                return switch (entry.type()) {
                    case EntryType.BYTE -> number.byteValue();
                    case EntryType.SHORT -> number.shortValue();
                    case EntryType.INTEGER -> number.intValue();
                    case EntryType.LONG -> number.longValue();
                    case EntryType.FLOAT -> Float.valueOf(number.floatValue());
                    case EntryType.DOUBLE -> number.doubleValue();
                    default -> number;
                };
            }
            if (primitive.isString()) {
                if (entry.type() == EntryType.ENUM) {
                    Enum<?> value = ParsingUtils.getEnum(entry.field().getType(), primitive.getAsString());
                    if (value != null) {
                        return value;
                    }
                    throw new IllegalArgumentException("Invalid enum value for " + entry.field().getName());
                }
                return primitive.getAsString();
            }
        }
        return null;
    }

    private static boolean setValue(JsonElement json, ResourcefulConfigEntry data) {
        Object o = FabricConfigLoader.convert(json, data);
        if (o instanceof List) {
            List list = (List)o;
            return data.setArray(list.toArray());
        }
        if (o instanceof String) {
            String string = (String)o;
            return data.setString(string);
        }
        if (o instanceof Boolean) {
            Boolean booleanValue = (Boolean)o;
            return data.setBoolean(booleanValue);
        }
        if (o instanceof Short) {
            Short shortValue = (Short)o;
            return data.setShort(shortValue);
        }
        if (o instanceof Byte) {
            Byte byteValue = (Byte)o;
            return data.setByte(byteValue);
        }
        if (o instanceof Float) {
            Float floatValue = (Float)o;
            return data.setFloat(floatValue.floatValue());
        }
        if (o instanceof Integer) {
            Integer integerValue = (Integer)o;
            return data.setInt(integerValue);
        }
        if (o instanceof Long) {
            Long longValue = (Long)o;
            return data.setLong(longValue);
        }
        if (o instanceof Double) {
            Double doubleValue = (Double)o;
            return data.setDouble(doubleValue);
        }
        if (o instanceof Enum) {
            Enum enumValue = (Enum)o;
            return data.setEnum(enumValue);
        }
        return true;
    }
}

