/*
 * Decompiled with CFR 0.152.
 */
package draylar.gofish.loot.biome;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import draylar.gofish.loot.biome.BiomePredicate;
import draylar.gofish.loot.biome.BiomeTagPredicate;
import draylar.gofish.registry.GoFishLoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class BiomeLootCondition
implements class_5341 {
    protected final BiomeTagPredicate category;
    protected final BiomePredicate biome;

    public BiomeLootCondition(BiomeTagPredicate category, BiomePredicate biome) {
        this.category = category;
        this.biome = biome;
    }

    public class_5342 method_29325() {
        return GoFishLoot.MATCH_BIOME;
    }

    public Set<class_169<?>> method_293() {
        return ImmutableSet.of();
    }

    public boolean test(class_47 lootContext) {
        class_243 origin = (class_243)lootContext.method_296(class_181.field_24424);
        if (origin != null) {
            class_6880 fisherBiome = lootContext.method_299().method_23753(new class_2338(origin));
            if (this.category == null || this.category.getValid().isEmpty()) {
                if (this.biome != null && !this.biome.getValid().isEmpty()) {
                    return this.biome.test((class_1937)lootContext.method_299(), (class_6880<class_1959>)fisherBiome);
                }
            } else if (!this.category.getValid().isEmpty()) {
                return this.category.test((class_6880<class_1959>)fisherBiome);
            }
        }
        return false;
    }

    public static class_5341.class_210 builder(class_5321<class_1959> ... biomes) {
        return BiomeLootCondition.builder(Collections.emptyList(), List.of(biomes));
    }

    public static class_5341.class_210 builder(class_6862<class_1959> ... categories) {
        return BiomeLootCondition.builder(Arrays.asList(categories), Collections.emptyList());
    }

    public static class_5341.class_210 builder(List<class_6862<class_1959>> categories, List<class_5321<class_1959>> biomes) {
        ArrayList<String> stringCats = new ArrayList<String>();
        ArrayList<String> stringBiomes = new ArrayList<String>();
        categories.forEach(category -> stringCats.add(category.comp_327().toString()));
        biomes.forEach(biome -> stringBiomes.add(biome.method_29177().toString()));
        return BiomeLootCondition.builder(BiomeTagPredicate.builder().setValidByString(stringCats), BiomePredicate.builder().setValidFromString(stringBiomes));
    }

    public static class_5341.class_210 builder(String category, String biome) {
        return BiomeLootCondition.builder(BiomeTagPredicate.builder().add(category), BiomePredicate.builder().add(biome));
    }

    public static class_5341.class_210 builder(BiomeTagPredicate.Builder categoryBuilder) {
        return BiomeLootCondition.builder(categoryBuilder, BiomePredicate.builder());
    }

    public static class_5341.class_210 builder(BiomePredicate.Builder biomeBuilder) {
        return BiomeLootCondition.builder(BiomeTagPredicate.builder(), biomeBuilder);
    }

    public static class_5341.class_210 builder(BiomeTagPredicate.Builder categoryBuilder, BiomePredicate.Builder biomeBuilder) {
        return () -> new BiomeLootCondition(categoryBuilder.build(), biomeBuilder.build());
    }

    public static class Serializer
    implements class_5335<BiomeLootCondition> {
        public void toJson(JsonObject jsonObject, BiomeLootCondition condition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("category", condition.category.toJson());
            jsonObject.add("biome", condition.biome.toJson());
        }

        public BiomeLootCondition fromJson(JsonObject obj, JsonDeserializationContext context) {
            BiomeTagPredicate categoryPredicate = obj.has("category") ? BiomeTagPredicate.fromJson(obj.get("category")) : BiomeTagPredicate.EMPTY;
            BiomePredicate biomePredicate = obj.has("biome") ? BiomePredicate.fromJson(obj.get("biome")) : BiomePredicate.EMPTY;
            return new BiomeLootCondition(categoryPredicate, biomePredicate);
        }
    }
}

