/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.fabric_quilt.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import elocindev.item_obliterator.fabric_quilt.config.ConfigEntries;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigBuilder {
    public static final Gson BUILDER = new GsonBuilder().setPrettyPrinting().create();
    public static final Path file = FabricLoader.getInstance().getConfigDir().resolve("item-obliterator.json");

    public static ConfigEntries loadConfig() {
        try {
            if (!Files.notExists(file, new LinkOption[0])) {
                String json = Files.readString(file);
                ConfigEntries configEntries = (ConfigEntries)BUILDER.fromJson(json, ConfigEntries.class);
                configEntries.blacklisted_items = configEntries.blacklisted_items == null ? new ArrayList() : configEntries.blacklisted_items;
                configEntries.only_disable_interactions = configEntries.only_disable_interactions == null ? new ArrayList() : configEntries.only_disable_interactions;
                configEntries.only_disable_attacks = configEntries.only_disable_attacks == null ? new ArrayList() : configEntries.only_disable_attacks;
                String updatedJson = BUILDER.toJson((Object)configEntries);
                Files.writeString(file, (CharSequence)updatedJson, new OpenOption[0]);
                return configEntries;
            }
            ConfigEntries exampleConfig = new ConfigEntries();
            exampleConfig.blacklisted_items.add("//Items here will be unusable completely");
            exampleConfig.blacklisted_items.add("examplemod:example_item");
            exampleConfig.only_disable_interactions.add("//Items here will not be able to be right-clicked (Interact)");
            exampleConfig.only_disable_interactions.add("examplemod:example_item");
            exampleConfig.only_disable_attacks.add("//Items here will not be able to be used to attack");
            exampleConfig.only_disable_attacks.add("examplemod:example_item");
            String defaultJson = BUILDER.toJson((Object)exampleConfig);
            Files.writeString(file, (CharSequence)defaultJson, new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }
}

