/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.EggLayingAnimal;
import com.starfish_studios.naturalist.entity.HidingAnimal;
import com.starfish_studios.naturalist.entity.ai.goal.EggLayingBreedGoal;
import com.starfish_studios.naturalist.entity.ai.goal.HideGoal;
import com.starfish_studios.naturalist.entity.ai.goal.LayEggGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Tortoise
extends class_1321
implements IAnimatable,
HidingAnimal,
EggLayingAnimal {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final class_1856 TEMPT_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.TORTOISE_TEMPT_ITEMS);
    private static final class_2940<Integer> VARIANT_ID = class_2945.method_12791(Tortoise.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(Tortoise.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LAYING_EGG = class_2945.method_12791(Tortoise.class, (class_2941)class_2943.field_13323);
    int layEggCounter;
    boolean isDigging;

    public Tortoise(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.17f).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23718, 0.6);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 pDamageSource) {
        return class_3417.field_15150;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        Tortoise tortoise = (Tortoise)NaturalistEntityTypes.TORTOISE.get().method_5883((class_1937)level);
        if (otherParent instanceof Tortoise) {
            Tortoise tortoiseParent = (Tortoise)otherParent;
            if (this.getVariant() == tortoiseParent.getVariant()) {
                tortoise.setVariant(this.getVariant());
            } else {
                tortoise.setVariant(this.field_5974.method_43056() ? tortoiseParent.getVariant() : this.getVariant());
            }
            tortoise.method_6174(this.field_5974.method_43056() ? tortoiseParent.method_6139() : this.method_6139());
        }
        return tortoise;
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_6880 holder = level.method_23753(this.method_24515());
        if (holder.method_40225(class_1972.field_9471) || holder.method_40225(class_1972.field_38748)) {
            this.setVariant(1);
        } else if (holder.method_40220(class_6908.field_36516) || holder.method_40225(class_1972.field_9475)) {
            this.setVariant(2);
        } else {
            this.setVariant(0);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(30.0);
            this.method_6033(30.0f);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
        }
        this.method_5996(class_5134.field_23721).method_6192(4.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, new EggLayingBreedGoal<Tortoise>(this, 1.0));
        this.field_6201.method_6277(1, new LayEggGoal<Tortoise>(this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, new HideGoal<Tortoise>(this));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.0, TEMPT_ITEMS, false));
        this.field_6201.method_6277(3, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, false));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
    }

    public boolean method_6474(class_1429 otherAnimal) {
        if (!this.method_6181()) {
            return false;
        }
        if (!(otherAnimal instanceof Tortoise)) {
            return false;
        }
        Tortoise tortoise = (Tortoise)otherAnimal;
        return tortoise.method_6181() && super.method_6474(otherAnimal);
    }

    public boolean method_6481(class_1799 stack) {
        return TEMPT_ITEMS.method_8093(stack);
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(this.method_6172() || this.canHide() ? strength / 4.0 : strength, x, z);
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, this.canHide() ? amount * 0.8f : amount);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 interactionResult;
        class_1799 itemStack = player.method_5998(hand);
        if (this.field_6002.field_9236) {
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return class_1269.field_5812;
            }
            if (this.method_6481(itemStack) && (this.method_6032() < this.method_6063() || !this.method_6181())) {
                return class_1269.field_5812;
            }
            if (itemStack.method_7909() instanceof class_1820) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.method_6171((class_1309)player)) {
                if (this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                    this.method_6475(player, hand, itemStack);
                    this.method_6025(3.0f);
                    return class_1269.field_21466;
                }
                class_1269 interactionResult2 = super.method_5992(player, hand);
                if (!interactionResult2.method_23665() || this.method_6109()) {
                    this.method_24346(!this.method_24345());
                }
                return interactionResult2;
            }
        } else if (this.method_6481(itemStack)) {
            this.method_6475(player, hand, itemStack);
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_24346(true);
                this.field_6002.method_8421((class_1297)this, (byte)7);
            } else {
                this.field_6002.method_8421((class_1297)this, (byte)6);
            }
            this.method_5971();
            return class_1269.field_21466;
        }
        if ((interactionResult = super.method_5992(player, hand)).method_23665()) {
            this.method_5971();
        }
        return interactionResult;
    }

    @Override
    public boolean canHide() {
        if (this.method_6181()) {
            return false;
        }
        List players = this.field_6002.method_18464(class_4051.method_36626().method_18418(5.0).method_18420(livingEntity -> class_1301.field_6156.test(livingEntity) && !livingEntity.method_21751() && !livingEntity.method_24520((Predicate)TEMPT_ITEMS)), (class_1309)this, this.method_5829().method_1009(5.0, 3.0, 5.0));
        return !players.isEmpty();
    }

    protected float method_6120() {
        return 0.96f;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.3f;
    }

    public double method_29241() {
        return 0.4;
    }

    public boolean method_6094() {
        return true;
    }

    public int getVariant() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(VARIANT_ID)), (int)0, (int)2);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT_ID, (Object)variant);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT_ID, (Object)0);
        this.field_6011.method_12784(HAS_EGG, (Object)false);
        this.field_6011.method_12784(LAYING_EGG, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10556("HasEgg", this.hasEgg());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.setHasEgg(compound.method_10577("HasEgg"));
    }

    public void method_5879() {
        super.method_5879();
    }

    public void registerControllers(AnimationData animationData) {
        animationData.setResetSpeedInTicks(5.0);
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "hurtController", 5.0f, this::hurtPredicate));
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        super.method_5712(pos, state);
    }

    private <T extends IAnimatable> PlayState predicate(AnimationEvent<T> event) {
        AnimationBuilder builder = new AnimationBuilder();
        if (this.method_6172()) {
            event.getController().setAnimation(builder.loop("tortoise.sit"));
            return PlayState.CONTINUE;
        }
        if (this.canHide()) {
            event.getController().setAnimation(builder.loop("tortoise.hide"));
            return PlayState.CONTINUE;
        }
        if (this.isLayingEgg()) {
            event.getController().setAnimation(builder.loop("tortoise.dig"));
            return PlayState.CONTINUE;
        }
        if (this.method_18798().method_37268() > 1.0E-6) {
            event.getController().setAnimation(builder.loop("tortoise.walk"));
            if (this.method_6109()) {
                event.getController().setAnimationSpeed(2.0);
            } else {
                event.getController().setAnimationSpeed(1.1);
            }
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <T extends IAnimatable> PlayState hurtPredicate(AnimationEvent<T> event) {
        AnimationBuilder builder = new AnimationBuilder();
        if (this.field_6235 > 0) {
            event.getController().setAnimation(builder.loop("tortoise.hurt"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean isLayingEgg) {
        this.field_6011.method_12778(LAYING_EGG, (Object)isLayingEgg);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    @Override
    public class_2248 getEggBlock() {
        return NaturalistRegistry.TORTOISE_EGG.get();
    }

    @Override
    public class_6862<class_2248> getEggLayableBlockTag() {
        return NaturalistTags.BlockTags.TORTOISE_EGG_LAYABLE_ON;
    }

    public boolean method_6482() {
        return super.method_6482() && !this.hasEgg();
    }

    public void method_6007() {
        super.method_6007();
        class_2338 pos = this.method_24515();
        if (this.method_5805() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0 && this.field_6002.method_8320(pos.method_10074()).method_26164(this.getEggLayableBlockTag())) {
            this.field_6002.method_20290(2001, pos, class_2248.method_9507((class_2680)this.field_6002.method_8320(pos.method_10074())));
        }
    }
}

