/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Firefly
extends class_1429
implements class_1432,
IAnimatable {
    private static final class_2940<Integer> GLOW_TICKS_REMAINING = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SUN_TICKS = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13327);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public Firefly(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        class_1407 navigation = new class_1407((class_1308)this, pLevel){

            public boolean method_6333(class_2338 pPos) {
                return !this.field_6677.method_8320(pPos.method_10074()).method_26215();
            }
        };
        navigation.method_6332(false);
        navigation.method_6354(false);
        navigation.method_6331(true);
        return navigation;
    }

    protected float method_18394(class_4050 pPose, class_4048 pSize) {
        return pSize.field_18068 * 0.5f;
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        return false;
    }

    protected void method_5623(double pY, boolean pOnGround, class_2680 pState, class_2338 pPos) {
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new FireflyHideInGrassGoal(this, 1.2f, 10, 4));
        this.field_6201.method_6277(2, (class_1352)new FlyingWanderGoal((class_1314)this));
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f);
    }

    public static boolean checkFireflySpawnRules(class_1299<? extends Firefly> pType, class_5425 pLevel, class_3730 pReason, class_2338 pPos, class_5819 pRandom) {
        return class_1588.method_20679((class_5425)pLevel, (class_2338)pPos, (class_5819)pRandom) && pLevel.method_8320(pPos.method_10074()).method_26164(NaturalistTags.BlockTags.FIREFLIES_SPAWNABLE_ON);
    }

    @Nullable
    public class_1296 method_5613(class_3218 p_146743_, class_1296 p_146744_) {
        return null;
    }

    public boolean method_6481(class_1799 pStack) {
        return false;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GLOW_TICKS_REMAINING, (Object)0);
        this.field_6011.method_12784(SUN_TICKS, (Object)0);
    }

    public boolean isGlowing() {
        return (Integer)this.field_6011.method_12789(GLOW_TICKS_REMAINING) > 0;
    }

    public int getGlowTicksRemaining() {
        return (Integer)this.field_6011.method_12789(GLOW_TICKS_REMAINING);
    }

    private void setGlowTicks(int ticks) {
        this.field_6011.method_12778(GLOW_TICKS_REMAINING, (Object)ticks);
    }

    public int getSunTicks() {
        return (Integer)this.field_6011.method_12789(SUN_TICKS);
    }

    private void setSunTicks(int ticks) {
        this.field_6011.method_12778(SUN_TICKS, (Object)ticks);
    }

    public void method_6007() {
        super.method_6007();
        int ticks = this.getGlowTicksRemaining();
        if (ticks > 0) {
            this.setGlowTicks(ticks - 1);
        }
        if (this.canGlow() && (double)this.field_5974.method_43057() <= 0.01 && !this.isGlowing()) {
            this.setGlowTicks(40 + this.field_5974.method_43048(20));
        }
        if (this.method_5972()) {
            this.setSunTicks(this.getSunTicks() + 1);
            if (this.getSunTicks() > 600) {
                class_2338 pos = this.method_24515();
                if (!this.field_6002.field_9236) {
                    for (int i = 0; i < 20; ++i) {
                        double x = this.field_5974.method_43059() * 0.02;
                        double y = this.field_5974.method_43059() * 0.02;
                        double z = this.field_5974.method_43059() * 0.02;
                        ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11203, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 1, x, y, z, (double)0.15f);
                    }
                }
                this.field_6002.method_8396(null, this.method_24515(), NaturalistSoundEvents.FIREFLY_HIDE.get(), class_3419.field_15254, 0.7f, 0.9f + this.field_6002.field_9229.method_43057() * 0.2f);
                this.method_31472();
            }
        }
    }

    private boolean canGlow() {
        if (!this.field_6002.field_9236) {
            return this.field_6002.method_23886() || this.field_6002.method_22339(this.method_24515()) < 8;
        }
        return false;
    }

    protected boolean method_5972() {
        if (this.field_6002.method_8530() && !this.method_16914() && !this.field_6002.field_9236) {
            return this.method_5718() > 0.5f;
        }
        return false;
    }

    public boolean method_5776() {
        return this.method_6581() && this.field_6012 % class_3532.method_15386((float)1.4959966f) == 0;
    }

    public boolean method_6581() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_16914();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 pDamageSource) {
        return NaturalistSoundEvents.FIREFLY_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return NaturalistSoundEvents.FIREFLY_DEATH.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.method_6581()) {
            event.getController().setAnimation(new AnimationBuilder().loop("firefly.fly"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class FireflyHideInGrassGoal
    extends class_1367 {
        private final Firefly firefly;

        public FireflyHideInGrassGoal(Firefly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((class_1314)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.firefly = pMob;
        }

        public boolean method_6264() {
            return this.firefly.method_5972() && super.method_6264();
        }

        protected boolean method_6296(class_4538 pLevel, class_2338 pPos) {
            return pLevel.method_8320(pPos).method_27852(class_2246.field_10479) || pLevel.method_8320(pPos).method_27852(class_2246.field_10112) || pLevel.method_8320(pPos).method_27852(class_2246.field_10214);
        }

        public void method_6268() {
            super.method_6268();
            class_1937 level = this.firefly.field_6002;
            if (this.method_6295()) {
                if (!level.field_9236) {
                    ((class_3218)level).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10479.method_9564()), this.firefly.method_23317(), this.firefly.method_23318(), this.firefly.method_23321(), 50, (double)(this.firefly.method_17681() / 4.0f), (double)(this.firefly.method_17682() / 4.0f), (double)(this.firefly.method_17681() / 4.0f), 0.05);
                }
                level.method_8396(null, this.firefly.method_24515(), NaturalistSoundEvents.FIREFLY_HIDE.get(), class_3419.field_15254, 0.7f, 0.9f + level.field_9229.method_43057() * 0.2f);
                this.firefly.method_31472();
            }
        }

        protected class_2338 method_30953() {
            return this.field_6512;
        }
    }
}

