/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.PlaceholderCategory;
import dev.isxander.yacl.api.YetAnotherConfigLib;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.api.utils.MutableDimension;
import dev.isxander.yacl.api.utils.OptionUtils;
import dev.isxander.yacl.gui.CategoryListWidget;
import dev.isxander.yacl.gui.OptionListWidget;
import dev.isxander.yacl.gui.SearchFieldWidget;
import dev.isxander.yacl.gui.TooltipButtonWidget;
import dev.isxander.yacl.gui.utils.GuiUtils;
import dev.isxander.yacl.impl.utils.YACLConstants;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class YACLScreen
extends class_437 {
    public final YetAnotherConfigLib config;
    private int currentCategoryIdx;
    private final class_437 parent;
    public OptionListWidget optionList;
    public CategoryListWidget categoryList;
    public TooltipButtonWidget finishedSaveButton;
    public TooltipButtonWidget cancelResetButton;
    public TooltipButtonWidget undoButton;
    public SearchFieldWidget searchFieldWidget;
    public class_2561 saveButtonMessage;
    public class_2561 saveButtonTooltipMessage;
    private int saveButtonMessageTime;

    public YACLScreen(YetAnotherConfigLib config, class_437 parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
        this.currentCategoryIdx = 0;
    }

    protected void method_25426() {
        int columnWidth = this.field_22789 / 3;
        int padding = columnWidth / 20;
        columnWidth = Math.min(columnWidth, 400);
        int paddedWidth = columnWidth - padding * 2;
        MutableDimension<Integer> actionDim = Dimension.ofInt(this.field_22789 / 3 / 2, this.field_22790 - padding - 20, paddedWidth, 20);
        this.finishedSaveButton = new TooltipButtonWidget(this, (Integer)actionDim.x() - (Integer)actionDim.width() / 2, (Integer)actionDim.y(), (Integer)actionDim.width(), (Integer)actionDim.height(), (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), btn -> this.finishOrSave());
        actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
        this.cancelResetButton = new TooltipButtonWidget(this, (Integer)actionDim.x() - (Integer)actionDim.width() / 2, (Integer)actionDim.y(), (Integer)actionDim.width(), (Integer)actionDim.height(), (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), btn -> this.cancelOrReset());
        actionDim.move((Integer)actionDim.width() + 4, 0);
        this.undoButton = new TooltipButtonWidget(this, (Integer)actionDim.x() - (Integer)actionDim.width() / 2, (Integer)actionDim.y(), (Integer)actionDim.width(), (Integer)actionDim.height(), (class_2561)class_2561.method_43471((String)"yacl.gui.undo"), (class_2561)class_2561.method_43471((String)"yacl.gui.undo.tooltip"), btn -> this.undo());
        this.searchFieldWidget = new SearchFieldWidget(this, this.field_22793, this.field_22789 / 3 / 2 - paddedWidth / 2 + 1, this.undoButton.field_22761 - 22, paddedWidth - 2, 18, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"), (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"));
        this.categoryList = new CategoryListWidget(this.field_22787, this, this.field_22789, this.field_22790);
        this.method_25429((class_364)this.categoryList);
        this.updateActionAvailability();
        this.method_37063((class_364)this.searchFieldWidget);
        this.method_37063((class_364)this.cancelResetButton);
        this.method_37063((class_364)this.undoButton);
        this.method_37063((class_364)this.finishedSaveButton);
        this.optionList = new OptionListWidget(this, this.field_22787, this.field_22789, this.field_22790);
        this.method_25429((class_364)this.optionList);
        this.config.initConsumer().accept(this);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.categoryList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchFieldWidget.method_25394(matrices, mouseX, mouseY, delta);
        this.optionList.method_25394(matrices, mouseX, mouseY, delta);
        this.categoryList.postRender(matrices, mouseX, mouseY, delta);
        this.optionList.postRender(matrices, mouseX, mouseY, delta);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof TooltipButtonWidget)) continue;
            TooltipButtonWidget tooltipButtonWidget = (TooltipButtonWidget)child;
            tooltipButtonWidget.renderHoveredTooltip(matrices);
        }
    }

    protected void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.field_22787));
        } else {
            this.method_25419();
        }
    }

    protected void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.method_25419();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    protected void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.optionList.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.optionList.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void changeCategory(int idx) {
        Object object;
        if (idx == this.currentCategoryIdx) {
            return;
        }
        if (idx != -1 && (object = this.config.categories().get(idx)) instanceof PlaceholderCategory) {
            PlaceholderCategory placeholderCategory = (PlaceholderCategory)object;
            this.field_22787.method_1507(placeholderCategory.screen().apply(this.field_22787, this));
        } else {
            this.currentCategoryIdx = idx;
            this.optionList.refreshOptions();
        }
    }

    public int getCurrentCategoryIdx() {
        return this.currentCategoryIdx;
    }

    private void updateActionAvailability() {
        boolean pendingChanges;
        this.undoButton.field_22763 = pendingChanges = this.pendingChanges();
        this.finishedSaveButton.method_25355((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", class_5244.field_24334)));
        this.finishedSaveButton.setTooltip((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save.tooltip") : class_2561.method_43471((String)"yacl.gui.finished.tooltip")));
        this.cancelResetButton.method_25355((class_2561)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", class_5244.field_24335) : class_2561.method_43471((String)"controls.reset")));
        this.cancelResetButton.setTooltip((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.cancel.tooltip") : class_2561.method_43471((String)"yacl.gui.reset.tooltip")));
    }

    public void method_25393() {
        this.searchFieldWidget.method_1865();
        this.updateActionAvailability();
        if (this.saveButtonMessage != null) {
            if (this.saveButtonMessageTime > 140) {
                this.saveButtonMessage = null;
                this.saveButtonTooltipMessage = null;
                this.saveButtonMessageTime = 0;
            } else {
                ++this.saveButtonMessageTime;
                this.finishedSaveButton.method_25355(this.saveButtonMessage);
                if (this.saveButtonTooltipMessage != null) {
                    this.finishedSaveButton.setTooltip(this.saveButtonTooltipMessage);
                }
            }
        }
    }

    private void setSaveButtonMessage(class_2561 message, class_2561 tooltip) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = tooltip;
        this.saveButtonMessageTime = 0;
    }

    private boolean pendingChanges() {
        AtomicBoolean pendingChanges = new AtomicBoolean(false);
        OptionUtils.consumeOptions(this.config, option -> {
            if (option.changed()) {
                pendingChanges.set(true);
                return true;
            }
            return false;
        });
        return pendingChanges.get();
    }

    public boolean method_25422() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit").method_27692(class_124.field_1061), (class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public static void renderMultilineTooltip(class_4587 matrices, class_327 font, class_5489 text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.method_30887() > 0) {
            int maxWidth = text.method_44048();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.method_30887() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = belowY;
            if (maxBelow < -8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.method_44048() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            matrices.method_22903();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            RenderSystem.setShader(class_757::method_34540);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            class_1159 matrix4f = matrices.method_23760().method_23761();
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY - 4), (int)(drawX + maxWidth + 3), (int)(drawY - 3), (int)400, (int)-267386864, (int)-267386864);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY + height + 3), (int)(drawX + maxWidth + 3), (int)(drawY + height + 4), (int)400, (int)-267386864, (int)-267386864);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY - 3), (int)(drawX + maxWidth + 3), (int)(drawY + height + 3), (int)400, (int)-267386864, (int)-267386864);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 4), (int)(drawY - 3), (int)(drawX - 3), (int)(drawY + height + 3), (int)400, (int)-267386864, (int)-267386864);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX + maxWidth + 3), (int)(drawY - 3), (int)(drawX + maxWidth + 4), (int)(drawY + height + 3), (int)400, (int)-267386864, (int)-267386864);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY - 3 + 1), (int)(drawX - 3 + 1), (int)(drawY + height + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX + maxWidth + 2), (int)(drawY - 3 + 1), (int)(drawX + maxWidth + 3), (int)(drawY + height + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY - 3), (int)(drawX + maxWidth + 3), (int)(drawY - 3 + 1), (int)400, (int)0x505000FF, (int)0x505000FF);
            YACLScreen.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(drawX - 3), (int)(drawY + height + 2), (int)(drawX + maxWidth + 3), (int)(drawY + height + 3), (int)400, (int)1344798847, (int)1344798847);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
            matrices.method_22904(0.0, 0.0, 400.0);
            text.method_30893(matrices, drawX, drawY, lineHeight, -1);
            matrices.method_22909();
        }
    }
}

