/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import org.jetbrains.annotations.Nullable;

public interface DisplaysHolder {
    public boolean doesCache();

    public void add(Display var1, @Nullable Object var2);

    public int size();

    public Map<CategoryIdentifier<?>, List<Display>> get();

    @Nullable
    public Object getDisplayOrigin(Display var1);

    public void endReload();

    public boolean isCached(Display var1);

    public Set<Display> getDisplaysNotCached();

    public Set<Display> getDisplaysByInput(EntryStack<?> var1);

    public Set<Display> getDisplaysByOutput(EntryStack<?> var1);

    default public Iterable<Display> getAllDisplaysByInputs(List<EntryStack<?>> stacks) {
        Set<Display> notCached;
        if (stacks.isEmpty()) {
            return List.of();
        }
        Iterable inputCached = null;
        if (this.doesCache()) {
            for (EntryStack<?> stack : stacks) {
                Set<Display> set = this.getDisplaysByInput(stack);
                inputCached = inputCached == null ? set : Iterables.concat(inputCached, set);
            }
            if (stacks.size() > 1) {
                inputCached = CollectionUtils.distinctReferenceOf(inputCached);
            }
        }
        if ((notCached = this.getDisplaysNotCached()).isEmpty()) {
            return inputCached == null ? List.of() : inputCached;
        }
        Iterable filteredNotCached = Iterables.filter(notCached, display -> ViewsImpl.isUsagesFor(null, stacks, display));
        if (inputCached == null) {
            return filteredNotCached;
        }
        return Iterables.concat(inputCached, (Iterable)filteredNotCached);
    }

    default public Iterable<Display> getAllDisplaysByOutputs(List<EntryStack<?>> stacks) {
        Set<Display> notCached;
        if (stacks.isEmpty()) {
            return List.of();
        }
        Iterable outputCached = null;
        if (this.doesCache()) {
            for (EntryStack<?> stack : stacks) {
                Set<Display> set = this.getDisplaysByOutput(stack);
                outputCached = outputCached == null ? set : Iterables.concat(outputCached, set);
            }
            if (stacks.size() > 1) {
                outputCached = CollectionUtils.distinctReferenceOf(outputCached);
            }
        }
        if ((notCached = this.getDisplaysNotCached()).isEmpty()) {
            return outputCached == null ? List.of() : outputCached;
        }
        Iterable filteredNotCached = Iterables.filter(notCached, display -> ViewsImpl.isRecipesFor(null, stacks, display));
        if (outputCached == null) {
            return filteredNotCached;
        }
        return Iterables.concat(outputCached, (Iterable)filteredNotCached);
    }
}

