/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.util.struct;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.util.struct.PosTree;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_2382;

class OctTree
implements PosTree {
    private final OctBox boundary;
    private final Map<OctBox.Octant, Object> children;
    private int validChildren;

    private OctTree(OctBox boundary) {
        this.boundary = boundary;
        this.children = new HashMap<OctBox.Octant, Object>();
        this.validChildren = 0;
        for (OctBox.Octant octant : OctBox.Octant.values()) {
            this.children.put(octant, null);
        }
    }

    public OctTree(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(new OctBox(minX, minY, minZ, maxX, maxY, maxZ));
    }

    @Override
    public void insert(class_2382 pos) {
        if (pos == null) {
            StrawgolemCommon.LOG.error("Tried inserting null BlockPos into OctTree, ignoring");
            return;
        }
        if (!this.boundary.isInBoundary(pos)) {
            StrawgolemCommon.LOG.error("Attempting to insert point outside of OctTree boundary");
            return;
        }
        OctBox.Octant childOctant = this.boundary.getOctant(pos);
        Object child = this.children.get((Object)childOctant);
        if (child == null) {
            this.children.put(childOctant, pos);
            ++this.validChildren;
        } else if (child instanceof class_2382) {
            class_2382 point = (class_2382)child;
            if (child.equals(pos)) {
                return;
            }
            OctTree tree = new OctTree(this.boundary.getOctantBox(childOctant));
            this.children.put(childOctant, tree);
            tree.insert(point);
            tree.insert(pos);
        } else {
            OctTree childTree = (OctTree)child;
            childTree.insert(pos);
        }
    }

    @Override
    public void delete(class_2382 pos) {
        if (pos == null) {
            StrawgolemCommon.LOG.error("Tried deleting null pos from OctTree, ignoring");
            return;
        }
        if (!this.boundary.isInBoundary(pos)) {
            StrawgolemCommon.LOG.error("Attempting to delete point outside of boundary: " + pos);
            return;
        }
        OctBox.Octant childOctant = this.boundary.getOctant(pos);
        Object child = this.children.get((Object)childOctant);
        if (child == null) {
            StrawgolemCommon.LOG.error("Tried deleting pos from null child tree, ignoring");
        } else if (child instanceof class_2382) {
            if (child.equals(pos)) {
                this.children.put(childOctant, null);
                --this.validChildren;
            }
        } else {
            OctTree childTree = (OctTree)child;
            childTree.delete(pos);
            if (childTree.validChildren == 1) {
                Object onlyChild = childTree.children.values().stream().filter(Objects::nonNull).findFirst().get();
                this.children.put(childOctant, onlyChild);
            }
        }
    }

    @Override
    public class_2382 findNearest(class_2382 pos, int maxRange) {
        if (pos == null) {
            StrawgolemCommon.LOG.error("Tried to find nearest pos to null query - returning null");
            return null;
        }
        if (!this.boundary.isInBoundary(pos)) {
            StrawgolemCommon.LOG.error("Attempting to find nearest point outside of boundary: " + pos);
            return null;
        }
        OctBox rangeBoundary = new OctBox(pos.method_10263() - maxRange, pos.method_10264() - maxRange, pos.method_10260() - maxRange, pos.method_10263() + maxRange + 1, pos.method_10264() + maxRange + 1, pos.method_10260() + maxRange + 1);
        PriorityQueue<class_2382> pointQueue = new PriorityQueue<class_2382>(Comparator.comparingInt(o -> o.method_19455(pos)));
        this.rangeSearch(rangeBoundary, pointQueue);
        return (class_2382)pointQueue.poll();
    }

    private void rangeSearch(OctBox rangeBoundary, Queue<class_2382> result) {
        if (this.boundary.isSubsetOf(rangeBoundary)) {
            OctTree.buildQueue(result, this);
            return;
        }
        if (this.boundary.isDiscreteWith(rangeBoundary)) {
            return;
        }
        for (OctBox.Octant octant : OctBox.Octant.values()) {
            Object child = this.children.get((Object)octant);
            if (child instanceof class_2382) {
                class_2382 point = (class_2382)child;
                if (!rangeBoundary.isInBoundary(point)) continue;
                result.offer(point);
                continue;
            }
            if (child == null) continue;
            OctTree tree = (OctTree)child;
            tree.rangeSearch(rangeBoundary, result);
        }
    }

    @Override
    public Iterator<class_2382> iterator() {
        final ArrayDeque<class_2382> queue = new ArrayDeque<class_2382>();
        OctTree.buildQueue(queue, this);
        return new Iterator<class_2382>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public class_2382 next() {
                return (class_2382)queue.poll();
            }
        };
    }

    private static void buildQueue(Queue<class_2382> stack, OctTree current) {
        for (OctBox.Octant octant : OctBox.Octant.values()) {
            Object child = current.children.get((Object)octant);
            if (child instanceof class_2382) {
                class_2382 point = (class_2382)child;
                stack.offer(point);
                continue;
            }
            if (child == null) continue;
            OctTree tree = (OctTree)child;
            OctTree.buildQueue(stack, tree);
        }
    }

    private static class OctBox {
        private final class_2382 bottomCorner;
        private final class_2382 topCorner;
        private final class_2382 midPoint;

        private OctBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this(new class_2382(minX, minY, minZ), new class_2382(maxX, maxY, maxZ));
        }

        private OctBox(class_2382 bottomCorner, class_2382 topCorner) {
            if (topCorner.method_10263() < bottomCorner.method_10263() || topCorner.method_10264() < bottomCorner.method_10264() || topCorner.method_10260() < bottomCorner.method_10260()) {
                throw new IllegalArgumentException("Invalid OctTree boundaries");
            }
            this.bottomCorner = bottomCorner;
            this.topCorner = topCorner;
            this.midPoint = new class_2382(this.average(bottomCorner.method_10263(), topCorner.method_10263()), this.average(bottomCorner.method_10264(), topCorner.method_10264()), this.average(bottomCorner.method_10260(), topCorner.method_10260()));
        }

        private int average(int low, int high) {
            return low + (high - low >>> 1);
        }

        boolean isInBoundary(class_2382 point) {
            return this.bottomCorner.method_10263() <= point.method_10263() && this.bottomCorner.method_10264() <= point.method_10264() && this.bottomCorner.method_10260() <= point.method_10260() && this.topCorner.method_10263() > point.method_10263() && this.topCorner.method_10264() > point.method_10264() && this.topCorner.method_10260() > point.method_10260();
        }

        Octant getOctant(class_2382 point) {
            if (point.method_10264() >= this.midPoint.method_10264()) {
                if (point.method_10260() >= this.midPoint.method_10260()) {
                    if (point.method_10263() >= this.midPoint.method_10263()) {
                        return Octant.U_S_E;
                    }
                    return Octant.U_S_W;
                }
                if (point.method_10263() >= this.midPoint.method_10263()) {
                    return Octant.U_N_E;
                }
                return Octant.U_N_W;
            }
            if (point.method_10260() >= this.midPoint.method_10260()) {
                if (point.method_10263() >= this.midPoint.method_10263()) {
                    return Octant.D_S_E;
                }
                return Octant.D_S_W;
            }
            if (point.method_10263() >= this.midPoint.method_10263()) {
                return Octant.D_N_E;
            }
            return Octant.D_N_W;
        }

        boolean isSubsetOf(OctBox other) {
            return other.isInBoundary(this.bottomCorner) && other.isInBoundary(this.topCorner);
        }

        boolean isDiscreteWith(OctBox other) {
            return other.bottomCorner.method_10263() > this.topCorner.method_10263() || other.bottomCorner.method_10264() > this.topCorner.method_10264() || other.bottomCorner.method_10260() > this.topCorner.method_10260() || this.bottomCorner.method_10263() > other.topCorner.method_10263() || this.bottomCorner.method_10264() > other.topCorner.method_10264() || this.bottomCorner.method_10260() > other.topCorner.method_10260();
        }

        OctBox getOctantBox(Octant octant) {
            class_2382 bottomCorner;
            return new OctBox(bottomCorner, switch (octant) {
                case Octant.D_N_E -> {
                    bottomCorner = new class_2382(this.midPoint.method_10263(), this.bottomCorner.method_10264(), this.bottomCorner.method_10260());
                    yield new class_2382(this.topCorner.method_10263(), this.midPoint.method_10264(), this.midPoint.method_10260());
                }
                case Octant.D_N_W -> {
                    bottomCorner = this.bottomCorner;
                    yield this.midPoint;
                }
                case Octant.D_S_E -> {
                    bottomCorner = new class_2382(this.midPoint.method_10263(), this.bottomCorner.method_10264(), this.midPoint.method_10260());
                    yield new class_2382(this.topCorner.method_10263(), this.midPoint.method_10264(), this.topCorner.method_10260());
                }
                case Octant.D_S_W -> {
                    bottomCorner = new class_2382(this.bottomCorner.method_10263(), this.bottomCorner.method_10264(), this.midPoint.method_10260());
                    yield new class_2382(this.midPoint.method_10263(), this.midPoint.method_10264(), this.topCorner.method_10260());
                }
                case Octant.U_N_E -> {
                    bottomCorner = new class_2382(this.midPoint.method_10263(), this.midPoint.method_10264(), this.bottomCorner.method_10260());
                    yield new class_2382(this.topCorner.method_10263(), this.topCorner.method_10264(), this.midPoint.method_10260());
                }
                case Octant.U_N_W -> {
                    bottomCorner = new class_2382(this.bottomCorner.method_10263(), this.midPoint.method_10264(), this.bottomCorner.method_10260());
                    yield new class_2382(this.midPoint.method_10263(), this.topCorner.method_10264(), this.midPoint.method_10260());
                }
                case Octant.U_S_E -> {
                    bottomCorner = this.midPoint;
                    yield this.topCorner;
                }
                default -> {
                    bottomCorner = new class_2382(this.bottomCorner.method_10263(), this.midPoint.method_10264(), this.midPoint.method_10260());
                    yield new class_2382(this.midPoint.method_10263(), this.topCorner.method_10264(), this.topCorner.method_10260());
                }
            });
        }

        static enum Octant {
            D_S_E,
            D_S_W,
            D_N_E,
            D_N_W,
            U_S_E,
            U_S_W,
            U_N_E,
            U_N_W;

        }
    }
}

