/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.util.io;

import com.t2pellet.strawgolem.util.io.Config;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ConfigHelper {
    public static ConfigHelper INSTANCE = new ConfigHelper();
    private final Map<Class<? extends Config>, Config> configMap = new HashMap<Class<? extends Config>, Config>();

    private ConfigHelper() {
    }

    public <T extends Config> void register(Supplier<T> configSupplier) throws IOException, IllegalAccessException {
        Config config = (Config)configSupplier.get();
        config.load();
        this.configMap.put(config.getClass(), config);
    }

    public <T extends Config> void save(Class<T> configClass) throws IOException, IllegalAccessException {
        this.configMap.get(configClass).save();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Section {
        public String value();

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        public static @interface Comment {
            public String value();
        }
    }
}

