/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.platform;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.network.Packet;
import com.t2pellet.strawgolem.platform.Services;
import com.t2pellet.strawgolem.platform.services.IPacketHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricPacketHandler
implements IPacketHandler {
    private final Map<Class<? extends Packet<?>>, class_2960> idMap = new HashMap();

    @Override
    public <T extends Packet<T>> void registerPacketID(class_2960 id, Class<T> packetClass) {
        this.idMap.put(packetClass, id);
    }

    @Override
    public <T extends Packet<T>> void registerClientPacket(class_2960 id, Class<T> packetClass) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this._registerClientPacket(id, packetClass);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private <T extends Packet<T>> void _registerClientPacket(class_2960 id, Class<T> packetClass) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, handler, buf, responseSender) -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(class_2540.class).newInstance(buf);
                Services.SIDE.scheduleClient(packet.getExecutor());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                StrawgolemCommon.LOG.error("Error: Failed to instantiate packet - " + id);
            }
        });
    }

    @Override
    public <T extends Packet<T>> void registerServerPacket(class_2960 id, Class<T> packetClass) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (minecraftServer, serverPlayer, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(class_2540.class).newInstance(packetByteBuf);
                Services.SIDE.scheduleServer(packet.getExecutor());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                StrawgolemCommon.LOG.error("Error: Failed to instantiate packet - " + id);
            }
        });
    }

    @Override
    public <T extends Packet<T>> void sendToServer(Packet<T> packet) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        ClientPlayNetworking.send((class_2960)this.idMap.get(packet.getClass()), (class_2540)data);
    }

    @Override
    public <T extends Packet<T>> void sendTo(Packet<T> packet, class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.idMap.get(packet.getClass()), (class_2540)data);
    }

    @Override
    public <T extends Packet<T>> void sendTo(Packet<T> packet, class_3222 ... players) {
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2960 id = this.idMap.get(packet.getClass());
        packet.encode(data);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)id, (class_2540)data);
        }
    }

    @Override
    public <T extends Packet<T>> void sendInRange(Packet<T> packet, class_1297 e, float range) {
        this.sendInArea(packet, e.method_37908(), e.method_24515(), range);
    }

    @Override
    public <T extends Packet<T>> void sendInArea(Packet<T> packet, class_1937 world, class_2338 pos, float range) {
        class_238 box = new class_238(pos);
        List nearbyPlayers = world.method_8390(class_3222.class, box.method_1014((double)range), p -> true);
        this.sendTo(packet, nearbyPlayers.toArray(new class_3222[0]));
    }
}

