/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.entity.capability;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.entity.capability.Capability;
import com.t2pellet.strawgolem.entity.capability.CapabilityHandler;
import com.t2pellet.strawgolem.entity.capability.CapabilityManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class CapabilityManagerImpl
implements CapabilityManager {
    private final Map<Class<? extends Capability>, Capability> map = new HashMap<Class<? extends Capability>, Capability>();

    CapabilityManagerImpl() {
    }

    @Override
    public <T extends Capability> void addCapability(Class<T> capabilityClass) {
        Capability capability = (Capability)CapabilityHandler.INSTANCE.get(capabilityClass).orElseThrow(() -> new InstantiationError("Failed to instantiate capability for class: " + capabilityClass.getSimpleName()));
        this.map.put(capabilityClass, capability);
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T)this.map.get(capabilityClass);
    }

    @Override
    public <T extends Capability> void setCapability(Class<T> capabilityClass, T capability) {
        this.map.put(capabilityClass, capability);
    }

    @Override
    public class_2520 writeTag() {
        class_2499 tag = new class_2499();
        this.map.forEach((aClass, capability) -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("className", aClass.getName());
            compoundTag.method_10566("capability", capability.writeTag());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    @Override
    public void readTag(class_2520 tag) {
        class_2499 listTag = (class_2499)tag;
        listTag.forEach(tagInList -> {
            class_2487 compoundTag = (class_2487)tagInList;
            try {
                Class<?> aClass = Class.forName(compoundTag.method_10558("className"));
                Object capability = this.fromTag(aClass, compoundTag.method_10580("capability"));
                this.map.put((Class<? extends Capability>)aClass, (Capability)capability);
            }
            catch (ClassNotFoundException e) {
                StrawgolemCommon.LOG.error("Failed to instantiate capability from NBT", (Throwable)e);
            }
        });
    }

    private <T extends Capability> T fromTag(Class<T> aClass, class_2520 tag) {
        Capability capability = (Capability)CapabilityHandler.INSTANCE.get(aClass).orElseThrow(() -> new InstantiationError("Failed to instantiate capability for class: " + aClass.getSimpleName()));
        capability.readTag(tag);
        return (T)capability;
    }
}

