/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.entity.ai;

import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.crop.CropRegistry;
import com.t2pellet.strawgolem.crop.WorldCrops;
import com.t2pellet.strawgolem.entity.StrawGolem;
import com.t2pellet.strawgolem.entity.ai.GolemLookAtPlayerGoal;
import com.t2pellet.strawgolem.network.HoldingPacket;
import com.t2pellet.strawgolem.platform.Services;
import com.t2pellet.strawgolem.registry.CommonRegistry;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1367;
import net.minecraft.class_1747;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2511;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;

public class GolemHarvestGoal
extends class_1367 {
    private final StrawGolem strawgolem;

    public GolemHarvestGoal(StrawGolem strawgolem) {
        super((class_1314)strawgolem, 0.7, StrawgolemConfig.Harvest.getSearchRange(), StrawgolemConfig.Harvest.getSearchRange());
        this.strawgolem = strawgolem;
    }

    public boolean method_6264() {
        if (this.field_6518 > 0) {
            --this.field_6518;
            return false;
        }
        if (this.strawgolem.isHandEmpty() && !this.strawgolem.getHunger().isHungry()) {
            class_2338 harvestPos;
            class_2338 class_23382 = harvestPos = this.strawgolem.harvestPos != null ? this.strawgolem.harvestPos : WorldCrops.of(this.strawgolem.field_6002).getNearestCrop(this.strawgolem.method_24515(), StrawgolemConfig.Harvest.getSearchRange());
            if (harvestPos != null) {
                if (CropRegistry.INSTANCE.isGrownCrop((class_4538)this.strawgolem.field_6002, harvestPos)) {
                    if (this.strawgolem.canReachBlock((class_4538)this.strawgolem.field_6002, harvestPos)) {
                        this.field_6512 = harvestPos;
                        return true;
                    }
                    if (harvestPos == this.strawgolem.harvestPos) {
                        WorldCrops.of(this.strawgolem.field_6002).addCrop(harvestPos);
                    }
                } else {
                    WorldCrops.of(this.strawgolem.field_6002).removeCrop(harvestPos);
                }
            }
        }
        this.strawgolem.harvestPos = null;
        return false;
    }

    public void method_6269() {
        this.field_6518 = this.method_6293(this.field_6516);
        WorldCrops.of(this.strawgolem.field_6002).removeCrop(this.field_6512);
        this.strawgolem.harvestPos = this.field_6512;
        this.strawgolem.method_5783(CommonRegistry.Sounds.GOLEM_INTERESTED, 1.0f, 1.0f);
    }

    protected int method_6293(class_1314 mob) {
        return 120 + mob.method_6051().method_43048(121);
    }

    public boolean method_6266() {
        return this.strawgolem.method_5854() == null && !this.strawgolem.getHunger().isHungry() && super.method_6266();
    }

    public void method_6270() {
        if (CropRegistry.INSTANCE.isGrownCrop((class_4538)this.strawgolem.field_6002, this.field_6512)) {
            WorldCrops.of(this.strawgolem.field_6002).addCrop(this.field_6512);
        }
        this.strawgolem.harvestPos = null;
    }

    public void method_6268() {
        if (!this.strawgolem.isRunningGoal(GolemLookAtPlayerGoal.class)) {
            this.strawgolem.method_5988().method_19615(class_243.method_24953((class_2382)this.field_6512));
        }
        double targetDistance = this.method_6291();
        class_2248 blockPosType = this.strawgolem.field_6002.method_8320(this.field_6512).method_26204();
        if (blockPosType instanceof class_2511) {
            targetDistance += 0.2;
        }
        if (blockPosType instanceof class_2261) {
            targetDistance += 0.55;
        }
        if (!this.field_6512.method_19769((class_2374)this.field_6516.method_19538(), targetDistance)) {
            ++this.field_6517;
            if (this.method_6294()) {
                this.field_6516.method_5942().method_6337((double)this.field_6512.method_10263() + 0.5, (double)this.field_6512.method_10264() + 1.0, (double)this.field_6512.method_10260() + 0.5, this.field_6514);
            }
        } else {
            --this.field_6517;
            this.harvestCrop();
        }
    }

    protected boolean method_6296(class_4538 worldIn, class_2338 pos) {
        return CropRegistry.INSTANCE.isGrownCrop(worldIn, pos) && this.strawgolem.isHandEmpty();
    }

    private void harvestCrop() {
        class_3218 worldIn = (class_3218)this.strawgolem.field_6002;
        class_2338 pos = this.field_6512;
        if (this.method_6296((class_4538)worldIn, pos)) {
            worldIn.method_8396(null, pos, class_3417.field_17610, class_3419.field_15245, 1.0f, 1.0f);
            if (StrawgolemConfig.Delivery.isDeliveryEnabled()) {
                this.pickupCrop(worldIn, pos);
            }
            if (StrawgolemConfig.Harvest.isReplantEnabled()) {
                this.replantCrop(worldIn, pos);
            } else {
                worldIn.method_8501(pos, class_2246.field_10124.method_9564());
            }
        }
    }

    private void pickupCrop(class_3218 worldIn, class_2338 pos) {
        List<class_1799> drops = CropRegistry.INSTANCE.handleHarvest(worldIn, this.strawgolem, pos);
        for (class_1799 drop : drops) {
            this.strawgolem.getInventory().method_5491(drop);
            if (drop.method_7909() == class_1802.field_8635) {
                this.strawgolem.method_6092(new class_1293(class_1294.field_5899, 10, 1));
                continue;
            }
            if (!(drop.method_7909() instanceof class_1747) || drop.method_7909() instanceof class_1798) continue;
            this.strawgolem.method_5783(CommonRegistry.Sounds.GOLEM_STRAINED, 1.0f, 1.0f);
            break;
        }
        Services.PACKETS.sendInRange(new HoldingPacket(this.strawgolem), (class_1297)this.strawgolem, 25.0f);
    }

    private void replantCrop(class_3218 worldIn, class_2338 pos) {
        CropRegistry.INSTANCE.handleReplant((class_1937)worldIn, pos);
    }
}

