/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.entity;

import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.crop.CropRegistry;
import com.t2pellet.strawgolem.crop.WorldCrops;
import com.t2pellet.strawgolem.entity.StrawngGolem;
import com.t2pellet.strawgolem.entity.ai.GolemDeliverGoal;
import com.t2pellet.strawgolem.entity.ai.GolemFleeGoal;
import com.t2pellet.strawgolem.entity.ai.GolemHarvestGoal;
import com.t2pellet.strawgolem.entity.ai.GolemLookAtPlayerGoal;
import com.t2pellet.strawgolem.entity.ai.GolemLookRandomlyGoal;
import com.t2pellet.strawgolem.entity.ai.GolemPoutGoal;
import com.t2pellet.strawgolem.entity.ai.GolemTemptGoal;
import com.t2pellet.strawgolem.entity.ai.GolemTetherGoal;
import com.t2pellet.strawgolem.entity.ai.GolemWanderGoal;
import com.t2pellet.strawgolem.entity.capability.CapabilityManager;
import com.t2pellet.strawgolem.entity.capability.accessory.Accessory;
import com.t2pellet.strawgolem.entity.capability.hunger.Hunger;
import com.t2pellet.strawgolem.entity.capability.hunger.IHasHunger;
import com.t2pellet.strawgolem.entity.capability.lifespan.Lifespan;
import com.t2pellet.strawgolem.entity.capability.memory.Memory;
import com.t2pellet.strawgolem.entity.capability.tether.IHasTether;
import com.t2pellet.strawgolem.entity.capability.tether.Tether;
import com.t2pellet.strawgolem.events.WorldInteractHandler;
import com.t2pellet.strawgolem.network.CapabilityPacket;
import com.t2pellet.strawgolem.platform.Services;
import com.t2pellet.strawgolem.registry.CommonRegistry;
import java.util.Arrays;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1427;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2511;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class StrawGolem
extends class_1427
implements IHasHunger,
IHasTether {
    private static final class_2960 ResourceLocation = new class_2960("strawgolem", "strawgolem");
    private static final int maxLifespan = StrawgolemConfig.Health.getLifespan() + StrawgolemConfig.Health.getWheatTicks();
    private static final int maxHunger = StrawgolemConfig.Health.getHunger() + StrawgolemConfig.Health.getFoodTicks();
    private static final float maxHealth = 8.0f;
    private static final float moveSpeed = 0.2f;
    private final CapabilityManager capabilities = CapabilityManager.newInstance();
    private final class_1277 inventory;
    private boolean tempted;
    private boolean isNew;
    public class_2338 harvestPos;

    public static class_5132.class_5133 createMob() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public StrawGolem(class_1299<? extends StrawGolem> type, class_1937 levelIn) {
        super(type, levelIn);
        this.capabilities.addCapability(Lifespan.class);
        this.capabilities.addCapability(Memory.class);
        this.capabilities.addCapability(Tether.class);
        this.capabilities.addCapability(Hunger.class);
        this.capabilities.addCapability(Accessory.class);
        this.inventory = new class_1277(1);
        this.harvestPos = null;
        this.tempted = false;
        this.isNew = true;
    }

    protected void method_5959() {
        int priority = 0;
        this.field_6201.method_6277(++priority, (class_1352)new GolemFleeGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemTemptGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemPoutGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemHarvestGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemDeliverGoal(this));
        if (StrawgolemConfig.Tether.isTetherEnabled()) {
            this.field_6201.method_6277(++priority, new GolemTetherGoal<StrawGolem>(this, 0.8));
        }
        this.field_6201.method_6277(++priority, (class_1352)new GolemWanderGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemLookAtPlayerGoal(this, 4.0f));
        this.field_6201.method_6277(++priority, (class_1352)new GolemLookRandomlyGoal(this));
    }

    @SafeVarargs
    public final boolean isRunningGoal(Class<? extends class_1352> ... clazzes) {
        return this.field_6201.method_19048().anyMatch(goal -> Arrays.stream(clazzes).anyMatch(clazz -> clazz.isInstance(goal.method_19058())));
    }

    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.method_8608()) {
            if (this.isNew) {
                this.profileCrops();
                this.isNew = false;
            }
            if (StrawgolemConfig.Health.getLifespan() > 0) {
                int lifeTicks = 1;
                int hungerTicks = 1;
                if (this.holdingFullBlock() && StrawgolemConfig.Health.isHeavyPenalty()) {
                    ++lifeTicks;
                    ++hungerTicks;
                }
                if (this.method_5816() && StrawgolemConfig.Health.isWaterPenalty()) {
                    ++lifeTicks;
                } else if (!this.getAccessory().hasHat() && this.method_5721() && StrawgolemConfig.Health.isRainPenalty()) {
                    ++lifeTicks;
                }
                this.getLifespan().shrink(lifeTicks);
                this.getHunger().shrink(hungerTicks);
                float curMaxHealth = 8.0f * Math.max(0.25f, Math.min(1.25f, this.getLifespan().getPercentage()));
                float curMoveSpeed = 0.2f * Math.max(0.5f, Math.min(1.25f, this.getHunger().getPercentage()));
                this.method_5996(class_5134.field_23716).method_6192((double)curMaxHealth);
                this.method_5996(class_5134.field_23719).method_6192((double)curMoveSpeed);
                if (this.getLifespan().isOver()) {
                    this.method_5768();
                }
            }
            if (this.field_5974.method_43048(40) == 0) {
                Services.PACKETS.sendInRange(new CapabilityPacket(this), (class_1297)this, 25.0f);
            }
        }
        if (StrawgolemConfig.Health.getLifespan() > 0 && this.getLifespan().get() * 4 < StrawgolemConfig.Health.getLifespan() && this.field_5974.method_43048(240) == 0) {
            this.spawnParticle((class_2394)CommonRegistry.Particles.getFlyParticle());
        }
    }

    public boolean isInCold() {
        return ((class_1959)this.field_6002.method_23753(this.method_24515()).comp_349()).method_8712() < 0.15f;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 heldItem = player.method_5998(hand).method_7909();
        if (heldItem == class_1802.field_8861) {
            int newLifespan = this.getLifespan().get() + StrawgolemConfig.Health.getWheatTicks();
            if (this.method_6032() == this.method_6063() && newLifespan > maxLifespan) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                this.method_6025(0.5f);
                if (StrawgolemConfig.Health.getLifespan() > -1 && newLifespan < maxLifespan) {
                    this.getLifespan().set(newLifespan);
                }
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                Services.PACKETS.sendInRange(new CapabilityPacket(this), (class_1297)this, 25.0f);
                this.method_5783(CommonRegistry.Sounds.GOLEM_HEAL, 1.0f, 1.0f);
                this.method_5783(class_3417.field_14573, 1.0f, 1.0f);
            }
            this.spawnParticle((class_2394)class_2398.field_11201);
            return class_1269.field_21466;
        }
        if (heldItem == CommonRegistry.Items.getStrawHat()) {
            if (this.getAccessory().hasHat()) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                this.getAccessory().setHasHat(true);
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                Services.PACKETS.sendInRange(new CapabilityPacket(this), (class_1297)this, 25.0f);
                this.method_5783(CommonRegistry.Sounds.GOLEM_INTERESTED, 1.0f, 1.0f);
                this.method_5783(class_3417.field_14573, 1.0f, 1.0f);
            }
            return class_1269.field_21466;
        }
        if (heldItem == StrawgolemConfig.Health.getFoodItem()) {
            int newHunger = this.getHunger().get() + StrawgolemConfig.Health.getFoodTicks();
            if (newHunger > maxHunger) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                if (StrawgolemConfig.Health.getHunger() > -1 && newHunger < maxHunger) {
                    this.getHunger().set(newHunger);
                }
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                Services.PACKETS.sendInRange(new CapabilityPacket(this), (class_1297)this, 25.0f);
                this.method_5783(CommonRegistry.Sounds.GOLEM_HEAL, 1.0f, 1.0f);
            }
            this.spawnParticle((class_2394)class_2398.field_11211);
            return class_1269.field_21466;
        }
        if (heldItem == class_1802.field_8162) {
            if (hand == class_1268.field_5810 || !player.method_5715()) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                WorldInteractHandler.addMapping(player.method_5667(), this.method_5628());
                class_5250 message = class_2561.method_43469((String)"strawgolem.order", (Object[])new Object[]{this.method_5476().getString()});
                player.method_7353((class_2561)message, true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private void spawnParticle(class_2394 type) {
        class_243 deltaMovement = this.method_18798();
        this.field_6002.method_8406(type, this.method_23317() + this.field_5974.method_43058() - 0.5, this.method_23318() + 0.4, this.method_23321() + this.field_5974.method_43058() - 0.5, deltaMovement.field_1352, deltaMovement.field_1351, deltaMovement.field_1350);
    }

    public void method_5800(class_3218 world, class_1538 bolt) {
        if (this.field_5974.method_43048(10) == 0 && !this.field_6002.method_8608()) {
            StrawngGolem strawngGolem = (StrawngGolem)CommonRegistry.Entities.getStrawngGolemType().method_5883(this.field_6002);
            if (this.method_16914()) {
                strawngGolem.method_5665(this.method_5797());
            }
            strawngGolem.method_33574(this.method_19538());
            strawngGolem.method_5847(this.field_6241);
            strawngGolem.method_36457(this.method_36455());
            strawngGolem.method_5814(this.field_6038, this.field_5971, this.field_5989);
            this.method_5650(class_1297.class_5529.field_26999);
            if (this.field_6002.method_8320(this.method_24515()).method_26204() == class_2246.field_10036) {
                this.field_6002.method_8501(this.method_24515(), class_2246.field_10124.method_9564());
            }
            this.field_6002.method_8649((class_1297)strawngGolem);
        }
    }

    protected void method_6074(class_1282 source, float $$1) {
        super.method_6074(source, $$1);
        if (source.method_5526() instanceof class_1657) {
            this.profileCrops();
        }
    }

    private void profileCrops() {
        int maxRange = StrawgolemConfig.Harvest.getSearchRange();
        for (int i = -maxRange; i < maxRange; ++i) {
            for (int j = -maxRange; j < maxRange; ++j) {
                for (int k = -maxRange; k < maxRange; ++k) {
                    class_2338 currPos = this.method_24515().method_10069(i, j, k);
                    if (!CropRegistry.INSTANCE.isGrownCrop((class_4538)this.field_6002, currPos)) continue;
                    WorldCrops.of(this.field_6002).addCrop(currPos);
                }
            }
        }
    }

    public boolean method_5974(double $$0) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == class_1282.field_16992) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5757() {
        if (this.field_5960) {
            return false;
        }
        float scaledWidth = this.method_18377((class_4050)class_4050.field_18076).field_18067 * 0.8f;
        class_238 headBounds = class_238.method_30048((class_243)this.method_33571(), (double)scaledWidth, (double)1.0E-6, (double)scaledWidth);
        return class_2338.method_29715((class_238)headBounds).anyMatch(pos -> {
            class_2680 state = this.field_6002.method_8320(pos);
            return !state.method_26215() && state.method_26228((class_1922)this.field_6002, pos) && class_259.method_1074((class_265)state.method_26220((class_1922)this.field_6002, pos).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (class_265)class_259.method_1078((class_238)headBounds), (class_247)class_247.field_16896) && !(state.method_26204() instanceof class_2511);
        });
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        if (!this.field_6002.method_8608()) {
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), this.inventory.method_5438(0).method_7972()));
        }
    }

    public boolean canReachBlock(class_4538 levelIn, class_2338 pos) {
        class_243 blockPos;
        if (levelIn != this.field_6002) {
            return false;
        }
        if ((double)pos.method_19455((class_2382)pos) > 1.27 * (double)StrawgolemConfig.Harvest.getSearchRange()) {
            return false;
        }
        class_243 eyePos = class_243.method_24953((class_2382)this.method_24515()).method_1031(0.0, 0.5, 0.0);
        class_3965 result = this.field_6002.method_17742(new class_3959(eyePos, blockPos = class_243.method_24953((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return result.method_17783() == class_239.class_240.field_1333 || result.method_17777().method_19771((class_2382)pos, 1.0);
    }

    public boolean isHarvesting() {
        return this.harvestPos != null;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public boolean isHandEmpty() {
        return this.method_6047().method_7960();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.inventory.method_5438(0);
        }
        return class_1799.field_8037;
    }

    public boolean holdingFullBlock() {
        class_1799 item = this.method_6047();
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        return blockItem != class_1802.field_8162 && blockItem.method_7711().method_9564().method_26225() && blockItem.method_7711().method_8389() == blockItem;
    }

    public CapabilityManager getCapabilityManager() {
        return this.capabilities;
    }

    public Lifespan getLifespan() {
        return this.capabilities.getCapability(Lifespan.class);
    }

    public Memory getMemory() {
        return this.capabilities.getCapability(Memory.class);
    }

    @Override
    public Tether getTether() {
        return this.capabilities.getCapability(Tether.class);
    }

    @Override
    public Hunger getHunger() {
        return this.capabilities.getCapability(Hunger.class);
    }

    public Accessory getAccessory() {
        return this.capabilities.getCapability(Accessory.class);
    }

    @Override
    public void setTempted(boolean tempted) {
        this.tempted = tempted;
    }

    @Override
    public boolean isTempted() {
        return this.tempted;
    }

    public void method_5814(double posX, double posY, double posZ) {
        if (this.method_5854() instanceof class_1439 || this.method_5854() instanceof StrawngGolem) {
            class_1427 golemEntity = (class_1427)this.method_5854();
            double lookX = golemEntity.method_5720().field_1352;
            double lookZ = golemEntity.method_5720().field_1350;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.method_5814(posX + 1.71 * (lookX /= magnitude), posY - 0.55, posZ + 1.71 * (lookZ /= magnitude));
        } else {
            super.method_5814(posX, posY, posZ);
        }
    }

    public void method_5848() {
        super.method_5848();
        if (this.method_5854() instanceof class_1439 || this.method_5854() instanceof StrawngGolem) {
            class_1309 ridingEntity = (class_1309)this.method_5854();
            double lookX = ridingEntity.method_5720().field_1352;
            double lookZ = ridingEntity.method_5720().field_1350;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.method_5814(this.method_23317() + (lookX /= magnitude), this.method_23318(), this.method_23321() + (lookZ /= magnitude));
        }
    }

    public void method_5652(class_2487 tag) {
        tag.method_10566("inventory", (class_2520)this.inventory.method_7660());
        tag.method_10566("capabilities", this.capabilities.writeTag());
        if (this.harvestPos != null) {
            tag.method_10566("harvestPos", (class_2520)class_2512.method_10692((class_2338)this.harvestPos));
        }
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        if (tag.method_10545("inventory")) {
            this.inventory.method_7659((class_2499)tag.method_10580("inventory"));
        }
        if (tag.method_10545("capabilities")) {
            this.capabilities.readTag(tag.method_10580("capabilities"));
        }
        if (tag.method_10545("harvestPos")) {
            this.harvestPos = class_2512.method_10691((class_2487)((class_2487)tag.method_10580("harvestPos")));
        }
        super.method_5749(tag);
    }

    protected class_3414 method_5994() {
        if (StrawgolemConfig.Miscellaneous.isSoundsEnabled()) {
            if (this.field_6201.method_19048().anyMatch(goal -> goal.method_19058() instanceof GolemFleeGoal || goal.method_19058() instanceof GolemTetherGoal)) {
                return CommonRegistry.Sounds.GOLEM_SCARED;
            }
            if (this.holdingFullBlock() || this.getHunger().isHungry()) {
                return CommonRegistry.Sounds.GOLEM_STRAINED;
            }
            return CommonRegistry.Sounds.GOLEM_AMBIENT;
        }
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return StrawgolemConfig.Miscellaneous.isSoundsEnabled() ? CommonRegistry.Sounds.GOLEM_HURT : null;
    }

    protected class_3414 method_6002() {
        return StrawgolemConfig.Miscellaneous.isSoundsEnabled() ? CommonRegistry.Sounds.GOLEM_DEATH : null;
    }

    public int method_5970() {
        return this.holdingFullBlock() ? 60 : 120;
    }

    protected class_2960 method_5991() {
        return ResourceLocation;
    }
}

