/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.crop;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.crop.CropRegistry;
import com.t2pellet.strawgolem.crop.WorldCrops;
import com.t2pellet.strawgolem.util.struct.PosTree;
import java.util.Iterator;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_4538;

class WorldCropsImpl
extends class_18
implements WorldCrops {
    private static final String TAG_VERSION = "version";
    private static final String TAG_POS = "pos";
    private static final int VERSION = 1;
    private final class_1937 level;
    private PosTree tree = PosTree.create();

    WorldCropsImpl(class_1937 level) {
        this.level = level;
    }

    static WorldCropsImpl load(class_1937 level, class_2487 tag) {
        StrawgolemCommon.LOG.info("Loading strawgolem save data");
        WorldCropsImpl crops = new WorldCropsImpl(level);
        if (!tag.method_10545(TAG_VERSION) || tag.method_10550(TAG_VERSION) != 1) {
            return crops;
        }
        class_2499 positions = tag.method_10554(TAG_POS, 10);
        for (class_2520 position : positions) {
            class_2338 pos = class_2512.method_10691((class_2487)((class_2487)position));
            if (!CropRegistry.INSTANCE.isGrownCrop((class_4538)level, pos)) continue;
            crops.addCrop(pos);
        }
        return crops;
    }

    public class_2487 method_75(class_2487 tag) {
        StrawgolemCommon.LOG.debug("Saving strawgolem save data");
        class_2499 positionsTag = new class_2499();
        Iterator<class_2338> cropIterator = this.getCrops();
        while (cropIterator.hasNext()) {
            class_2338 pos = cropIterator.next();
            if (!this.level.method_8393(pos.method_10263(), pos.method_10260()) || !CropRegistry.INSTANCE.isGrownCrop((class_4538)this.level, pos)) continue;
            positionsTag.add((Object)class_2512.method_10692((class_2338)pos));
        }
        tag.method_10566(TAG_POS, (class_2520)positionsTag);
        tag.method_10569(TAG_VERSION, 1);
        return tag;
    }

    @Override
    public void reset() {
        this.tree = PosTree.create();
        this.method_80();
    }

    @Override
    public void addCrop(class_2338 pos) {
        this.tree.insert((class_2382)pos);
        this.method_80();
    }

    @Override
    public void removeCrop(class_2338 pos) {
        this.tree.delete((class_2382)pos);
        this.method_80();
    }

    @Override
    public class_2338 getNearestCrop(class_2338 pos, int maxRange) {
        class_2382 result = this.tree.findNearest((class_2382)pos, maxRange);
        return result == null ? null : new class_2338(result);
    }

    @Override
    public Iterator<class_2338> getCrops() {
        final Iterator<class_2382> iterator = this.tree.iterator();
        return new Iterator<class_2338>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public class_2338 next() {
                return new class_2338((class_2382)iterator.next());
            }
        };
    }
}

