/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.crop;

import com.mojang.authlib.GameProfile;
import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.crop.CropRegistryImpl;
import com.t2pellet.strawgolem.entity.StrawGolem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public interface CropRegistry {
    public static final CropRegistry INSTANCE = new CropRegistryImpl();

    public <T extends class_2680> void register(class_2248 var1, IHarvestChecker<T> var2, IHarvestLogic<T> var3, IReplantLogic<T> var4);

    public <T extends class_2586> void register(class_2591<T> var1, IHarvestChecker<T> var2, IHarvestLogic<T> var3, IReplantLogic<T> var4);

    public boolean isGrownCrop(class_4538 var1, class_2338 var2);

    public <T extends class_2680> boolean isGrownCrop(T var1);

    public <T extends class_2586> boolean isGrownCrop(T var1);

    public void handleReplant(class_1937 var1, class_2338 var2);

    public List<class_1799> handleHarvest(class_3218 var1, StrawGolem var2, class_2338 var3);

    private static boolean isCropDrop(class_1799 drop) {
        return !(drop.method_7909() instanceof class_1747) || drop.method_7976() == class_1839.field_8950 || drop.method_7909() == class_1802.field_8790;
    }

    public static interface IHarvestLogic<T> {
        public static final IHarvestLogic<class_2680> DEFAULT = (worldIn, golem, pos, state) -> {
            List drops = class_2248.method_9562((class_2680)state, (class_3218)worldIn, (class_2338)pos, (class_2586)worldIn.method_8321(pos));
            return drops.stream().filter(CropRegistry::isCropDrop).collect(Collectors.toList());
        };
        public static final IHarvestLogic<class_2680> RIGHT_CLICK = (worldIn, golem, pos, state) -> {
            GameProfile fakeProfile = new GameProfile(UUID.randomUUID(), golem.method_5820());
            class_3222 fake = new class_3222(worldIn.method_8503(), worldIn, fakeProfile, null);
            fake.method_5814(golem.method_23317(), golem.method_23318(), golem.method_23321());
            class_3965 result = new class_3965(golem.method_19538(), golem.method_5735().method_10153(), pos, false);
            try {
                state.method_26174((class_1937)worldIn, (class_1657)fake, class_1268.field_5808, result);
                List itemList = worldIn.method_8390(class_1542.class, new class_238(pos).method_1014(2.5), e -> true);
                ArrayList<class_1799> itemStackList = new ArrayList<class_1799>();
                for (class_1542 itemEntity : itemList) {
                    itemStackList.add(itemEntity.method_6983());
                    itemEntity.method_5650(class_1297.class_5529.field_26999);
                }
                ArrayList<class_1799> arrayList = itemStackList;
                return arrayList;
            }
            catch (NullPointerException ex) {
                StrawgolemCommon.LOG.error("Golem could not harvest block at position: {}", (Object)pos);
            }
            finally {
                fake.method_5650(class_1297.class_5529.field_26999);
            }
            return null;
        };

        public List<class_1799> doHarvest(class_3218 var1, StrawGolem var2, class_2338 var3, T var4);
    }

    public static interface IReplantLogic<T> {
        public static IReplantLogic<class_2680> getDefault(class_2758 property) {
            return IReplantLogic.getDefault(property, 0);
        }

        public static IReplantLogic<class_2680> getDefault(class_2758 property, int replantValue) {
            return (level, pos, input) -> level.method_8501(pos, (class_2680)input.method_26204().method_9564().method_11657((class_2769)property, (Comparable)Integer.valueOf(replantValue)));
        }

        public void doReplant(class_1937 var1, class_2338 var2, T var3);
    }

    public static interface IHarvestChecker<T> {
        public static IHarvestChecker<class_2680> getDefault(class_2758 property) {
            return IHarvestChecker.getDefault(property, (Integer)Collections.max(property.method_11898()));
        }

        public static IHarvestChecker<class_2680> getDefault(class_2758 property, int harvestValue) {
            return input -> ((Integer)input.method_11654((class_2769)property)).equals(harvestValue);
        }

        public boolean isMature(T var1);
    }
}

