/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.client.compat;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.util.io.ConfigHelper;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringListBuilder;
import net.minecraft.class_2561;

public class ClothConfigCompat
implements ModMenuApi {
    public ClothConfigCompat() {
        StrawgolemCommon.LOG.info("Registering cloth config compat");
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            try {
                return ClothConfigCompat.createConfigBuilder().build();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static ConfigBuilder createConfigBuilder() throws IllegalAccessException {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43471((String)"title.strawgolem.config"));
        for (Class<?> declaredClass : StrawgolemConfig.class.getDeclaredClasses()) {
            String categoryName = declaredClass.getSimpleName();
            ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)categoryName));
            ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
            for (Field declaredField : declaredClass.getDeclaredFields()) {
                StringFieldBuilder fieldBuilder;
                declaredField.setAccessible(true);
                ConfigHelper.Section.Comment comment = null;
                if (declaredField.isAnnotationPresent(ConfigHelper.Section.Comment.class)) {
                    comment = declaredField.getAnnotation(ConfigHelper.Section.Comment.class);
                }
                if (String.class.isAssignableFrom(declaredField.getType())) {
                    fieldBuilder = entryBuilder.startStrField((class_2561)class_2561.method_43470((String)declaredField.getName()), (String)declaredField.get(null)).setDefaultValue((String)declaredField.get(null)).setSaveConsumer(s -> ClothConfigCompat.setField(declaredField, s));
                    if (comment != null) {
                        fieldBuilder.setTooltip(new class_2561[]{class_2561.method_43470((String)comment.value())});
                    }
                    category.addEntry((AbstractConfigListEntry)fieldBuilder.build());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(declaredField.getType())) {
                    fieldBuilder = entryBuilder.startIntField((class_2561)class_2561.method_43470((String)declaredField.getName()), ((Integer)declaredField.get(null)).intValue()).setDefaultValue(((Integer)declaredField.get(null)).intValue()).setSaveConsumer(i -> ClothConfigCompat.setField(declaredField, i));
                    if (comment != null) {
                        fieldBuilder.setTooltip(new class_2561[]{class_2561.method_43470((String)comment.value())});
                    }
                    category.addEntry((AbstractConfigListEntry)fieldBuilder.build());
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(declaredField.getType())) {
                    BooleanToggleBuilder toggleBuilder = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)declaredField.getName()), ((Boolean)declaredField.get(null)).booleanValue()).setDefaultValue(((Boolean)declaredField.get(null)).booleanValue()).setSaveConsumer(b -> ClothConfigCompat.setField(declaredField, b));
                    if (comment != null) {
                        toggleBuilder.setTooltip(new class_2561[]{class_2561.method_43470((String)comment.value())});
                    }
                    category.addEntry((AbstractConfigListEntry)toggleBuilder.build());
                    continue;
                }
                if (List.class.isAssignableFrom(declaredField.getType())) {
                    ParameterizedType parameterizedType;
                    Class type;
                    Type listType = declaredField.getGenericType();
                    if (!(listType instanceof ParameterizedType) || !String.class.isAssignableFrom(type = (Class)(parameterizedType = (ParameterizedType)listType).getActualTypeArguments()[0])) continue;
                    StringListBuilder stringListBuilder = entryBuilder.startStrList((class_2561)class_2561.method_43470((String)declaredField.getName()), (List)declaredField.get(null)).setDefaultValue((List)declaredField.get(null)).setSaveConsumer(l -> ClothConfigCompat.setField(declaredField, l));
                    if (comment != null) {
                        stringListBuilder.setTooltip(new class_2561[]{class_2561.method_43470((String)comment.value())});
                    }
                    category.addEntry((AbstractConfigListEntry)stringListBuilder.build());
                    continue;
                }
                if (!Double.TYPE.isAssignableFrom(declaredField.getType())) continue;
                fieldBuilder = entryBuilder.startDoubleField((class_2561)class_2561.method_43470((String)declaredField.getName()), ((Double)declaredField.get(null)).doubleValue()).setDefaultValue(((Double)declaredField.get(null)).doubleValue()).setSaveConsumer(d -> ClothConfigCompat.setField(declaredField, d));
                if (comment != null) {
                    fieldBuilder.setTooltip(new class_2561[]{class_2561.method_43470((String)comment.value())});
                }
                category.addEntry((AbstractConfigListEntry)fieldBuilder.build());
            }
        }
        return builder;
    }

    private static void setField(Field field, Object value) {
        try {
            field.set(null, value);
            ConfigHelper.INSTANCE.save(StrawgolemConfig.class);
        }
        catch (IOException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

