/*
 * Decompiled with CFR 0.152.
 */
package xaero.minimap;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.minecraft.class_3264;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapCommonBase;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.setting.ObjectCategoryDefaultSettingsSetter;
import xaero.common.controls.ControlsRegister;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.FMLEventHandler;
import xaero.common.events.ForgeEventHandler;
import xaero.common.events.ModEvents;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.patreon.Patreon;
import xaero.common.patreon.PatreonMod;
import xaero.common.resource.ShaderResourceReloadListener;
import xaero.common.server.XaeroMinimapServer;
import xaero.common.server.core.XaeroMinimapServerCore;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.common.validator.WaypointCoordinateFieldValidator;
import xaero.minimap.XaeroMinimapClient;
import xaero.minimap.XaeroMinimapStandaloneSession;
import xaero.minimap.controls.MinimapControlsRegister;
import xaero.minimap.gui.MinimapGuiHelper;
import xaero.minimap.interfaces.MinimapInterfaceLoader;

public class XaeroMinimap
extends AXaeroMinimap
implements ClientModInitializer,
DedicatedServerModInitializer {
    public static XaeroMinimap instance;
    private static final String versionID_minecraft = "1.19.1";
    private static final String versionID_mod = "23.5.0";
    private static final boolean versionID_fair = false;
    public static final String versionID = "1.19.1_23.5.0_fabric";
    private int newestUpdateID;
    private boolean isOutdated = true;
    private String fileLayoutID = "minimap_fabric";
    private String latestVersion;
    private String latestVersionMD5;
    private ModSettings settings;
    private String message = "";
    private ControlsRegister controlsRegister;
    private ForgeEventHandler events;
    private FMLEventHandler fmlEvents;
    private ModEvents modEvents;
    private InterfaceManager interfaces;
    private InterfaceRenderer interfaceRenderer;
    private GuiHelper guiHelper;
    private FieldValidatorHolder fieldValidators;
    private SupportMods supportMods;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private EntityRadarCategoryManager entityRadarCategoryManager;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private boolean loadLaterNeeded;
    private boolean loadLaterDone;
    private XaeroMinimapServer minimapServer;
    private Throwable firstStageError;

    public void onInitializeClient() {
        INSTANCE = this;
        instance = this;
        try {
            SupportMods.checkForMinimapDuplicates();
            this.loadCommon();
            this.loadClient();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    public void onInitializeServer() {
        INSTANCE = this;
        instance = this;
        try {
            SupportMods.checkForMinimapDuplicates();
            this.loadCommon();
            this.loadServer();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    private Path getGameDir() {
        return FabricLoader.getInstance().getGameDir().normalize();
    }

    private void loadClient() throws IOException {
        ModOrigin origin;
        Path modFile;
        MinimapLogs.LOGGER.info("Loading Xaero's Minimap - Stage 1/2");
        ModOptions.init(this);
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(versionID.endsWith("fair") ? "xaerominimapfair" : "xaerominimap").orElse(null);
        if (modContainer == null) {
            modContainer = FabricLoader.getInstance().getModContainer("xaerodev").orElse(null);
        }
        Path path = modFile = (origin = modContainer.getOrigin()).getKind() == ModOrigin.Kind.PATH ? (Path)origin.getPaths().get(0) : null;
        if (modFile == null) {
            try {
                Class<?> quiltLoaderClass = Class.forName("org.quiltmc.loader.api.QuiltLoader");
                Method quiltGetModContainerMethod = quiltLoaderClass.getDeclaredMethod("getModContainer", String.class);
                Class<?> quiltModContainerAPIClass = Class.forName("org.quiltmc.loader.api.ModContainer");
                Method quiltGetSourcePathsMethod = quiltModContainerAPIClass.getDeclaredMethod("getSourcePaths", new Class[0]);
                Object quiltModContainer = ((Optional)quiltGetModContainerMethod.invoke(null, modContainer.getMetadata().getId())).orElse(null);
                List paths = (List)quiltGetSourcePathsMethod.invoke(quiltModContainer, new Object[0]);
                if (!paths.isEmpty() && !((List)paths.get(0)).isEmpty()) {
                    modFile = (Path)((List)paths.get(0)).get(0);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException quiltLoaderClass) {
                // empty catch block
            }
        }
        new XaeroMinimapClient().preInit(modContainer.getMetadata().getId(), this);
        String fileName = modFile.getFileName().toString();
        if (fileName.endsWith(".jar")) {
            this.modJAR = modFile.toFile();
        }
        Path gameDir = this.getGameDir();
        Path config = FabricLoader.getInstance().getConfigDir();
        this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
        Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
        Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
        Path wrongWaypointsFolder4 = new File(config.toFile().getCanonicalPath()).toPath().getParent().resolve("XaeroWaypoints");
        Path wrongWaypointsFolder5 = config.getParent().resolve("XaeroWaypoints");
        this.waypointsFolder = gameDir.resolve("XaeroWaypoints").toFile();
        if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
            Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
        }
        if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder4.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder4, this.waypointsFolder.toPath(), new CopyOption[0]);
        } else if (wrongWaypointsFolder5.toFile().exists() && !this.waypointsFolder.exists()) {
            Files.move(wrongWaypointsFolder5, this.waypointsFolder.toPath(), new CopyOption[0]);
        }
        Path waypointsFolderBackup062020 = this.waypointsFolder.toPath().resolveSibling(this.waypointsFolder.getName() + "_BACKUP032021");
        if (!Files.exists(waypointsFolderBackup062020, new LinkOption[0]) && this.waypointsFolder.exists()) {
            MinimapLogs.LOGGER.info("Backing up XaeroWaypoints...");
            SimpleBackup.copyDirectoryWithContents(this.waypointsFolder.toPath(), waypointsFolderBackup062020, 32, new CopyOption[0]);
            MinimapLogs.LOGGER.info("Done backing up XaeroWaypoints!");
        }
        this.configFile = config.resolve("xaerominimap.txt").toFile();
        File oldConfigFile = gameDir.resolve("config").resolve("xaerominimap.txt").toFile();
        if (oldConfigFile.exists() && !this.configFile.exists()) {
            Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
        }
        Patreon.checkPatreon();
        Patreon.setRendersCapes(this.fileLayoutID);
        this.widgetScreenHandler = new WidgetScreenHandler();
        this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
        this.controlsRegister = new MinimapControlsRegister();
        this.guiHelper = new MinimapGuiHelper(this);
        this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator(), new WaypointCoordinateFieldValidator());
        this.interfaceRenderer = new InterfaceRenderer(this);
        MinimapInterfaceLoader interfaceLoader = new MinimapInterfaceLoader();
        this.interfaces = new InterfaceManager(this, interfaceLoader);
        this.modEvents = new ModEvents(this);
        XaeroMinimapCore.modMain = this;
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ShaderResourceReloadListener());
        this.loadLaterNeeded = true;
    }

    @Override
    public void tryLoadLater() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        if (!this.loadLaterNeeded) {
            return;
        }
        this.loadLaterDone = true;
        MinimapLogs.LOGGER.info("Loading Xaero's Minimap - Stage 2/2");
        try {
            this.events = new ForgeEventHandler(this);
            this.fmlEvents = new FMLEventHandler(this);
        }
        catch (Throwable e) {
            MinimapLogs.LOGGER.error("suppressed exception", e);
        }
        try {
            PatreonMod patreonEntry;
            Path gameDir = this.getGameDir();
            File old_optionsFile = gameDir.resolve("xaerominimap.txt").toFile();
            if (old_optionsFile.exists() && !this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
                this.waypointsFile.getParentFile().mkdirs();
                Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            this.settings = new ModSettings(this);
            this.settings.loadSettings();
            this.entityRadarCategoryManager = EntityRadarCategoryManager.Builder.getDefault().setModMain(this).build();
            this.entityRadarCategoryManager.init();
            Internet.checkModVersion(this);
            if (this.isOutdated && (patreonEntry = this.getPatreon()) != null) {
                patreonEntry.modJar = this.modJAR;
                patreonEntry.currentVersion = versionID;
                patreonEntry.latestVersion = this.latestVersion;
                patreonEntry.md5 = this.latestVersionMD5;
                patreonEntry.onVersionIgnore = () -> {
                    ModSettings.ignoreUpdate = this.newestUpdateID;
                    try {
                        this.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                };
                Patreon.addOutdatedMod(patreonEntry);
            }
            this.supportMods = new SupportMods(this);
            if (this.supportMods.pac()) {
                this.supportMods.xaeroPac.registerOverMapRenderers(this.getInterfaces().getMinimapInterface().getOverMapRendererHandler());
            }
        }
        catch (Throwable e) {
            this.interfaces.getMinimapInterface().setCrashedWith(e);
        }
        this.loaded = true;
    }

    public void loadServer() {
        this.minimapServer = new XaeroMinimapServer(this);
        this.minimapServer.load();
        XaeroMinimapServerCore.minimapServer = this.minimapServer;
        this.loadLaterNeeded = true;
    }

    private void loadCommon() {
        new XaeroMinimapCommonBase().setup();
    }

    @Override
    public void tryLoadLaterServer() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        if (!this.loadLaterNeeded) {
            return;
        }
        this.loadLaterDone = true;
        this.minimapServer.loadLater();
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions_" + Patreon.getKEY_VERSION2() + "/Minimap.dat";
    }

    @Override
    public String getUpdateLink() {
        return "http://chocolateminecraft.com/update/minimap.html";
    }

    @Override
    public String getFileLayoutID() {
        return this.fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() throws IOException {
        this.settings = new ModSettings(this);
        this.settings.loadDefaultSettings();
        this.interfaces.getMinimapInterface().getInfoDisplayManager().reset();
        ObjectCategoryDefaultSettingsSetter defaultSettings = ObjectCategoryDefaultSettingsSetter.Builder.getDefault().setSettings(EntityRadarCategorySettings.SETTINGS).build();
        defaultSettings.setDefaultsFor(this.getEntityRadarCategoryManager().getRootCategory(), false);
        this.getEntityRadarCategoryManager().save();
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod getPatreon() {
        return (PatreonMod)Patreon.getMods().get(this.fileLayoutID);
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return MinimapControlsRegister.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    @Override
    public XaeroMinimapSession createSession() {
        return new XaeroMinimapStandaloneSession(this);
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public FMLEventHandler getFMLEvents() {
        return this.fmlEvents;
    }

    @Override
    public ModEvents getModEvents() {
        return this.modEvents;
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public ControlsRegister getControlsRegister() {
        return this.controlsRegister;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    @Override
    public void setLatestVersionMD5(String string) {
        this.latestVersionMD5 = string;
    }

    @Override
    public String getLatestVersionMD5() {
        return this.latestVersionMD5;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public EntityRadarCategoryManager getEntityRadarCategoryManager() {
        return this.entityRadarCategoryManager;
    }

    @Override
    public boolean isFairPlay() {
        XaeroMinimapSession session;
        return this.loaded && (session = XaeroMinimapSession.getCurrentSession()) != null && session.getMinimapProcessor().getFairPlayOnlyMessageReceived();
    }
}

