/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.icon.XaeroIcon;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.element.RadarElementReader;
import xaero.common.minimap.render.radar.element.RadarRenderContext;
import xaero.common.minimap.render.radar.element.RadarRenderProvider;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public final class RadarRenderer
extends MinimapElementRenderer<class_1297, RadarRenderContext> {
    private final AXaeroMinimap modMain;
    private final EntityIconManager entityIconManager;
    private final MinimapInterface minimapInterface;

    private RadarRenderer(AXaeroMinimap modMain, EntityIconManager entityIconManager, MinimapInterface minimapInterface, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.entityIconManager = entityIconManager;
        this.minimapInterface = minimapInterface;
    }

    @Override
    public void preRender(int location, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, AXaeroMinimap modMain, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        ModSettings settings = modMain.getSettings();
        this.entityIconManager.allowPrerender();
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
        if (settings.getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        class_1921 dotsRenderType = settings.getSmoothDots() ? CustomRenderTypes.GUI_BILINEAR : CustomRenderTypes.GUI_NEAREST;
        ((RadarRenderContext)this.context).setupGlobalContext(settings.getDotNameScale(), settings.getSmoothDots(), settings.debugEntityIcons, settings.debugEntityVariantIds, settings.getDotsStyle(), dotsRenderType, renderTypeBuffers.getBuffer(dotsRenderType), renderTypeBuffers.getBuffer(CustomRenderTypes.RADAR_NAME_BGS), multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR), renderEntity);
    }

    @Override
    public void postRender(int location, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, AXaeroMinimap modMain, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        if (((RadarRenderContext)this.context).reversedOrder) {
            renderTypeBuffers.method_22994(((RadarRenderContext)this.context).dotsRenderType);
        }
        multiTextureRenderTypeRenderers.draw(((RadarRenderContext)this.context).iconsRenderer);
        if (!((RadarRenderContext)this.context).reversedOrder) {
            renderTypeBuffers.method_22994(((RadarRenderContext)this.context).dotsRenderType);
        }
        renderTypeBuffers.method_22993();
        ((RadarRenderContext)this.context).renderEntity = null;
        ((RadarRenderContext)this.context).iconsRenderer = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, class_327 font, class_276 framebuffer, MinimapRendererHelper helper, class_1297 renderEntity, class_1657 player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, class_1297 e, double partialX, double partialY, boolean cave, float partialTicks) {
        double dotsScale;
        XaeroIcon entityHeadTexture;
        if (this.modMain.getSupportMods().pac() && e instanceof class_1657 && this.modMain.getSupportMods().xaeroPac.playerExists(e.method_5667())) {
            this.modMain.getSupportMods().xaeroPac.confirmPlayerRadarRender((class_1657)e);
            if (this.modMain.getSupportMods().worldmap() && this.modMain.getSupportMods().worldmapSupport.supportsPacPlayerRadarFilter()) {
                this.modMain.getSupportMods().worldmapSupport.confirmPlayerRadarRender((class_1657)e);
            }
        }
        float optionScaleAdjust = this.elementReader.getBoxScale(location, e, (RadarRenderContext)this.context);
        optionalScale *= optionScaleAdjust;
        RadarRenderContext context = (RadarRenderContext)this.context;
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        matrixStack.method_22903();
        boolean icon = context.icon;
        boolean name = context.name;
        XaeroIcon xaeroIcon = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, framebuffer, helper, (float)context.iconScale, context.debugEntityIcons, context.debugEntityVariantIds) : null;
        if (entityHeadTexture == EntityIconManager.DOT) {
            entityHeadTexture = null;
            icon = false;
        }
        if (entityHeadTexture == EntityIconManager.FAILED) {
            entityHeadTexture = null;
        }
        float offh = (float)(renderEntity.method_23318() - e.method_23318());
        matrixStack.method_22904(partialX, partialY, 0.0);
        if (entityHeadTexture != null) {
            float r;
            dotsScale = context.iconScale;
            double clampedScale = Math.max(1.0, dotsScale * (double)optionalScale);
            matrixStack.method_22905((float)clampedScale, (float)clampedScale, 1.0f);
            float brightness = context.minimapRadar.getEntityBrightness(offh, context.heightLimit, context.startFadingAt, context.heightBasedFade);
            if (!cave) {
                g = b = brightness;
                r = b;
                a = 1.0f;
            } else {
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
                a = brightness;
            }
            helper.prepareMyTexturedColoredModalRect(matrixStack.method_23760().method_23761(), -31.0f, -31.0f, entityHeadTexture.getOffsetX() + 1, entityHeadTexture.getOffsetY() + 1, 62.0f, 62.0f, 62.0f, entityHeadTexture.getTextureAtlas().getWidth(), entityHeadTexture.getTextureAtlas().getTextureId(), r, g, b, a, context.iconsRenderer);
        } else {
            boolean smooth = context.smoothDots;
            if (!smooth) {
                optionalScale = (float)Math.ceil(optionalScale);
            }
            matrixStack.method_22905(optionalScale, optionalScale, 1.0f);
            int dotSize = context.dotSize;
            if (icon && context.displayNameWhenIconFails) {
                name = true;
            }
            dotsScale = 1.0 + 0.5 * (double)(dotSize - 1);
            int color = context.minimapRadar.getEntityColour(player, e, offh, cave, context.entityCategory, context.heightLimit, context.startFadingAt, context.heightBasedFade, context.colorIndex);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            a = (float)(color >> 24 & 0xFF) / 255.0f;
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = optionalScale;
            if (context.dotsStyle == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale *= dotsScale;
                matrixStack.method_22905((float)dotsScale, (float)dotsScale, 1.0f);
            } else {
                switch (dotSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            helper.addTexturedColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), context.dotsBufferBuilder, dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, r, g, b, a, 256.0f);
        }
        matrixStack.method_22909();
        int displayY = context.displayY;
        if (name || displayY > 0) {
            matrixStack.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.method_22904((double)nameOffsetX, (double)nameOffsetY, optionalDepth);
            int offsetY = entityHeadTexture != null ? 11 : 5;
            matrixStack.method_22904(0.0, (double)Math.round((double)offsetY * dotsScale * (double)optionalScale), 0.0);
            optionalScale = (float)Math.ceil(optionalScale);
            double dotNameScale = context.nameScale * (double)optionalScale;
            matrixStack.method_22905((float)dotNameScale, (float)dotNameScale, 1.0f);
            Object yValueString = null;
            if (displayY > 0) {
                int yInt = (int)Math.floor(e.method_23318());
                int pYInt = (int)Math.floor(player.method_23318());
                yValueString = displayY == 1 ? "" + yInt : (displayY == 2 ? "" + (yInt - pYInt) : "");
                if (((String)(yValueString = (String)yValueString + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : "")))).length() == 0) {
                    yValueString = "-";
                }
            }
            if (name) {
                class_2561 component = Misc.getFixedDisplayName(e);
                if (component != null) {
                    Object entityName = component.getString();
                    if (displayY > 0) {
                        entityName = (String)entityName + "(" + yValueString + ")";
                    }
                    int nameW = font.method_1727((String)entityName);
                    helper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), context.nameBgBuilder, -nameW / 2 - 2, -1.0f, nameW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                    Misc.drawNormalText(matrixStack, (String)entityName, (float)(-nameW / 2), 0.0f, -1, false, renderTypeBuffers);
                }
            } else if (displayY > 0) {
                String yString = yValueString;
                int yStringW = font.method_1727(yString);
                helper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), context.nameBgBuilder, -yStringW / 2 - 2, -1.0f, yStringW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                Misc.drawNormalText(matrixStack, yString, (float)(-yStringW / 2), 0.0f, -1, false, renderTypeBuffers);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            matrixStack.method_22909();
        }
        return true;
    }

    public void renderEntityDotToFBO(int location, boolean highlit, class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_1297 e, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, class_4597.class_4598 textRenderTypeBuffer, class_1921 dotsRenderType, class_4588 dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, class_4588 nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, int displayY, EntityRadarCategory category, MinimapRendererHelper helper, class_327 font, class_276 framebuffer, float minimapScale) {
        ((RadarRenderContext)this.context).setupGlobalContext(dotNameScale, smooth, debug, debugEntityVariantIds, style, dotsRenderType, dotsBufferBuilder, nameBgBuilder, iconsRenderer, renderEntity);
        ((RadarRenderContext)this.context).minimapRadar = minimapRadar;
        ((RadarRenderContext)this.context).name = name;
        ((RadarRenderContext)this.context).icon = icon;
        ((RadarRenderContext)this.context).displayNameWhenIconFails = displayNameWhenIconFails;
        ((RadarRenderContext)this.context).heightLimit = heightLimit;
        ((RadarRenderContext)this.context).heightBasedFade = heightBasedFade;
        ((RadarRenderContext)this.context).startFadingAt = startFadingAt;
        ((RadarRenderContext)this.context).iconScale = iconScale;
        ((RadarRenderContext)this.context).dotSize = dotSize;
        ((RadarRenderContext)this.context).colorIndex = colorIndex;
        ((RadarRenderContext)this.context).displayY = displayY;
        ((RadarRenderContext)this.context).entityCategory = category;
        this.renderElement(location, highlit, false, matrixStack, textRenderTypeBuffer, font, framebuffer, helper, renderEntity, p, 0.0, 0.0, 0.0, 0, 0.0, minimapScale, e, 0.0, 0.0, cave, 1.0f);
        ((RadarRenderContext)this.context).renderEntity = null;
        ((RadarRenderContext)this.context).minimapRadar = null;
        ((RadarRenderContext)this.context).iconsRenderer = null;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.minimapInterface.usingFBO() && (location == 3 || location == 4 || this.modMain.getSettings().getEntityRadar());
    }

    public static final class Builder {
        private AXaeroMinimap modMain;
        private EntityIconManager entityIconManager;
        private MinimapInterface minimapInterface;

        private Builder() {
        }

        private Builder setDefault() {
            this.setEntityIconManager(null);
            return this;
        }

        public Builder setModMain(AXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setEntityIconManager(EntityIconManager entityIconManager) {
            this.entityIconManager = entityIconManager;
            return this;
        }

        public Builder setMinimapInterface(MinimapInterface minimapInterface) {
            this.minimapInterface = minimapInterface;
            return this;
        }

        public RadarRenderer build() {
            if (this.modMain == null || this.entityIconManager == null || this.minimapInterface == null) {
                throw new IllegalStateException();
            }
            RadarElementReader elementReader = new RadarElementReader();
            RadarRenderProvider provider = new RadarRenderProvider();
            RadarRenderContext context = new RadarRenderContext();
            return new RadarRenderer(this.modMain, this.entityIconManager, this.minimapInterface, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

