/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public final class StatUtils {
    private StatUtils() {
    }

    public static ArrayList<StatUtilsGeneralStat> getGeneralStats(class_3469 statHandler, Predicate<StatUtilsStat> filter) {
        ArrayList result = Lists.newArrayList();
        Objects.requireNonNull(statHandler, "statHandler must not be null.");
        ObjectArrayList statiList = new ObjectArrayList(class_3468.field_15419.iterator());
        statiList.sort(Comparator.comparing(stat -> TextUtils.translatable((String)StatUtils.getStatTranslationKey((class_3445<class_2960>)stat), (Object[])new Object[0]).getString()));
        ObjectListIterator statListIterator = statiList.iterator();
        while (statListIterator.hasNext()) {
            result.add(new StatUtilsGeneralStat(statHandler, (class_3445<class_2960>)((class_3445)statListIterator.next())));
        }
        if (filter != null) {
            result.removeIf(filter.negate());
        }
        return result;
    }

    public static LinkedHashMap<class_1761, ArrayList<StatUtilsItemStat>> getItemStats(class_3469 statHandler, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(null, new ArrayList());
        for (class_1792 itemReg : class_2378.field_11142) {
            StatUtilsItemStat itemStat = new StatUtilsItemStat(statHandler, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            if (!result.containsKey(itemReg.method_7859())) {
                result.put(itemReg.method_7859(), Lists.newArrayList());
            }
            ((ArrayList)result.get(itemReg.method_7859())).add(itemStat);
        }
        if (((ArrayList)result.get(null)).size() == 0) {
            result.remove(null);
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<StatUtilsMobStat>> getMobStats(class_3469 statHandler, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        String mcModId = new class_2960("air").method_12836();
        result.put(mcModId, Lists.newArrayList());
        for (class_1299 entityType : class_2378.field_11145) {
            if (entityType != class_1299.field_6097 && !entityType.method_5896()) continue;
            StatUtilsMobStat mobStat = new StatUtilsMobStat(statHandler, entityType);
            if (filter != null && !filter.test(mobStat)) continue;
            String entityModId = class_1299.method_5890((class_1299)entityType).method_12836();
            if (!result.containsKey(entityModId)) {
                result.put(entityModId, Lists.newArrayList());
            }
            ArrayList resultList = (ArrayList)result.get(entityModId);
            resultList.add(mobStat);
        }
        if (((ArrayList)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<StatUtilsItemStat>> getItemStatsByMods(class_3469 statHandler, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        String mcModId = new class_2960("air").method_12836();
        result.put(mcModId, Lists.newArrayList());
        for (class_1792 itemReg : class_2378.field_11142) {
            StatUtilsItemStat itemStat = new StatUtilsItemStat(statHandler, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            String itemModId = class_2378.field_11142.method_10221((Object)itemReg).method_12836();
            if (!result.containsKey(itemModId)) {
                result.put(itemModId, Lists.newArrayList());
            }
            ArrayList resultList = (ArrayList)result.get(itemModId);
            resultList.add(itemStat);
        }
        if (((ArrayList)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static String getStatTranslationKey(class_3445<class_2960> stat) {
        return "stat." + ((class_2960)stat.method_14951()).toString().replace(':', '.');
    }

    public static String getModName(String modId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{modId})) {
            return "*";
        }
        Optional container = FabricLoader.getInstance().getModContainer(modId);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        return modId;
    }

    public static class StatUtilsGeneralStat
    extends StatUtilsStat {
        public final class_3445<class_2960> stat;
        public final int intValue;
        public final class_5250 value;
        public final boolean isEmpty;

        public StatUtilsGeneralStat(class_3469 statHandler, class_3445<class_2960> generalStat) {
            super(Objects.requireNonNull(statHandler, "statHandler must not be null."), (class_2561)TextUtils.fTranslatable((String)StatUtils.getStatTranslationKey(Objects.requireNonNull(generalStat, "generalStat must not be null.")), (Object[])new Object[0]));
            this.stat = generalStat;
            this.intValue = statHandler.method_15025(this.stat);
            this.value = TextUtils.literal((String)this.stat.method_14953(this.intValue));
            this.isEmpty = this.intValue == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static class StatUtilsItemStat
    extends StatUtilsStat {
        public final class_1792 item;
        public final class_2248 block;
        public final int sMined;
        public final int sCrafted;
        public final int sUsed;
        public final int sBroken;
        public final int sPickedUp;
        public final int sDropped;
        public final boolean isEmpty;

        public StatUtilsItemStat(class_3469 statHandler, class_1792 item) {
            super(Objects.requireNonNull(statHandler, "statHandler must not be null."), (class_2561)TextUtils.fTranslatable((String)Objects.requireNonNull(item, "item must not be null.").method_7876(), (Object[])new Object[0]));
            this.item = item;
            this.block = class_2248.method_9503((class_1792)item);
            this.sMined = this.block == null || this.block.method_9564().method_26215() ? 0 : statHandler.method_15024(class_3468.field_15427, (Object)this.block);
            this.sCrafted = statHandler.method_15024(class_3468.field_15370, (Object)item);
            this.sUsed = statHandler.method_15024(class_3468.field_15372, (Object)item);
            this.sBroken = statHandler.method_15024(class_3468.field_15383, (Object)item);
            this.sPickedUp = statHandler.method_15024(class_3468.field_15392, (Object)item);
            this.sDropped = statHandler.method_15024(class_3468.field_15405, (Object)item);
            this.isEmpty = this.sMined == 0 && this.sCrafted == 0 && this.sUsed == 0 && this.sBroken == 0 && this.sPickedUp == 0 && this.sDropped == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static class StatUtilsMobStat
    extends StatUtilsStat {
        public final class_1299<?> entityType;
        public final int killed;
        public final int killedBy;
        public final boolean isEmpty;

        public StatUtilsMobStat(class_3469 statHandler, class_1299<?> entityType) {
            super(Objects.requireNonNull(statHandler, "statHandler must not be null."), (class_2561)TextUtils.fTranslatable((String)Objects.requireNonNull(entityType, "entityType must not be null.").method_5882(), (Object[])new Object[0]));
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            this.killed = statHandler.method_15024(class_3468.field_15403, entityType);
            this.killedBy = statHandler.method_15024(class_3468.field_15411, entityType);
            this.isEmpty = this.killed == 0 && this.killedBy == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static abstract class StatUtilsStat {
        public final class_3469 statHandler;
        public final class_2561 label;
        private final String sqLabel;

        public StatUtilsStat(class_3469 statHandler, class_2561 label) {
            this.statHandler = statHandler;
            this.label = Objects.requireNonNull(label, "label must not be null.");
            this.sqLabel = this.label.getString().toLowerCase().replaceAll("\\s+", "");
        }

        public abstract boolean isEmpty();

        public final boolean matchesSearchQuery(String search) {
            search = search.toLowerCase().replaceAll("\\s+", "");
            return search.startsWith(this.sqLabel);
        }
    }
}

