/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.util;

import io.github.thecsdev.betterstats.BetterStats;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class BSClientHttpUtils {
    private static final int TIMEOUT = 5;

    protected BSClientHttpUtils() {
    }

    public static void getAsync(String url, BiConsumer<Boolean, String> onReady) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(onReady);
        class_310 mc = class_310.method_1551();
        class_156.method_27958().execute(() -> {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("User-Agent", BetterStats.getInstance().contact_sources);
            boolean success = false;
            String result = null;
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                success = true;
            }
            catch (IOException response) {
                // empty catch block
            }
            boolean a = success;
            String b = result;
            mc.execute(() -> onReady.accept(a, b));
        });
    }

    public static void getRemotePlayerBadgesAsync(UUID playerUUID, BiConsumer<Boolean, Set<class_2960>> onReady) {
        Objects.requireNonNull(playerUUID);
        Objects.requireNonNull(onReady);
        String puidStr = playerUUID.toString();
        String puidHash = DigestUtils.sha256Hex((String)puidStr);
        String webhookUrl = BetterStats.getInstance().contact_playerBadgeWebhook + "/api/v1/player_badges/" + puidHash + ".txt";
        BSClientHttpUtils.getAsync(webhookUrl, (success, response) -> {
            String[] badgeList;
            if (!success.booleanValue() || StringUtils.isBlank((CharSequence)response)) {
                onReady.accept(false, null);
                return;
            }
            response = response.trim();
            HashSet<class_2960> badges = new HashSet<class_2960>();
            for (String badgeItem : badgeList = response.split("\\R")) {
                try {
                    badges.add(new class_2960(badgeItem));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            onReady.accept(true, badges);
        });
    }
}

