/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3469;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public abstract class BSHudStatWidget
extends TElement {
    public static final int SIZE = 21;
    public static final int DRAG_STEP = 5;
    protected double anchorX;
    protected double anchorY;
    protected final class_3469 statHandler;
    protected int dragOffMouseX;
    protected int dragOffMouseY;

    public BSHudStatWidget(int x, int y, class_3469 statHandler) {
        super(x, y, 21, 21);
        this.statHandler = Objects.requireNonNull(statHandler, "statHandler must not be null.");
        this.eChildAdded.register((element, child, repositioned) -> {
            TElement lastChild = child.previous();
            if (!this.getTChildren().contains((Object)lastChild)) {
                child.setPosition(0, 0, true);
            } else {
                child.setPosition(lastChild.getTpeEndX(), this.getTpeY(), false);
            }
        });
    }

    public void updateRenderingBoundingBox() {
        this.RENDER_RECT.setLocation(this.x, this.y);
        this.RENDER_RECT.setSize(this.width, this.height);
    }

    public void onParentChanged() {
        if (this.getTParent() != null) {
            this.init();
        }
    }

    public boolean reCalculateAnchor() {
        if (this.screen == null) {
            return false;
        }
        int sW = this.screen.getTpeWidth();
        int sH = this.screen.getTpeHeight();
        this.anchorX = (sW -= this.getTpeWidth()) > 0 ? (double)this.getTpeX() / (double)sW : 0.0;
        this.anchorY = sH > 0 ? (double)this.getTpeY() / (double)(sH -= this.getTpeHeight()) : 0.0;
        return true;
    }

    public boolean rePositionToAnchor() {
        if (this.screen == null) {
            return false;
        }
        int sW = this.screen.getTpeWidth();
        int sH = this.screen.getTpeHeight();
        int x = (int)(this.anchorX * (double)(sW -= this.getTpeWidth()));
        int y = (int)(this.anchorY * (double)(sH -= this.getTpeHeight()));
        this.setPosition(x, y, false);
        return true;
    }

    public final void init() {
        this.clearTChildren();
        this.onInit();
        this.reAlignElements();
        this.updateRenderingBoundingBox();
        this.forEachChild(child -> {
            child.updateRenderingBoundingBox();
            return false;
        }, true);
        this.tick();
    }

    public abstract void onInit();

    public void reAlignElements() {
        TElement last = null;
        for (TElement child : this.getTChildren()) {
            if (last == null) {
                child.setPosition(0, 0, true);
            } else {
                child.setPosition(last.getTpeEndX(), this.getTpeY(), false);
            }
            last = child;
        }
        this.width = last == null ? 21 : Math.abs(last.getTpeEndX() - this.getTpeX());
        this.updateRenderingBoundingBox();
    }

    public ItemEntry addItemEntry(class_1792 item) {
        return new ItemEntry(item);
    }

    public EntityEntry addEntityEntry(class_1299<?> entityType) {
        return new EntityEntry(entityType);
    }

    protected void onContextMenu(TContextMenuPanel contextMenu) {
        super.onContextMenu(contextMenu);
        if (contextMenu.getTChildren().size() > 0) {
            contextMenu.addSeparator();
        }
        contextMenu.addButton((class_2561)TextUtils.translatable((String)"selectWorld.deleteButton", (Object[])new Object[0]), btn -> {
            if (this.getTParent() != null) {
                this.getTParent().removeTChild((TElement)this);
            }
        });
    }

    public boolean mousePressed(int mouseX, int mouseY, int button) {
        if (button == 1) {
            this.showContextMenu(mouseX, mouseY);
            return true;
        }
        this.dragOffMouseX = mouseX - this.getTpeX();
        this.dragOffMouseY = mouseY - this.getTpeY();
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        int targetX = (int)mouseX - this.dragOffMouseX;
        int targetY = (int)mouseY - this.dragOffMouseY;
        targetX -= targetX % 5;
        targetY -= targetY % 5;
        this.setPosition(targetX, targetY, false);
        this.reCalculateAnchor();
        return true;
    }

    public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
        BSHudStatWidget.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)0x50000000);
        BSHudStatWidget.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + 21), (int)(this.y + this.height), (int)0x50000000);
        if (this.isFocusedOrHovered()) {
            this.drawOutline(matrices, -1);
        }
    }

    protected class ItemEntry
    extends TElement {
        protected class_1799 stack;

        public ItemEntry(class_1792 item) {
            super(0, 0, 21, 21);
            if (item == null) {
                item = class_1802.field_8162;
            }
            this.stack = item.method_7854();
            BSHudStatWidget.this.addTChild(this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY();
        }

        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            this.getItemRenderer().method_4010(this.stack, this.getTpeX() + 3, this.getTpeY() + 3);
        }
    }

    protected class EntityEntry
    extends TEntityRendererElement {
        public EntityEntry(class_1299<?> entityType) {
            super(0, 0, 21, 21, entityType);
            BSHudStatWidget.this.addTChild((TElement)this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY();
        }

        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, this.getTpeX() + 150, this.getTpeY() + 55, deltaTime);
        }
    }

    protected class LabelEntry
    extends TLabelElement {
        protected int txt_width;

        public LabelEntry(class_2561 text) {
            super(0, 0, 21, 21, text);
            BSHudStatWidget.this.addTChild((TElement)this);
        }

        public boolean isClickThrough() {
            return true;
        }

        public int getTpeY() {
            return BSHudStatWidget.this.getTpeY() + 1;
        }

        protected void setTpeWidth(int width) {
            this.width = width;
            this.updateRenderingBoundingBox();
            BSHudStatWidget.this.reAlignElements();
        }

        public void setText(class_2561 label) {
            int w;
            super.setText(label);
            int n = w = label != null ? this.getTextRenderer().method_27525((class_5348)label) : 0;
            if (w != this.txt_width) {
                this.setTpeWidth(w + 10);
            }
            this.txt_width = w;
        }

        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            this.drawTElementText(matrices, this.getText(), this.getHorizontalAlignment(), this.getColor(), 5, deltaTime);
        }
    }
}

